#ifndef	MDL_H
#define	MDL_H

/*
 * ============================================================================
 * structures
 * ============================================================================
 */
#define MAGIC_MDL_Q1	MKID('I','D','P','O')	/* 0x4944504F */
#define MAGIC_MDL_Q2	MKID('I','D','P','2')	/* 0x4944504F */

#define MDL_VERSION_Q1	6
#define MDL_VERSION_Q2	8

#define MDL_ONSEAM	0x0020

typedef enum {
  ST_SYNC = 0, ST_RAND
} synctype_t;

typedef enum {
  MDL_SINGLE = 0, MDL_GROUP
} aliasframetype_t;

typedef enum {
  MDL_SKIN_SINGLE = 0, MDL_SKIN_GROUP
} aliasskintype_t;

struct mdlheader {
  int ident;
  int version;
  vec3_t scale;
  vec3_t scale_origin;
  float boundingradius;
  vec3_t eyeposition;
  int numskins;
  int skinwidth;
  int skinheight;
  int numverts;
  int numtris;
  int numframes;
  synctype_t synctype;
  int flags;
  float size;
};

struct stvert {
  int onseam;
  int s;
  int t;
};

/*
 * disk-structures
 */

struct dtriangle {
  int facesfront;
  int vertindex[3];
};

#define DT_FACES_FRONT				0x0010

struct trivertex {
  unsigned char v[3];
  unsigned char lightnormalindex;
};

struct daliasframe {
  struct trivertex bboxmin;					/* lightnormal isn't used */
  struct trivertex bboxmax;					/* lightnormal isn't used */

  char name[16];						/* frame name from grabbing */
};

struct daliasgroup {
  int numframes;

  struct trivertex bboxmin;					/* lightnormal isn't used */
  struct trivertex bboxmax;					/* lightnormal isn't used */
};

struct daliasskingroup {
  int numskins;
};

struct daliasinterval {
  float interval;
};

struct daliasskininterval {
  float interval;
};

struct daliasframetype {
  aliasframetype_t type;
};

struct daliasskintype {
  aliasskintype_t type;
};

/*
 * local program-structures
 */

struct aliaspackage {
  /* single frame or group of frames */
  aliasframetype_t type;
  /* either a daliasframe_t or group info */
  void *pdata;
  /* only used for frames in groups */
  float interval;
  /* only used by group headers */
  int numgroupframes;

  char name[16];
} __packed;

struct aliasskinpackage {
  /* single skin or group of skiins */
  aliasskintype_t type;
  /* either a daliasskinframe_t or group info */
  void *pdata;
  /* only used for skins in groups */
  float interval;
  /* only used by group headers */
  int numgroupskins;
} __packed;

struct vertexnormals {
  int numnormals;
  float normals[20][3];
} __packed;

struct trivert {
  vec3_t v;

  int lightnormalindex;
} __packed;

/*
 * ============================================================================
 * globals
 * ============================================================================
 */

/*
 * ============================================================================
 * prototypes
 * ============================================================================
 */

#endif
