#ifndef	TDS_H
#define	TDS_H

/* trilib.h: header file for loading triangles from an Alias triangle file */

/*
 * ============================================================================
 * structures
 * ============================================================================
 */

#define MAGIC_TRI	123322

struct triangle {
  vec3_t verts[3];
};

#define	FLOAT_START	99999.0
#define	FLOAT_END	-FLOAT_START

struct aliaspoint {
  /* normal */
  vec3_t n;
  /* point */
  vec3_t p;
  /* color */
  vec3_t c;
  /* u */
  float u;
  /* v */
  float v;
};

/*
 * ============================================================================
 * globals
 * ============================================================================
 */

/*
 * ============================================================================
 * prototypes
 * ============================================================================
 */

bool LoadTriangleList(__memBase, char *fileName);

#endif
