#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define	DEBUG

#ifdef	DEBUG
#define	dprintf	printf
#define	dsprintf sprintf
#define	dfwrite fwrite
#else
#define	dprintf
#define	dsprintf
#define	dfwrite
#endif

#ifndef	BITSPERBYTE
#define	BITSPERBYTE	8
#endif
#ifndef	BITSPERINT
#define	BITSPERINT	32
#endif

#define	INDEX_BITS	2
#define	INDEX_MASK	((1 << INDEX_BITS) - 1)
#define	INDEX_LENGTH	(BITSPERINT / INDEX_BITS)

#define	HISTORY_BITS	16
#define	HISTORY_MASK	((1 << HISTORY_BITS) - 1)
#define	HISTORY_LENGTH	HISTORY_MASK

#define	MATCHLEN_BITS	8
#define	MATCHLEN_MASK	((1 << MATCHLEN_BITS) - 1)
#define	MATCHLEN_LENGTH	MATCHLEN_MASK

#define	LITERAL_BITS	8
#define	LITERAL_MASK	((1 << LITERAL_BITS) - 1)
#define	LITERAL_LENGTH	LITERAL_MASK

#define	MIN_MATCH	((HISTORY_BITS + MATCHLEN_BITS) / BITSPERBYTE)
#define	MAX_MATCH	(MATCHLEN_LENGTH + MIN_MATCH)

#define	MAX_REVIEW	3

char rawfmt[] = " match %%%ds with %%%ds (%%d bytes)\n";	/* " match %?s with %?s (%d bytes)\n" */
char fmt[256];

int main(int argc, char **argv)
{
  FILE *inFile, *outFile;
  int inSize, outSize;
  unsigned char *inMem, *outMem, *parseMem, *pasteMem;
  int i, j, history, indexPos;
  unsigned int index;
  unsigned int *indexMem;

#if	(MAX_REVIEW > 1)
  struct {
    unsigned char *revParse;					/* parsed position for matchlen */
    int revMatch;						/* reviewed matchlen */
    int revOffset;						/* reviewed matchoffset */
  } reviewed[MAX_REVIEW] = {
    {
      0, 0, 0
    },
    {
      0, 0, 0
    },
    {
      0, 0, 0
    }
  };
#endif								/* (MAX_REVIEW > 1) */

  /* open the files */
  inFile = fopen(argv[1], "r");
  outFile = fopen(argv[2], "w");

  /* get filesize */
  fseek(inFile, 0, SEEK_END);
  inSize = outSize = ftell(inFile);
  fseek(inFile, 0, SEEK_SET);

  /* allocate structures */
  inMem = malloc(inSize);
  outMem = malloc(outSize);

  /* read input */
  fread(inMem, 1, inSize, inFile);

  dprintf("input %s (%d bytes)\n", argv[1], inSize);

  /* set start-points */
  parseMem = inMem;
  pasteMem = outMem;
  history = 0;
  /* store the inde before each block */
  indexMem = ((unsigned int *)pasteMem)++;
  index = 0;
  indexPos = INDEX_LENGTH - 1;

  i = inSize;
  while (i > 0) {
    int oldMatch = MIN_MATCH - 1, oldOffset;
    unsigned short int k;

    void BestMatch(void) {
      /* TODO: implement hash-restore here */

      unsigned char *beginHist = parseMem - history;
      /* characters after first character */
      unsigned char *beginPars = parseMem;

      while (beginHist < parseMem) {
	/* compare with first character */
	if (*((unsigned short int *)(beginHist + 0)) ==
	    *((unsigned short int *)(beginPars + 0))) {
	  /* compare with last character */
	  if (*((unsigned short int *)(beginHist + oldMatch - 1)) ==
	      *((unsigned short int *)(beginPars + oldMatch - 1))) {
	    /* do not invalidate flowing beginHist and constant beginPars */
	    unsigned char *newHist = beginHist + 2;
	    unsigned char *newPars = beginPars + 2;
	    /* calculate negative offset */
	    int newOffset = newHist - newPars;
	    /* first byte allready parsed */
	    int newMatch = 2;

	    /* hopefully execute from left to right */
	    /* compare with characters after first character */
	    while ((newMatch < MAX_MATCH) && (*newHist++ == *newPars++))
	        newMatch++;

	    /* protect against underflow */
	    if (newHist > (outMem + outSize))
	        newMatch = -newOffset;

	    if (newMatch >= MIN_MATCH) {
	      if (newMatch > oldMatch) {
		oldOffset = newOffset;
		if ((oldMatch = newMatch) >= MAX_MATCH) {
		  oldMatch = MAX_MATCH;
		  /* do not continue if maximum matchlength reached */
		  break;
		}
	      }
	    }
	  }
	  beginHist++;
	}
      }
    }

    void StoreMatch(void) {
      /* TODO: implement hash-store here */

      if (oldMatch >= MIN_MATCH) {
	int orIndex;
	int setMatch = oldMatch - MIN_MATCH + 1;

	if ((setMatch <= 0x3) && (oldOffset >= 0xFFFFC000)) {
	  *((unsigned short int *)pasteMem)++ = (unsigned short int)((((unsigned short int)oldOffset) << 2) | (setMatch));
	  orIndex = (0x1 << (indexPos * INDEX_BITS));
	}
	else if ((setMatch <= 0xF) && (oldOffset >= 0xFFFFF000)) {
	  *((unsigned short int *)pasteMem)++ = (unsigned short int)((((unsigned short int)oldOffset) << 4) | (setMatch));
	  orIndex = (0x2 << (indexPos * INDEX_BITS));
	}
	else {
	  /* store 16bit history */
	  *((unsigned short int *)pasteMem)++ = (unsigned short int)(oldOffset);
	  /* store 8bit length */
	  *pasteMem++ = (unsigned char)(setMatch - 1);
	  orIndex = (0x3 << (indexPos * INDEX_BITS));
	}
	parseMem += oldMatch;

	i -= oldMatch;
	history += oldMatch;
	index |= orIndex;
      }
      else {
	/* store 8bit literal */
	*pasteMem++ = *parseMem++;

	i -= 1;
	history += 1;
//      index |= (0x0 << (indexPos * INDEX_BITS));
      }

      /* flush index if full */
      if (--indexPos < 0) {
	*indexMem = index;
	indexMem = ((unsigned int *)pasteMem)++;
	index = 0;
	indexPos = INDEX_LENGTH - 1;
      }

      /* let history be smaller than allowed length */
      if (history > HISTORY_LENGTH)
	history = HISTORY_LENGTH;

      /* brute break if destination overflow, TODO: clean break, not abort() */
      if (pasteMem >= (outMem + outSize))
	abort();
    }

    /* set initial match */
    BestMatch();
#if	(MAX_REVIEW > 1)
    if (oldMatch < MAX_MATCH) {
      /* store old state */
      reviewed[0].revMatch = oldMatch;
      reviewed[0].revOffset = oldOffset;
      /* begin with next */
      parseMem++;

      /* we leave this loop only if none of the next two tries matches better */
      for (k = 1; k < MAX_REVIEW; k++) {
	BestMatch();

	/* match is better, store */
	if ((oldMatch - k) > reviewed[0].revMatch) {
	  reviewed[0].revMatch = oldMatch;
	  reviewed[0].revOffset = oldOffset;
	  oldMatch = MIN_MATCH - 1;
	  parseMem -= k;

	  /* store every previous try */
	  for (; k >= 1; k--)
	    StoreMatch();

	  /* brute break if match reaches maximum */
	  if (oldMatch >= MAX_MATCH) {
	    k = 0;
	    break;
	  }
	}
	/* match is not better, try next one */
	else
	  parseMem++;
      }

      /* none of the two tries matches better, so rewind both tries (means three bytes) */
      parseMem -= k;
      /* restore old state */
      oldOffset = reviewed[0].revOffset;
      oldMatch = reviewed[0].revMatch;
    }
#endif								/* (MAX_REVIEW > 1) */
    /* save last match */
    StoreMatch();
  }
  /* flush index */
  index |= (0x3 << (indexPos * INDEX_BITS));
  *indexMem = index;

  /* get size */
  outSize = pasteMem - outMem;

  /* write output */
  fwrite(&inSize, 1, sizeof(int), outFile);

  fwrite(outMem, 1, outSize, outFile);

  dprintf("output %s (%d bytes)\n", argv[2], outSize);

  /* close the files */
  fclose(inFile);
  fclose(outFile);
};
