#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define	DEBUG

#ifdef	DEBUG
#define	dprintf	printf
#define	dsprintf sprintf
#define	dfwrite fwrite
#else
#define	dprintf
#define	dsprintf
#define	dfwrite
#endif

#ifndef	BITSPERBYTE
#define	BITSPERBYTE	8
#endif
#ifndef	BITSPERINT
#define	BITSPERINT	32
#endif

#define	INDEX_BITS	2
#define	INDEX_MASK	((1 << INDEX_BITS) - 1)
#define	INDEX_LENGTH	(BITSPERINT / INDEX_BITS)

#define	HISTORY_BITS	16
#define	HISTORY_MASK	((1 << HISTORY_BITS) - 1)
#define	HISTORY_LENGTH	HISTORY_MASK

#define	MATCHLEN_BITS	8
#define	MATCHLEN_MASK	((1 << MATCHLEN_BITS) - 1)
#define	MATCHLEN_LENGTH	MATCHLEN_MASK

#define	LITERAL_BITS	8
#define	LITERAL_MASK	((1 << LITERAL_BITS) - 1)
#define	LITERAL_LENGTH	LITERAL_MASK

#define	MIN_MATCH	((HISTORY_BITS + MATCHLEN_BITS) / BITSPERBYTE)
#define	MAX_MATCH	(MATCHLEN_LENGTH + MIN_MATCH)

char rawfmt[] = " match %%%ds with %%%ds (%%d bytes)\n";	/* " match %?s with %?s (%d bytes)\n" */
char fmt[256];

int main(int argc, char **argv)
{
  FILE *inFile, *outFile;
  int inSize, outSize;
  unsigned char *inMem, *outMem, *parseMem, *pasteMem;
  int i, j, history, indexPos;
  unsigned int index;
  unsigned int *indexMem;

  /* open the files */
  inFile = fopen(argv[1], "r");
  outFile = fopen(argv[2], "w");

  /* get filesize */
  fseek(inFile, 0, SEEK_END);
  inSize = outSize = ftell(inFile);
  fseek(inFile, 0, SEEK_SET);

  /* allocate structures */
  inMem = malloc(inSize);
  outMem = malloc(outSize);

  /* read input */
  fread(inMem, 1, inSize, inFile);

  dprintf("input %s (%d bytes)\n", argv[1], inSize);

  /* set start-points */
  parseMem = inMem;
  pasteMem = outMem;
  history = 0;
  /* store the inde before each block */
  indexMem = ((unsigned int *)pasteMem)++;
  index = 0;
  indexPos = INDEX_LENGTH - 1;

  for (i = inSize - 1, j = outSize - 1; (i >= 0) && (j >= 0);) {
    int oldMatch = 0, oldOffset;
    unsigned char *beginHist = parseMem - history;

    /* characters after first character */
    unsigned char *beginPars = parseMem;

    while (beginHist < parseMem) {
      /* compare with first character */
      if (((unsigned short int *)beginHist)[0] ==
	  ((unsigned short int *)beginPars)[0]) {
	/* compare with last character */
	if (((unsigned short int *)beginHist)[oldMatch - 1] ==
	    ((unsigned short int *)beginPars)[oldMatch - 1]) {
	  /* do not invalidate flowing beginHist and constant beginPars */
	  unsigned char *newHist = beginHist + 2;
	  unsigned char *newPars = beginPars + 2;

	  /* calculate negative offset */
	  int newOffset = newHist - newPars;

#if 1
	  /* first byte allready parsed */
	  int newMatch = 2;

	  //dprintf(" try \"%c%c%c\" with \"%c%c%c\"\n",
	  //        beginHist[-2], beginHist[-1], beginHist[0],
	  //        beginPars[-2], beginPars[-1], beginPars[0]);
	  /* hopefully execute from left to right */
	  /* compare with characters after first character */
	  while ((newMatch < MAX_MATCH) && (*newHist++ == *newPars++))
	    newMatch++;

	  /* protect against underflow */
	  if (newHist > (outMem + outSize))
	    newMatch = newOffset;

	  if ((newMatch > MIN_MATCH) && (newMatch > oldMatch)) {
	    //dprintf("match \"");
	    //dfwrite(beginHist - 2, 1, newMatch, stdout);
	    //dprintf("\" with \"");
	    //dfwrite(beginPars - 2, 1, newMatch, stdout);
	    //dprintf("\" (%d bytes, %d offset)\n", newMatch, newOffset);

	    oldOffset = newOffset;
	    if ((oldMatch = newMatch) >= MAX_MATCH) {
	      oldMatch = MAX_MATCH;
	      /* do not continue if maximum matchlength reached */
	      break;
	    }
	  }
#else
	  /* first byte allready parsed, second byte for ">=" */
	  int newMatch = MAX_MATCH - 2 - 1;

	  //dprintf(" try \"%c%c%c\" with \"%c%c%c\"\n",
	  //        beginHist[-2], beginHist[-1], beginHist[0],
	  //        beginPars[-2], beginPars[-1], beginPars[0]);
	  /* hopefully execute from left to right */
	  /* compare with characters after first character */
	  while ((newMatch >= 0) && (*newHist++ == *newPars++))
	    newMatch--;

	  /* protect against underflow */
	  if (newHist > (inMem + inSize))
	    newMatch = newOffset;
	  else
	    newMatch = (MAX_MATCH - 1) - newMatch;

	  if ((newMatch > MIN_MATCH) && (newMatch > oldMatch)) {
	    //dprintf("match \"");
	    //dfwrite(beginHist - 2, 1, newMatch, stdout);
	    //dprintf("\" with \"");
	    //dfwrite(beginPars - 2, 1, newMatch, stdout);
	    //dprintf("\" (%d bytes, %d offset)\n", newMatch, newOffset);

	    oldOffset = newOffset;
	    if ((oldMatch = newMatch) >= MAX_MATCH) {
	      oldMatch = MAX_MATCH;
	      /* do not continue if maximum matchlength reached */
	      break;
	    }
	  }
#endif
	}
      }
      beginHist++;
    }

    if (oldMatch >= MIN_MATCH) {
      int orIndex;
      int setMatch = oldMatch - MIN_MATCH + 1;

      if ((setMatch <= 0x3) && (oldOffset >= 0xFFFFC000)) {
	*((unsigned short int *)pasteMem)++ = (unsigned short int)((((unsigned short int)oldOffset) << 2) | (setMatch));
	orIndex = (0x1 << (indexPos * INDEX_BITS));
      }
      else if ((setMatch <= 0xF) && (oldOffset >= 0xFFFFF000)) {
	*((unsigned short int *)pasteMem)++ = (unsigned short int)((((unsigned short int)oldOffset) << 4) | (setMatch));
	orIndex = (0x2 << (indexPos * INDEX_BITS));
      }
      else {
	/* store 16bit history */
	*((unsigned short int *)pasteMem)++ = (unsigned short int)(oldOffset);
	/* store 8bit length */
	*pasteMem++ = (unsigned char)(setMatch - 1);
	orIndex = (0x3 << (indexPos * INDEX_BITS));
      }
      parseMem += oldMatch;

      i -= oldMatch;
      j -= MIN_MATCH;
      history += oldMatch;
      index |= orIndex;
    }
    else {
      /* store 8bit literal */
      *pasteMem++ = *parseMem++;

      i -= 1;
      j -= 1;
      history += 1;
//    index |= (0x0 << (indexPos * INDEX_BITS));
    }

    if (--indexPos < 0) {
      *indexMem = index;
      indexMem = ((unsigned int *)pasteMem)++;
      index = 0;
      indexPos = INDEX_LENGTH - 1;
    }

    if (history > HISTORY_LENGTH)
      history = HISTORY_LENGTH;
  }
  /* flush index */
  index |= (0x3 << (indexPos * INDEX_BITS));
  *indexMem = index;

  /* get size */
  outSize = pasteMem - outMem;

  /* write output */
  fwrite(&inSize, 1, sizeof(int), outFile);

  fwrite(outMem, 1, outSize, outFile);

  dprintf("output %s (%d bytes)\n", argv[2], outSize);

  /* close the files */
  fclose(inFile);
  fclose(outFile);
};
