static void BuildSky8(unsigned char *out, unsigned char *in)
{
  __memcpy(out, in, SKY_X * SKY_Y * sizeof(unsigned char));
}

static void BuildLightBlock8(unsigned char *out, struct bitmap *raw, int x, int y)
{
  int c, dc;
  int a, b, h, c0, c1, c2, c3;
  int y_max = raw->height, x_max = raw->width;
  unsigned char *fullbright = raw->data + lookup(y, raw->width);

  c0 = ((255 << 6) - lightmapIndex[0]);
  c1 = ((255 << 6) - lightmapIndex[1]);
  c2 = ((255 << 6) - lightmapIndex[lightmapWidth]);
  c3 = ((255 << 6) - lightmapIndex[lightmapWidth + 1]);

  c2 = (c2 - c0) >> shift;
  c3 = (c3 - c1) >> shift;

  for (b = 0; b < step; ++b) {
    h = x;
    c = c0;
    dc = (c1 - c0) >> shift;
    for (a = 0; a < step; ++a) {
      unsigned char pel = fullbright[h];

      *out++ = cachedColormap[(c & 0x00003F00) + (int)pel];
      c += dc;
      if (++h == x_max)
	h = 0;
    }
    out += row;
    c0 += c2;
    c1 += c3;
    if (++y == y_max) {
      y = 0;
      fullbright = raw->data;
    }
    else
      fullbright += raw->width;
  }
}

static unsigned char *brightColormap;
static void BuildBrightBlock8(unsigned char *out, struct bitmap *raw, int x, int y)
{
  int a, b, h;
  int y_max = raw->height, x_max = raw->width;
  unsigned char *fullbright = raw->data + lookup(y, raw->width);

  for (b = 0; b < step; ++b) {
    h = x;
    for (a = 0; a < step; ++a) {
      unsigned char pel = fullbright[h];

      *out++ = brightColormap[(int)pel];
      if (++h == x_max)
	h = 0;
    }
    out += row;
    if (++y == y_max) {
      y = 0;
      fullbright = raw->data;
    }
    else
      fullbright += raw->width;
  }
}
