#ifdef	NOASM
#ifdef	USE_ZBUFFER
#define	inc()   { w += dw; }
#define	fill(z) { *zBuffer++ = (unsigned short int)(z); }

unsigned short int *draw_affine8wire(int n, unsigned short int *zBuffer, int w, int dw)
{
  while (n--) {
    fill(w);
    inc();
  }
  return zBuffer;
}
#endif

/* given a span (x0,y)..(x1,y), draw a perspective-correct span for it */
/*
 * the zbuffer is interesting for dynamic model-draw etc.
 * the buffers values (1/z) are all under 0, we can try to
 * store them as 16bit-wide-fraction
 *
 * while(n--) {
 *   *zbuf++ = (unsigned short int)(w); / we need only the lower part /
 *   w += dw;
 * }
 *
 */
void draw_spans8wire(int y, int ey)
{
#ifdef	USE_ZBUFFER
  float prew = tmap[6] + y * tmap[8];
#endif

  for (; y < ey; y++) {
    int sx = scan[y][0];
    int len = scan[y][1] - sx;

    if (len > 0) {
      unsigned char *pBuffer = (unsigned char *)localDim.frameBuffer + multRows[y] + sx;

#ifdef	USE_ZBUFFER
      unsigned short int *zBuffer = localDim.zBuffer + multRows[y] + sx;
      float w0;
      int w, dw;						/* 1/zbuffer */
      int slen;

      /* compute (u,v) at left end */
      w0 = 1 / (prew + sx * tmap[7]);				/* 1/zbuffer */

      w = FLOAT_TO_FIX(w0);					/* 1/zbuffer */

      for (slen = len >> SUBDIV_SHIFT; slen > 0; slen--) {
	sx += SUBDIV;
	w0 = 1 / (prew + sx * tmap[7]);

	dw = (FLOAT_TO_FIX(w0) - w) >> SUBDIV_SHIFT;		/* 1/zbuffer */

	zBuffer = draw_affine8wire(SUBDIV, zBuffer, w, dw);
	w = FLOAT_TO_FIX(w0);					/* 1/zbuffer */
      }

      if ((slen = (len & SUBDIV_MASK) - 1)) {			/* a) do not calc if only draw 1 pixel */
	float w1;

	sx += slen;
	w1 = 1 / (prew + sx * tmap[7]);

	dw = FLOAT_TO_FIX((w1 - w0) / slen);			/* 1/zbuffer */
      }
      /* a) but draw that pixel surely */
      draw_affine8wire(slen + 1, zBuffer, w, dw);		/* for the last pixel the du and dv are thrown away */
#endif
      pBuffer[0] = 0x15;					/* startpoint */
      pBuffer[len] = 0x15;					/* endpoint */
    }

#ifdef	USE_ZBUFFER
    prew += tmap[8];
#endif
  }
}
#else
void draw_spans8wire(register int y __asm__("a4"), register int ey __asm__("d5"));
#endif
