#ifndef	WINDING_H
#define	WINDING_H
/*
 * ============================================================================
 * structures
 * ============================================================================
 */

struct winding {
  bool original;
  int numpoints;
  vec3_t points[8];						/* variable sized */
} __packed;

#define MAX_POINTS_ON_WINDING		64

/*
 * ============================================================================
 * globals
 * ============================================================================
 */

extern int c_activewindings, c_peakwindings;

/*
 * ============================================================================
 * prototypes
 * ============================================================================
 */

void WindingBounds(register struct winding *w, vec3_t mins, vec3_t maxs);
void WindingCenter(register struct winding *w, vec3_t center);
vec_t WindingArea(register struct winding *w);
struct winding *BaseWindingForPlane(register struct plane *p);
struct winding *WindingFromFace(__memBase, register struct dface_t *f);
void CheckWinding(register struct winding *w);
void CheckWindingInNode(register struct winding *w, register struct node *node);
void CheckWindingArea(register struct winding *w);
void PlaneFromWinding(register struct winding *w, register struct plane *plane);
struct winding *ClipWinding(register struct winding *in, register struct plane *split, register bool keepon);
void ClipWindingEpsilon(struct winding *in, vec3_t normal, vec_t dist,
		vec_t epsilon, struct winding **front, struct winding **back);
struct winding *CopyWinding(register struct winding *w);
void DivideWinding(struct winding *in, struct plane *split, struct winding **front, struct winding **back);
void FreeWinding(register struct winding *w);
struct winding *NewWinding(register int points);

#endif
