#ifndef	RAD_H
#define	RAD_H
/*
 * ============================================================================
 * structures
 * ============================================================================
 */

/* the sum of all tranfer->transfer values for a given patch */
/* should equal exactly 0x10000, showing that all radiance */
/* reaches other patches */
struct transfer {
  unsigned short int patch;
  unsigned short int transfer;
} __packed;

struct patch {
  struct winding *winding;
  struct patch *next;						/* next in face */
  int numtransfers;
  struct transfer *transfers;
  int cluster;							/* for pvs checking */
  vec3_t origin;
  struct dplane_t *plane;
  bool sky;
  vec3_t totallight;						/* accumulated by radiosity */
  /* does NOT include light */
  /* accounted for by direct lighting */
  float area;
  /* illuminance * reflectivity = radiosity */
  vec3_t reflectivity;
  vec3_t baselight;						/* emissivity only */
  /* each style 0 lightmap sample in the patch will be */
  /* added up to get the average illuminance of the entire patch */
  vec3_t samplelight;
  int samples;							/* for averaging direct light */
} __packed;

struct triedge {
  int p0, p1;
  vec3_t normal;
  vec_t dist;
  struct tripoly *tri;
} __packed;

struct tripoly {
  struct triedge *edges[3];
} __packed;

#define	MAX_TRI_POINTS		1024
#define	MAX_TRI_EDGES		(MAX_TRI_POINTS*6)
#define	MAX_TRI_TRIS		(MAX_TRI_POINTS*2)

struct triangulation {
  struct dplane_t *plane;
  int matrixsquare;
  struct triedge **edgematrix;
  int numpoints;
  struct patch **points;
  int numedges;
  struct triedge *edges;
  int numtris;
  struct tripoly *tris;
} __packed;

/*
 * ============================================================================
 * globals
 * ============================================================================
 */

extern vec3_t *texreflectivity;
extern vec3_t *radiosity;
extern vec3_t *illumination;
extern struct patch **facepatches;
extern struct entity **faceentity;
extern struct patch *patches;
extern int numpatches;
extern struct dplane_t *backplanes;
extern int fakeplanes;
extern int *leafparents;
extern int *nodeparents;
extern float subdiv;
extern struct directlight **directlights;
extern struct facelight *facelights;
extern int numdlights;
extern int numbounce;
extern bool dumppatches;
extern int junk;
extern float ambient;
extern float maxlight;
extern float lightscale;
extern float direct_scale;
extern float entity_scale;

/*
 * ============================================================================
 * prototypes
 * ============================================================================
 */

void RadWorld(__memBase);

#endif
