#ifndef	QBSP_H
#define	QBSP_H
/*
 * ============================================================================
 * structures
 * ============================================================================
 */

#define	MAX_THREADS			4

/*
 * ============================================================================
 * globals
 * ============================================================================
 */

extern int subdivide_size;
extern int hullnum;
extern struct brushset *brushset;
extern int valid;
extern bool worldmodel;

/*
 * ============================================================================
 * prototypes
 * ============================================================================
 */

struct brush *AllocBrush(void);
struct visfacet *AllocFace(register int points);
void FreeLeaf(register struct visleaf *l);
void CopyFace(register struct visfacet *out, register struct visfacet *in);
void RecalcFace(register struct visfacet *f);
void RecalcLeaf(register struct visleaf *l);
struct node *AllocNode(void);
struct visleaf *AllocLeaf(register int portals);
struct portal *AllocPortal(void);
struct surface *AllocSurface(void);
void FreeFace(register struct visfacet *f);
void FreePortal(register struct portal *p);
void FreeSurface(register struct surface *s);

void PrintMemory(void);

#endif
