#ifndef	LIGHT_H
#define	LIGHT_H
/*
 * ============================================================================
 * structures
 * ============================================================================
 */

typedef enum {
  emit_surface,
  emit_point,
  emit_spotlight
} __packed emittype_t;

#define	MAXLIGHTS			1024
#define	SINGLEMAP			(18*18*4)
/*#define       SINGLEMAP               (64*64*4) */
#define	MAX_STYLES			32
#define	DIRECT_LIGHT			3
#define	MAX_LSTYLES			256

struct lightinfo {
  vec_t lightmaps[MAXLIGHTMAPS][SINGLEMAP];
  int numlightstyles;
  vec_t *light;
  vec_t facedist;
  vec3_t facenormal;
  int numsurfpt;
  vec3_t surfpt[SINGLEMAP];
  vec3_t modelorg;						/* for origined bmodels */
  vec3_t texorg;
  vec3_t worldtotex[2];						/* s = (world - texorg) . worldtotex[0] */
  vec3_t textoworld[2];						/* world = texorg + s * textoworld[0] */
  vec_t exactmins[2], exactmaxs[2];
  int texmins[2], texsize[2];
  int lightstyles[256];
  int surfnum;
  struct dface_t *face;
} __packed;

struct facelight {
  int numsamples;
  float *origins;
  int numstyles;
  int stylenums[MAX_STYLES];
  float *samples[MAX_STYLES];
} __packed;

struct directlight {
  struct directlight *next;
  emittype_t type;
  float intensity;
  int style;
  vec3_t origin;
  vec3_t color;
  vec3_t normal;						/* for surfaces and spotlights */
  float stopdot;						/* for spotlights */
} __packed;

typedef struct {
  vec3_t backpt;
  int side;
  int node;
} __packed tracestack_t;

struct tnode {
  int type;
  vec3_t normal;
  float dist;
  int children[2];
  int pad;
} __packed;

/*
 * ============================================================================
 * globals
 * ============================================================================
 */

extern vec3_t *faceoffset;
extern int bspfileface;						/* next surface to dispatch */

/*
 * ============================================================================
 * prototypes
 * ============================================================================
 */

int TestLine_r(register int node, vec3_t start, vec3_t stop);
void CalcFaceVectors(__memBase, register struct lightinfo *l);
void CalcPoints(__memBase, struct lightinfo *l, register float sofs, register float tofs);

#endif
