#ifndef LISTS_H
#define LISTS_H

struct nnode {
  struct nnode *succ;						/* Pointer to next (successor) */
  struct nnode *pred;						/* Pointer to previous (predecessor) */
  int data;
};

struct nlist {
  struct nnode *head;
  struct nnode *tail;
  struct nnode *tailpred;
  int nodes;
};

void nNewList(struct nlist *list);
void nAddHead(struct nlist *list, struct nnode *node);
void nAddTail(struct nlist *list, struct nnode *node);
struct nnode *nRemHead(struct nlist *list);
struct nnode *nRemTail(struct nlist *list);
void nRemove(struct nlist *list, struct nnode *node);
void nInsert(struct nlist *list, struct nnode *node, struct nnode *pred);
void npreInsert(struct nlist *list, struct nnode *node, struct nnode *succ);
struct nnode *nFindNode(struct nlist *list, int data);
void nEnqueue(struct nlist *list, struct nnode *node);
struct nnode *nGetHead(struct nlist *list);
struct nnode *nGetTail(struct nlist *list);
struct nnode *nSuccNode(struct nnode *node);
void nMoveList(struct nlist *slist, struct nlist *dlist);
void nMoveNode(struct nlist *slist, struct nlist *dlist, struct nnode *node);
void nAppendList(struct nlist *preList, struct nlist *postList);
void nSortListWeighted(struct nlist *list, int radix);
void nSortListLinear(struct nlist *list, int radix);
void nSortListLinearMax(struct nlist *list, int radix, int radix_divide);

#define	nSortList nSortListLinear

#endif								/* LISTS_H */
