#ifndef	LIBQBUILD_H
#define	LIBQBUILD_H

#include "./init.h"

/* ============================================================================ */

#ifdef	LIBQBUILD_CORE
#define	LIBQTOOLS_CORE
#include "./libqtools.h"
#include "../libqbuild/brush.h"
#include "../libqbuild/csg4.h"
#include "../libqbuild/merge.h"
#include "../libqbuild/solidbsp.h"
#include "../libqbuild/surfaces.h"

#include "../libqbuild/portals.h"
#include "../libqbuild/winding.h"

#include "../libqbuild/writebsp.h"
#include "../libqbuild/tjunc.h"
#include "../libqbuild/region.h"
#include "../libqbuild/outside.h"
#include "../libqbuild/nodraw.h"
#endif

#include "./mathlib.h"

/* ============================================================================ */

#ifdef	LIBQBUILD_CORE
#include "../libqbuild/qbsp.h"
#endif

#define	QBSP_WATERVIS		(1<<0)
#define	QBSP_SLIMEVIS		(1<<1)
#define	QBSP_NOFILL		(1<<2)
#define	QBSP_NOTJUNC		(1<<3)
#define	QBSP_NOCLIP		(1<<4)
#define	QBSP_ONLYENTS		(1<<5)
#define	QBSP_USEHULLS		(1<<6)
#define	QBSP_NOTEXTURES		(1<<7)

void BeginBSPFile(__memBase);					/* start these before qbsp */
bool qbsp(__memBase, int hullNum, int subDivide, char *filebase);
void FinishBSPFile(__memBase, HANDLE bspFile);

/* ============================================================================ */

bool qcc(FILE * srcFile, char *destDir, operation procOper);
bool unqcc(HANDLE srcFile, char *destDir, operation procOper);

/* ============================================================================ */

#ifdef	LIBQBUILD_CORE
#include "../libqbuild/vis.h"
#endif

#define	VIS_FAST		(1<<0)
#define	VIS_MEM			(1<<1)
#define	VIS_VERBOSE		(1<<2)

bool vis(__memBase, int level, char *prtBuf);

/* ============================================================================ */

#ifdef	LIBQBUILD_CORE
#include "../libqbuild/light.h"
#include "../libqbuild/rad.h"
#endif

#define DEFAULTLIGHTLEVEL	300

#define	LIGHT_EXTRA		(1<<0)
#define	LIGHT_WATERLIT		(1<<1)
#define	LIGHT_MEM		(1<<2)
#define	LIGHT_RADIOSITY		(1<<3)

bool light(__memBase, float scale, float range);

/* ============================================================================ */

#endif
