/*
 * Copyright (C) 1996 by Raphael Quinet.  All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation.  If more than a few
 * lines of this code are used in a program which displays a copyright
 * notice or credit notice, the following acknowledgment must also be
 * displayed on the same screen: "This product includes software
 * developed by Raphael Quinet for use in the Quake Editing Utilities
 * project."  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR
 * IMPLIED WARRANTY.
 *
 * More information about the QEU project can be found on the WWW:
 * "http://www.montefiore.ulg.ac.be/~quinet/games/editing.html" or by
 * mail: Raphael Quinet, 9 rue des Martyrs, B-4550 Nandrin, Belgium.
 */

#ifndef _Q_MISC_H_
#define _Q_MISC_H_
/*
 * Q_MISC.H - Error logs, memory management, selection of objects, etc.
 */

/*
 * Typedefs
 */

/* The selection list is used when more than one object is selected. */
#include "qeu.h"

typedef struct SelectionList *SelPtr;
struct SelectionList
{
   SelPtr next;                 /* next in list */
   Int16  objnum;               /* object number */
};

/*
 * Prototypes
 */
void  MSleep(int msec);

void  ProgWarning(char *errstr, ...);
void  ProgError(char *errstr, ...);
void  LogMessage(char *logstr, ...);
void  OpenLogFile(char *logfilename);
void  CloseLogFile(void);

Bool  IsSelected(SelPtr list, Int16 objnum);
void  SelectObject(SelPtr *list, Int16 objnum);
void  UnSelectObject(SelPtr *list, Int16 objnum);
void  ForgetSelection(SelPtr *list);

void huge *QMalloc(UInt32 size);
void huge *QRealloc(void huge *old, UInt32 size);
void  QFree(void huge *ptr);
UInt8 huge *QMemDup(UInt8 huge *src, UInt32 size);

char *QStrDup(char *src);
char *QStrNCpy(char *dest, char *src, int n);
char *QStrNDupHack(char *src, int n);

#ifndef QEU_DOS
char *strupr(char *s);
#define stricmp(s1, s2)     strcasecmp(s1, s2)
#define strnicmp(s1, s2, n) strncasecmp(s1, s2, n)
#endif

#ifdef FAT_ENDIAN
UInt16 SwapInt16(UInt16 x);
UInt32 SwapInt32(UInt32 x);
Float32 SwapFloat32(Float32 x);
#else
#define SwapInt16(x)        (x)
#define SwapInt32(x)        (x)
#define SwapFloat32(x)      (x)
#endif /* FAT_ENDIAN */

#endif /* _Q_MISC_H_ */
/* end of file */
