/*
 * Copyright (C) 1996 by Raphael Quinet.  All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation.  If more than a few
 * lines of this code are used in a program which displays a copyright
 * notice or credit notice, the following acknowledgment must also be
 * displayed on the same screen: "This product includes software
 * developed by Raphael Quinet for use in the Quake Editing Utilities
 * project."  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR
 * IMPLIED WARRANTY.
 *
 * More information about the QEU project can be found on the WWW:
 * "http://www.montefiore.ulg.ac.be/~quinet/games/editing.html" or by
 * mail: Raphael Quinet, 9 rue des Martyrs, B-4550 Nandrin, Belgium.
 */

#ifndef _F_PACK_H_
#define _F_PACK_H_
/*
 * F_PACK.H - Read and write Quake PACK files.
 */

/*
 * The PACKDirectory structure is the structure used by QUAKE to order the
 * data in its PACK files.
 */
typedef struct PACKDirectory *PACKDirPtr;
struct PACKDirectory
{
   char   name[56];             /* name of file */
   UInt32 offset;               /* offset to start of data */
   UInt32 size;                 /* byte size of data */
};

PACKDirPtr ReadPACKDirectory(FILE *packfile, UInt32 offset, UInt16 *dirsize_r);
UInt16     FindPACKEntry(PACKDirPtr dir, UInt16 dirsize, char *entryname);
void       DumpPACKDirectory(FILE *outf, PACKDirPtr dir, UInt16 dirsize);
Bool       UnPACKFile(FILE *outf, FILE *packfile, UInt32 offset,
		      PACKDirPtr dir, UInt16 dirsize, UInt16 entrynum,
		      char *prefixpath);

Bool       WritePACKHeader(FILE *packfile, UInt32 *count_r, PACKDirPtr *dir_r,
			   UInt16 *dirsize_r);
Bool       AddPACKEntry(FILE *packfile, UInt32 *count_r, PACKDirPtr *dir_r,
			UInt16 *dirsize_r, char *entryname, UInt32 entrysize);
UInt32     WritePACKDirectory(FILE *packfile, UInt32 *count_r, PACKDirPtr dir,
			      UInt16 dirsize);
#endif /* _F_PACK_H_ */
/* end of file */
