/*-------------------------------------------------------------------------
File    : readmap.c
Author  : John Carmack (id Software) - the algorithms and original code.
          Cameron Newham - conversion to C, load_file,
                           and some commenting.
Version : 1.0
Date    : 96/08/29

Description
-----------
Reads the MAP file into a buffer and then parses the buffer, extracting
tokens and creating brushes (faces) if necessary.

Comments
--------
Rather a hodgepodge at the moment.
-------------------------------------------------------------------------*/

#include <stdio.h>
#include "readmap.h"
#include "io.h"

struct key_value_pair
{
  char key [MAXTOKEN];
  char value [MAXTOKEN];
};

struct     key_value_pair keys[MAXKEYS];  /* an array of key/value pairs */


/*--------------------------------------
***MAIN***
--------------------------------------*/
void main ()
{
  char       *dat;            /* the text from the file in one lump */
  char       *fname;     
  int        location;        /* location in the char data */
  int        scriptline;      /* which line from original file we are on */
  char       token[MAXTOKEN]; /* somewhere to put each token */
  int        key_number;      /* next storage for keys */

float *point;


  /* load the data from the file into the dat structure */
  dat = Load_File ("test.map", dat);

  /* initialise for reading tokens */
  location = 0;
  scriptline = 0;
  key_number = 0;


  /* Look for the first { token */
  if (!GetToken(TRUE, token, &scriptline, dat, &location))
  {
    free(dat);  /* nothing to be done so free memory*/
    exit (0);
  }


  if (strcmp(token, "{"))
    Error(scriptline,"Error: { not found\n");

  while (TRUE) {
    /* Start looking for other tokens */
    if (!GetToken (TRUE, token, &scriptline, dat, &location))
      break;
    if (!strcmp (token, "}") )
      break;
    if (!strcmp (token, "{") )
    {
      /* Read a brush */
      ReadBrush (token, &scriptline, dat, &location);

/* HOOK - the global "faces" is an array of faces for the current
   brush.  "numfaces" is the number of faces there are. Copy these
   because they'll be overwritten by the next call to ReadBrush. Also
   be aware that freeWindings gets called but has been modified so
   as not to destroy the structures containing the winding (vertex)
   information */

    }
    else
    {
      /* Read a key/value pair */
      strcpy (keys[key_number].key, token);
      GetToken (FALSE, token, &scriptline, dat, &location);
      strcpy (keys[key_number++].value, token);
printf (">>key/val pair = %s/%s\n", keys[key_number-1].key,keys[key_number-1].value);

/* HOOK - key/value pairs get stored in "keys". This only applies
   to the initial info before the brush definitions. */

    }
  }
printf(">>Finished.  lastline = %d\n", scriptline);
}

