/*-------------------------------------------------------------------------
File    : mathlib.h
Author  : Cameron Newham
Version : 1.0
Date    : 96/08/29

Description
-----------
The header file for the mathlib.c library.

Comments
--------
This is modelled on the mathlib.h by John Carmack (id Software).

-------------------------------------------------------------------------*/

typedef float vec_t;
typedef vec_t vec3_t[3];

extern vec3_t vec3_origin;

int VectorCompare (vec3_t v1, vec3_t v2);
vec_t DotProduct (vec3_t v1, vec3_t v2);
void VectorSubtract (vec3_t va, vec3_t vb, vec3_t out);
void VectorAdd (vec3_t va, vec3_t vb, vec3_t out);
void VectorCopy (vec3_t in, vec3_t out);

void CrossProduct (vec3_t v1, vec3_t v2, vec3_t cross);
void VectorNormalize (vec3_t v);
void VectorScale (vec3_t v, vec_t scale, vec3_t out);
double VectorLength(vec3_t v);
void VectorMA (vec3_t va, double scale, vec3_t vb, vec3_t vc);

