/*-------------------------------------------------------------------------
File    : io.c
Author  : Cameron Newham
Version : 1.0
Date    : 96/08/29

Description
-----------
An Error routine to handle fatal errors when reading the MAP file,
and a routine to load a MAP file into an array of char.

Comments
--------
Load_File is probably inefficiently written - but then I am not
a C coder by profession (I'm sure you can tell from the naming
conventions I've used ;).

w.r.t Load_File and the memory allocation if (MAXTOKEN > ~90):
I had some difficulty with size allocations with GNU on Linux - I
have no idea why and don't have the time to find out. If you can
tell me, please do so.
-------------------------------------------------------------------------*/

#include <stdio.h>


/*--------------------------------------
Write an error message and abort
--------------------------------------*/
void Error (int line, char *message)
{
  printf("Error at Line %d: %s",line,message);
  exit (1);
}


/*--------------------------------------
Loads a map file into a continuous string
of characters excluding newlines.
--------------------------------------*/
char *Load_File (char *fname, char *dat)
{
  FILE *fd;
  char line [100];
  int sz, total_size;

  total_size = 0;

  fd = fopen (fname, "r");
  while (fgets(line, 1000, fd) != NULL)
  {
    sz = strlen (line);

    if (total_size == 0)
      dat = (char *)malloc(sizeof(char)*sz);
    else
      dat = (char *)realloc (dat, sizeof(char)*(total_size+sz));

    total_size = total_size + sz;
    strncpy (dat+total_size-sz, line, sz);
  }

  fclose (fd);
  return dat;
}

