/*======================================================================*/
/* BRUSH.H */

#include "mathlib.h"
#include "readmap.h"

#define  MAX_FACES               16
#define  BOGUS_RANGE             18000
#define  MAX_POINTS_ON_WINDING   64
#define ON_EPSILON               0.1
#define FP_EPSILON               0.01
#define VECTOR_EPSILON           0.0001
#define SIDE_FRONT               0
#define SIDE_BACK                1
#define SIDE_ON                  2

typedef struct
{
        char    texture[16];
        float   rotate;
        float   shift[2];
        float   scale[2];
} texturedef_t;

vec3_t  baseaxis[18] =
{
{0,0,1}, {1,0,0}, {0,-1,0},             /* floor */
{0,0,-1}, {1,0,0}, {0,-1,0},            /* ceiling */
{1,0,0}, {0,1,0}, {0,0,-1},             /* west wall */
{-1,0,0}, {0,1,0}, {0,0,-1},            /* east wall */
{0,1,0}, {1,0,0}, {0,0,-1},             /* south wall */
{0,-1,0}, {1,0,0}, {0,0,-1}             /* north wall */
};

typedef float   vec5_t[5];

typedef struct
{
  int     numpoints;
  vec5_t  points[8];  /*variable sized*/
} winding_t;

typedef struct
{
        vec3_t          normal;
        float           dist;
} plane_t;

typedef struct
{
  /* implicit representation */
  vec3_t          planepts[3];
  texturedef_t    texture;

  /* cached representation */
  plane_t                 plane;
  float                   light;          /* 0 - 1.0 */
  winding_t               *w;
} face_t;

float  lightaxis[3] = {1, 0.6, 0.75};


int        invalid;           /* not a proper polyhedron */
vec3_t     bmins, bmaxs;
face_t     faces[MAX_FACES];
int        numfaces;

