/*-------------------------------------------------------------------------
File    : readmap.c
Author  : John Carmack (id Software) - the algorithms and original code.
          Cameron Newham - conversion to C, load_file,
                           and some commenting.
Version : 1.0
Date    : 96/08/29

Description
-----------
Reads the MAP file into a buffer and then parses the buffer, extracting
tokens and creating brushes (faces) if necessary.

Comments
--------
Rather a hodgepodge at the moment.  
11-12-96 That's ok I butchered it some more to get it to work in dos
-------------------------------------------------------------------------*/

#include <stdio.h> 
#include <malloc.h>
#include <process.h> 
#include <string.h>
#include "readmap.h"
#include "io.h" 
#include "brush.h"

struct key_value_pair
{
  char key [MAXTOKEN];
  char value [MAXTOKEN];
};

struct     key_value_pair keys[MAXKEYS];  /* an array of key/value pairs */
char *dat;                           /* the text from the file in one lump */

/*--------------------------------------
***MAIN***
--------------------------------------*/
void main (int argc, char *argv[ ])
{ 
  int        location;        /* location in the char data */
  int        scriptline;      /* which line from original file we are on */
  char       token[MAXTOKEN]; /* somewhere to put each token */
  int        key_number;      /* next storage for keys */
  int i; 
  
  if (argv[1]==NULL)
  	{
  		printf("[Usage :] readmap.exe (filename)\n");
        exit(0);
     }
        
  /* load the data from the file into the dat structure */
  dat = Load_File (argv[1], dat);
  
  if (dat==0)
  	exit(0);
  	
  /* initialise for reading tokens */
  location = 0;
  scriptline = 0;
  key_number = 0;  

  /* Look for the first { token */
  if (!GetToken(TRUE, token, &scriptline, dat, &location))
  {
    free(dat);  /* nothing to be done so free memory*/
    exit (0);
  }  

  if (strcmp(token, "{"))
    Error(scriptline,"Error: { not found\n");

  while (TRUE) {
    /* Start looking for other tokens */
    if (!GetToken (TRUE, token, &scriptline, dat, &location))
      break;
    if (!strcmp (token, "}") )
      break;
    if (!strcmp (token, "{") )
    {
      /* Read a brush */
      ReadBrush (token, &scriptline, dat, &location);       
      //Print out some key info//
      printf("Texture %s\n",f->texture.texture);
      printf("Number of faces %i\n",numfaces); 
      printf("Winding for each Face\n");
      for (i=0 ; i<MAX_FACES ; i++)
      	{   
      		if (faces[i].w)
    			{    	 
    	 			printf("\tV (%Li)\n",faces[i].w);
    	 		}	
        }
      printf("BMINS (%Li %Li %Li)\n",bmins[0],bmins[1],bmins[2]);
      printf("BMAXS (%Li %Li %Li)\n",bmaxs[0],bmaxs[1],bmaxs[2]);  
/* HOOK - the global "faces" is an array of faces for the current
   brush.  "numfaces" is the number of faces there are. Copy these
   because they'll be overwritten by the next call to ReadBrush. Also
   be aware that freeWindings gets called but has been modified so
   as not to destroy the structures containing the winding (vertex)
   information */  
   /*11-12-96 freeWindings frees the memory so if you need it save them
   here. */

    }
    else
    {
      /* Read a key/value pair */
      strcpy (keys[key_number].key, token);
      GetToken (FALSE, token, &scriptline, dat, &location);
      strcpy (keys[key_number++].value, token);
printf (">>key/val pair = %s/%s\n", keys[key_number-1].key,keys[key_number-1].value);

/* HOOK - key/value pairs get stored in "keys". This only applies
   to the initial info before the brush definitions. */

    }
  }
  while (TRUE) {
    /* Start looking for other tokens */
    if (!GetToken (TRUE, token, &scriptline, dat, &location))
      break;
    if (!strcmp (token, "}") )
      break;
    if (!strcmp (token, "{") )
    {
      ReadEntity(token, &scriptline, dat, &location); //Let's get the rest of the stuff
    }
  }
printf(">>Finished.  lastline = %d\n", scriptline);
free(dat);
exit(0); 
}

