/*
   Scanners & Backscanners are for reading chars out of with >>.
   Backscanners, can go backwards, Scanners can't
*/

class Scanner {
protected:
  const char *ptr;
  friend Scanner &operator >> (Scanner &, char &);
  int good;
public:
  Scanner(const char *str) {ptr = str; good = 1;}
  operator int() {return good;}
  const char *Peek() {return ptr;}
  int Skip(int(*)(char)); // skips over all chars for which functional
                          //   arg returns true
  void Next() { if (*ptr == '\0') good = 0; else ptr++;}
};

class BackScanner : public Scanner {
  const char *str;
public:
  BackScanner(const char *str) : Scanner(str) {BackScanner::str = str;}
  BackScanner(const char *str, int pos) : Scanner(str)
    {BackScanner::str = str; ptr = (pos < 0 ? str : str+pos);}
  const char *Start() {return str;}
  int Pos() {return (ptr - str - 1);} // neg if nothing read in yet.
};