#include "reader.h"

Reader::Reader(const char *name, ostream &out)
{
  if (name[0] == '@') {
    currfile[0] = '\n';
    list.open(name+1);
    inp_opened = 0;
  }
  else {
    inp.open(name);
    strcpy(currfile,name);
    if (inp.bad()) {
      cerr << "Bad file: " << name << '\n';
      inp_opened = 0;
    }
    else
      inp_opened = 1;
  }
  outpt = &out;
}


unsigned Reader::Get(char *line, int len)
{
  if (inp.getline(line,len))
    return 1;
  if (inp_opened)
    inp.close();
  while (list >> currfile) {
    inp.open(currfile);
    NewFile();
    if (inp.bad())
      continue;
    inp_opened = 1;
    if (inp.getline(line,len))
      return 1;
    inp.close();  // file empty, close it
  }
}

void Reader::NewFile()
{
  if (inp.bad())
    cerr << "Bad file: " << currfile << '\n';
  else
   *outpt << currfile << '\n';
}

/*

main(int argc, char **argv)
{
   char linebuf[120];

   ofstream trash;
   trash.open("trash.out");
   Reader reader(argv[1], cout);
   while (reader.Get(linebuf,119))
     trash << linebuf << '\n';

}
*/
