#include <stdio.h>
#include <stdlib.h>
#include <dir.h>

#include "reader.h"
#include "scanner.h"
#include "buffer.h"
#include "dict2.h"


#define BFL 128   // length of input line-buffer
#define MXK 32  // mx len. key or value string
#define MXF 20   // max # fields for entity
//  Note: the code is dangerous, & doesnt check bounds for MXK/F

char targname[MXK] = ""; // targetted classname, if any
int targetted = 0;


// an Item with an occurrence-count
class NumItem : public Item {
public:
  NumItem(char *word) : Item(word){ num = 1;}
  int Number() {return num;}
  void Tick(){num++;}
protected:
  int num;
};

// Keys have labels and frequency info.
// Somehow I don't think I've grasped the spirit of iterators.

class Key : public NumItem {
public:
  Key(char *word) : NumItem(word){}
  void Write(ostream &out) {out << Name();}
//  void Write(ostream &out) {out << Name() << ':' << Number();}
};

class Keys : public Dict<Key> {
public:
  Keys() : Dict<Key>() {}
  void add(char *);
  void Write(ostream &, int num);
//  void Read(istream &);
//  void Read(char *);
};

class Keys_iter : public Dict_iter<Key> {
public:
  Keys_iter(Keys &keys) : Dict_iter<Key>(keys) {};
//  int ReadWords(istream &in);
};

void Keys::add(char *word)
{
  Keys_iter iter(*this);
  Key *found;
  if (found=iter.find(word))
    found->Tick();               // increase the count
  else
    iter.add(new Key(word));   // count starts at 1
}

void Keys::Write(ostream &out, int num) //num=#occ. of entity Keys are in
{
  Keys_iter iter(*this);
  Key *curr;
  iter.first();
  while (curr = iter.current()) {
    if (curr->Number() == num) {
      out << "     ";
      curr->Write(out);
      out << '\n';
    }
    iter.next();
  }
  iter.first();
  while (curr = iter.current()) {
    if (curr->Number() < num) {
      out << "     (";
      curr->Write(out);
      out << ")\n";
    }
    iter.next();
  }
  cout.flush();
}

// entities record info about how many occurrences, and what keys

class Entity : public NumItem {
public:
  Entity(char *name) : NumItem(name) {};
  void Write(ostream &);
  void add(char *key) {keys.add(key);}
protected:
  Keys keys;
};

void Entity::Write(ostream &out)
{
  out  << Name() << ":\n";
//  out  << Name() << ':' << Number() << ":\n";
  keys.Write(out, Number());
}

class EntDict : public Dict<Entity> {
public:
  EntDict() : Dict<Entity>() {};
  Entity *add(char *);
  void Write(ostream &);
};

class EntDict_iter : public Dict_iter<Entity> {
public:
  EntDict_iter(EntDict &entdict) : Dict_iter<Entity>(entdict) {};
};

Entity  *EntDict::add(char *word)
{
  EntDict_iter iter(*this);
  if (iter.find(word))
    iter.current()->Tick();       // register occurrence
  else
    iter.add(new Entity(word)); // count starts at 1
  return iter.current();
}

void EntDict::Write(ostream &out)
{
  EntDict_iter iter(*this);
  iter.first();
  Entity *curr;
  while (curr = iter.current()) {
    curr->Write(out);
//    out << '\n';
    iter.next();
  }
  cout.flush();
}

EntDict entdict;

/*
   skips ahead in scan to the next instance of ", then shifts the
   stuff thereafter into dest.  If dest has allocated storage >=
   BFL, it shouldn't overwrite.
*/

void Get_Next_Quoted (Scanner &scan, char *dest)
{
  char c;
  SBuffer<BFL> buf;
  while (scan >> c && c !='\"') {} // skip to after first quote
  while (scan >> c && c!='\"')
    buf << c;
  strcpy(dest,buf);
}


void Get_Field(char *line, char *key, char *value)
{
  Scanner scan(line);
  Get_Next_Quoted(scan, key);
  Get_Next_Quoted(scan, value);
}


void Read_Entry(Reader &reader)
{
   char linebuf[BFL];
   char entity[MXF][2][MXK]; // 0 for key, 1 for value
   Entity *curr_ent;
   int f = 0;   // initialize index to fields for reading-in
   while (reader.Get(linebuf,BFL-1)) {
     if (linebuf[0]=='}') {
//      cout << " ***** \n";
       int i;
       for (i = 0; i < f; i++) {
//	 cout<<entity[i][0]<<':'<<entity[i][1]<<'\n';
	 curr_ent->add(entity[i][0]);
       }
       return;
     }
     else {
       Get_Field(linebuf,entity[f][0],entity[f][1]);
       if (!strcmp(entity[f][0],"classname")) {
	 if (targetted && strcmp(targname,entity[f][1])) // wrong classname
	    return;                                      // bail
	 curr_ent = entdict.add(entity[f][1]);
				    // since f doesn't incr, the classname
       }				    //  doesn't get into the entity record
       else
	 f++;
     }
  }
}

void bad_usage()
{
    cerr << "usage:  ents [-f <filespec>] [classname]\n";
    cerr << "  reads entity lists extracted from .bsp's";
    cerr << "  no classname means all entities\n";
    cerr << "  no filespec reads *.ent files in current directory\n";
    cerr << "  add `> [filename' to direct useful output to file\n";
    exit(1);
}

main(int argc, char **argv)
{
   struct ffblk ffblk;
   char filemask[32];
   int argp;
   int done;

  if (argv[1][0] == '-') {
    if (argc < 3)
      bad_usage();
    strcpy(filemask, argv[2]);
    argp = 3;
  }
  else {
    strcpy(filemask, "*.ent");
    argp = 1;
  }
// get targetted class, if any
   if (argc <= argp) {             //if there is no class spec.
       targetted = 0;
   }
   else {
     strcpy(targname, argv[argp]);
     targetted = 1;
   }

// do the real work
   char linebuf[BFL];
   done = findfirst(filemask,&ffblk,0);
   if (done) {
      cerr << "No entity files found\n";
      bad_usage();
   }
   while (!done) {
      cerr << "reading: " << ffblk.ff_name << '\n';
      Reader reader(ffblk.ff_name, cout);
      while (reader.Get(linebuf,BFL-1))
	if (linebuf[0] == '{')
	  Read_Entry(reader);
      done = findnext(&ffblk);
   }
   entdict.Write(cout);
}


