#ifndef _DICT_H_
  #define _DICT_H_ 1
#include <string.h>

#include "lists.h"

class Item : public slink {
public:
  Item(const char *str) {name = new char[strlen(str)+1];strcpy(name,str);}
   ~Item() {delete[] name;}
  const char *Name() {return name;}

private:
  char *name;
};

template<class T> class Dict_iter;


// private inheritance because uses Islist for implementation, but
//   doesn't provide all of the services.
template<class T> class Dict : private Islist<T> {
 friend class Dict_iter<T>;
public:
  Dict() : Islist<T>() {};
  T* find(const char * key)
    {Dict_iter<T> iter(*this); return iter.find(key);}
  int add(Item *what)
    {Dict_iter<T> iter(*this); return iter.add(what);}
};


template<class T> class Dict_iter : public Islist_iter<T> {
public:
  Dict_iter(Dict<T> &dict) : Islist_iter<T>(dict){};
  Dict_iter() : Islist_iter<T>() {};

  T *current() {return (T *) Islist_iter<T>::current();}
  T *first() {return (T *) Islist_iter<T>::first();}
  T *next() {return (T *) Islist_iter<T>::next();}

  T* find(const char *);
  int add(Item *);
};

template<class T> T *Dict_iter<T>::find(const char *what)
{

  int cmp;
  if (current()) {
T *currnt = current();
    cmp = strcmp(current()->Name(), what);
    if (cmp > 0)     // sought < current
      first();
    if (cmp == 0)       // sought = currrny
      return current();
  }
  else first();  // no current, set to first

  while ((current()) != 0 && (cmp = strcmp(current()->Name(), what)) < 0)
	 next();
  if (cmp == 0)
	 return current();
  else return 0;
}

template<class T> int Dict_iter<T>::add(Item *what)
{
  if (find(what->Name()))  // gets the iterator into the correct state
    return 0;
  else {
    insert(what);
    return 1;
  }
};

#endif