#ifndef _BUFFER_H_
  #define _BUFFER_H_ 1
#include <iostream.h>

/*
   Buffers are for sticking characters into, with the << operator,
   and then pulling out the results, by casting to char *, but
   also provide other convenient operations.  But they do *not*
   provide their own storage, so you can use them to manage access
   to strings stored in arrays, etc.
*/

class Buffer {
public:
  Buffer(char *buf, int len){string=ptr=buf; max=ptr+len-1; over = 0;}
   // suppose len is 1.  Then there's only space for the terminator,
   // so max=ptr, so no more chars can be added
  operator char *() const {(*((Buffer *) this)->ptr) = '\0'; return string;}
   // `casting away const' (Stroustrup 1991:149)
  char operator [] (int i) const {return string[i];}
  void Clear() {ptr = string; over = 0;}
  int Left() const {return max - ptr;}
  int Len() const {return ptr - string;}
  void Push(char c){if (ptr<max) *ptr++=c; else over = 1;}
//  void Dump(char *out) const {strcpy(out,this);}
    // copies contents into char *.
  int Overflow() const {return over;}
//  char *operator() () const;

  Buffer &operator << (const char c)
    {Push(c); return *this;}
  Buffer &operator << (const char *);

protected:
  char *string;
  char *ptr;
  char *max;
  int over;
};


template<int sz> class SBuffer : public Buffer {
  char store[sz];
public:
  SBuffer() : Buffer(store,sz){};
};

class HBuffer : public Buffer {
public:
  HBuffer(int len = 255) : Buffer(new char[len], len) {};
  HBuffer(const HBuffer &buf);
  HBuffer &operator = (HBuffer &);
  ~HBuffer() {delete string;}
};


ostream &operator << (ostream &out, Buffer &buf);

#endif