

//

// QUAKE game definition file (.fgd)

//



@Main = 

[

    Name: "Quake2"

    Palette: "quake2.pal"

    DefaultClass: "func_door"

]



//

// worldspawn

//





@SolidClass = worldspawn : "World entity"

[

	message(string) : "Text to print at user logon"

	gravity(integer) : "800 is default gravity" : 800

	sounds(integer) : "Music cd track number"

	sky(string) : "Environment map name"

	skyaxis(integer) : "vector axis for rotating sky"

	skyrotate(integer) : "Speed of rotation in degrees/second"

]



//

// base marker definitions

//



@baseclass = Appearflags [

	spawnflags(Flags) =

	[

		256 : "Not in Easy" : 0

		512 : "Not in Normal" : 0

		1024 : "Not in Hard" : 0

		2048 : "Not in Deathmatch" : 0

	]

]



@baseclass = Targetname [ targetname(target_source) : "Name" ]



@baseclass = Target [ target(target_destination) : "Target" ]



//

// "INFO_"

//



@baseclass base(Appearflags) size(-16 -16 -24, 16 16 32) 

	color(128 0 0) = InfoClass []



@PointClass base(InfoClass) = info_player_start : "The normal starting point for a level."

[

]



@PointClass base(InfoClass) = info_player_deathmatch : "Potential spawning position for deathmatch games"

[

]



@PointClass base(InfoClass) = info_player_coop : "Potential spawning position for coop games"

[

]



@PointClass base(InfoClass) = info_player_intermission : "Intermission spot"

[

	angles(string) : "pitch yaw roll" : "0 0 0"

]



@PointClass base(InfoClass, Targetname) size(-4 -4 -4, 4 4 4) = info_null : "Used as a positional target for spotlights, etc." 

[

]



@PointClass base(InfoClass, Targetname) size(-4 -4 -4, 4 4 4) = info_notnull : "Used as a positional target for lightning"

[

]



//

// "MONSTER_"

//



@baseclass base(Appearflags) size(-16 -16 -24, 16 16 32) 

	color(255 128 0) = Monster

[

	spawnflags(Flags) = 

	[

		1 : "AMBUSH" : 0

		2 : "TRIGGER_SPAWN" : 0

		4 : "SIGHT" : 0

	]

]



@PointClass base(Appearflags, Monster) size(-32 -32 -16, 32 32 72) 

	= monster_tank : "monster_tank"

[

]



@PointClass base(Appearflags, Monster) size(-32 -32 -16, 32 32 72) 

	= monster_tank_commander : "monster_tank_commander"

[

]



@PointClass base(Appearflags, Monster) size(-64 -64 0, 64 64 72) 

	= monster_supertank : "monster_supertank"

[

]



@PointClass base(Appearflags, Monster) size(-16 -16 -24, 16 16 32) 

	= monster_soldier_light : "monster_soldier_light"

[

]



@PointClass base(Appearflags, Monster) size(-16 -16 -24, 16 16 32) 

	= monster_soldier_ss : "monster_soldier_ss"

[

]



@PointClass base(Appearflags, Monster) size(-16 -16 -24, 16 16 32) 

	= monster_parasite : "monster_parasite"

[

]



@PointClass base(Appearflags, Monster) size(-32 -32 -24, 32 32 32) 

	= monster_mutant : "monster_mutant"

[

]



@PointClass base(Appearflags, Monster) size(-16 -16 -24, 16 16 32) 

	= monster_medic : "monster_medic"

[

]



@PointClass base(Appearflags, Monster) size(-16 -16 -24, 16 16 32) 

	= monster_infantry : "monster_infantry"

[

]



@PointClass base(Appearflags, Monster) size(-16 -16 -24, 16 16 32) 

	= monster_hover : "monster_hover"

[

]



@PointClass base(Appearflags, Monster) size(-16 -16 -24, 16 16 32) 

	= monster_gunner : "monster_gunner"

[

]



@PointClass base(Appearflags, Monster) size(-32 -32 -24, 32 32 64) 

	= monster_gladiator : "monster_gladiator"

[

]



@PointClass base(Appearflags, Monster) size(-16 -16 -24, 16 16 32) 

	= monster_flyer : "monster_flyer"

[

]



@PointClass base(Appearflags, Monster) size(-16 -16 -24, 16 16 32) 

	= monster_floater : "monster_floater"

[

]



@PointClass base(Appearflags, Monster) size(-16 -16 -24, 16 16 32) 

	= monster_flipper : "monster_flipper"

[

]



@PointClass base(Appearflags, Monster) size(-16 -16 -24, 16 16 32) 

	= monster_chick : "monster_chick"

[

]



@PointClass base(Appearflags, Monster) size(-16 -16 -24, 16 16 32) 

	= monster_brain : "monster_brain"

[

]



@PointClass base(Appearflags, Monster) size(-30 -30 0, 30 30 90) 

	= monster_makron : "monster_makron"

[

]



@PointClass base(Appearflags, Monster) size(-80 -80 0, 90 90 140) 

	= monster_jorg : "monster_jorg"

[

]



@PointClass base(Appearflags, Monster) size(-32 -32 0, 32 32 90) 

	= monster_boss3_stand : "Just stands and cycles in one place until targeted, then teleports away."

[

]



@PointClass base(Appearflags, Monster) size(-56 -56 0, 56 56 80) 

	= monster_boss2 : "monster_boss2"

[

]



@PointClass base(Appearflags, Monster) size(-16 -16 -24, 16 16 32) 

	= monster_berserk : "monster_berserk"

[

]



@PointClass base(Appearflags, Monster) size(-32 -32 0, 32 32 48) 

	= monster_commander_body : "monster_commander_body"

[

]



//

// "MISC_"

//



@PointClass base(Appearflags) size(-16 -16 -24, 16 16 32) 

	color(255 128 0) = misc_insane : "misc_insane"

[

	spawnflags(Flags) = 

	[

		1 : "AMBUSH" : 0

		2 : "TRIGGER_SPAWN" : 0

		4 : "CRAWL" : 0

		8 : "CRUCIFIED" : 0

		16 : "STAND_GROUND" : 0

		32 : "ALWAYS_STAND" : 0

	]

]



@PointClass base(Appearflags) size(-16 -16 -24, 16 16 32) 

	color(255 128 0) = misc_actor : "misc_actor"

[

]



@PointClass base(Appearflags) size(-16 -16 0, 16 16 40) 

	color(0 128 32) = misc_explobox : "misc_explobox"

[

	health(integer) : "Health"

	mass(integer) : "Mass" : 100

	dmg(integer) : "Damage" : 150

]



@PointClass base(Appearflags) size(-8 -8 -8, 8 8 8) 

	color(255 128 0) = misc_blackhole : "misc_blackhole"

[

]



@PointClass base(Appearflags) size(-32 -32 -16, 32 32 32) 

	color(255 128 0) = misc_eastertank : "misc_eastertank"

[

]



@PointClass base(Appearflags) size(-32 -32 0, 32 32 32) 

	color(255 128 0) = misc_easterchick : "misc_easterchick"

[

]



@PointClass base(Appearflags) size(-32 -32 0, 32 32 32) 

	color(255 128 0) = misc_easterchick2 : "misc_easterchick2"

[

]



@PointClass base(Appearflags) size(-4 -4 -4, 4 4 4) 

	color(255 128 0) = misc_banner : "misc_banner"

[

]



@PointClass base(Appearflags) size(-16 -16 0, 16 16 16) 

	color(255 128 0) = misc_deadsoldier : "misc_deadsoldier"

[

	spawnflags(Flags) = 

	[

		1 : "ON_BACK" : 0

		2 : "ON_STOMACH" : 0

		4 : "BACK_DECAP" : 0

		8 : "FETAL_POS" : 0

		16 : "SIT_DECAP " : 0

		32 : "IMPALED" : 0

	]

]





@PointClass base(Appearflags, Target, Targetname) size(-16 -16 0, 16 16 32) 

	color(255 128 0) = misc_viper : "misc_viper"

[

	speed(integer) : "Speed"

]



@PointClass base(Appearflags) size(-176 -120 -24, 176 120 72) 

	color(255 128 0) = misc_bigviper : "misc_bigviper"

[

]



@PointClass base(Appearflags) size(-8 -8 -8, 8 8 8) 

	color(255 128 0) = misc_viper_bomb : "misc_viper_bomb"

[

	dmg(integer) : "Damage"

]



@PointClass base(Appearflags) size(-16 -16 0, 16 16 32) 

	color(255 128 0) = misc_strogg_ship : "misc_strogg_ship"

[

	speed(integer) : "Speed"

]



@PointClass base(Appearflags) size(-8 -8 -8, 8 8 8) 

	color(255 128 0) = misc_gib_arm : "misc_gib_arm"

[

]



@PointClass base(Appearflags) size(-8 -8 -8, 8 8 8) 

	color(255 128 0) = misc_gib_leg : "misc_gib_leg"

[

]



@PointClass base(Appearflags) size(-8 -8 -8, 8 8 8) 

	color(255 128 0) = misc_gib_head : "misc_gib_head"

[

]



@PointClass base(Appearflags, Target, Targetname) size(-32 -32 -24, 32 32 -16) 

	color(128 0 0) = misc_teleporter : "misc_teleporter"

[

]



@PointClass base(Appearflags, Target, Targetname) size(-32 -32 -24, 32 32 -16) 

	color(128 0 0) = misc_teleporter_dest : "misc_teleporter_dest"

[

]



//

// "TURRET_"

//



@SolidClass base(Appearflags, Target, Targetname) = turret_breach : "turret_breach" 

[

	speed(integer) : "Speed" : 50

	dmg(integer) : "Damage" : 10

	angle(integer) : "Angle"

	minpitch(integer) : "Min Pitch" : -30

	maxpitch(integer) : "Max Pitch" : 30

	minyaw(integer) : "Min Yaw" : 0

	maxyaw(integer) : "Max Yaw" : 360

]



@SolidClass base(Appearflags) = turret_base : "turret_base" 

[

]



@PointClass base(Appearflags) size(-16 -16 -24, 16 16 32) 

	color(255 128 0) = turret_driver : "turret_driver"

[

]



//

// "TRIGGER_"

//



@baseclass base(Appearflags, Targetname, Target) size(-16 -16 -24, 16 16 32) 

	color(64 64 64) = Trigger

[

	killtarget(target_source) : "Kill target"

	sounds(choices) : "Sounds" : 0 =

	[

		0 : "none"

		1 : "secret"

		2 : "beep beep"

		3 : "large switch"

	]

	delay(integer) : "Delay before trigger" : 2

	wait(string) : "Delay before reset" : "0.2"

	health(integer) : "Health"

	message(string) : "Message"

]



@SolidClass base(Trigger) = trigger_multiple : "trigger_multiple" 

[

	spawnflags(Flags) = 

	[

		1 : "MONSTER" : 0

		2 : "NOT_PLAYER" : 0

		4 : "TRIGGERED" : 0

	]

]



@SolidClass base(Trigger) = trigger_once : "trigger_once" 

[

	spawnflags(Flags) = 

	[

		1 : "X" : 0

		2 : "X" : 0

		4 : "TRIGGERED" : 0

	]

]



@PointClass base(Trigger) size(-8 -8 -8, 8 8 8) 

	color(64 64 64) = trigger_relay : "trigger_relay"

[

]



@PointClass base(Trigger) size(-8 -8 -8, 8 8 8) = trigger_key : "trigger_key"

[

	item(string) : "Required Key"

]



@SolidClass base(Trigger) = trigger_counter : "trigger_counter" 

[

	count(integer) : "Count"

	spawnflags(Flags) = 

	[

		1 : "NO_MESSAGE" : 0

	]

]



@PointClass base(Trigger) size(-8 -8 -8, 8 8 8) = trigger_always : "trigger_always"

[

]



@SolidClass base(Trigger) = trigger_push : "trigger_push" 

[

	speed(integer) : "Speed" : 1000

	spawnflags(Flags) = 

	[

		1 : "PUSH_ONCE" : 0

	]

]



@SolidClass base(Trigger) = trigger_hurt : "trigger_hurt" 

[

	dmg(integer) : "Damage" : 5

	spawnflags(Flags) = 

	[

		1 : "START_OFF" : 0

		2 : "TOGGLE" : 0

		4 : "SILENT" : 0

		8 : "NO_PROTECTION" : 0

		16 : "SLOW" : 0

	]

]



@SolidClass base(Trigger) = trigger_gravity : "trigger_gravity" 

[

	gravity(string) : "Gravity" : "1.0"

]



@SolidClass base(Trigger) = trigger_monsterjump : "trigger_monsterjump" 

[

	speed(integer) : "Speed" : 200

	height(integer) : "Height" : 200

]



@PointClass base(Trigger) size(-8 -8 -8, 8 8 8) = trigger_elevator : "trigger_elevator"

[

]



//

// "TARGET_"

//



@baseclass base(Appearflags, Targetname, Target) size(-8 -8 -8, 8 8 8)

	color(128 0 32) = TargetClass

[

	killtarget(target_source) : "Kill target"

]



@PointClass base(TargetClass) = target_temp_entity : "target_temp_entity"

[

]



@SolidClass base(TargetClass) = target_actor : "target_actor" 

[

	pathtarget(string) : "Path Target"

	wait(string) : "Delay before reset" : "0.2"

	message(string) : "Message"

	speed(integer) : "Speed" : 200

	height(integer) : "Height" : 200

	spawnflags(Flags) = 

	[

		1 : "JUMP" : 0

		2 : "SHOOT" : 0

		4 : "ATTACK" : 0

		8 : "X" : 0

		16 : "HOLD" : 0

		32 : "BRUTAL" : 0

	]

]



@PointClass base(TargetClass) = target_speaker : "target_speaker"

[

	noise(string) : "Noise (.WAV)"

	attenuation(choices) : "Attenuation" : -1 =

	[

		-1 : "None, whole level"

		1 : "Normal fighting sounds"

		2 : "Idle sound level"

		3 : "Ambient sound level"

	]

	volume(string) : "Volume (0.0 - 1.0)"

	spawnflags(Flags) = 

	[

		1 : "LOOPED-ON" : 0

		2 : "LOOPED-OFF" : 0

		4 : "RELIABLE" : 0

	]

]



@PointClass base(TargetClass) size(-16 -16 -24, 16 16 24) = target_help : "target_help"

[

	message(string) : "Message"

]



@PointClass base(TargetClass) = target_secret : "target_secret"

[

]



@PointClass base(TargetClass) = target_goal : "target_goal"

[

]



@PointClass base(TargetClass) = target_explosion : "target_explosion"

[

	delay(integer) : "Delay before trigger"

	dmg(integer) : "Damage" : 0

]



@PointClass base(TargetClass) = target_changelevel : "target_changelevel"

[

	map(string) : "Map name"	

]



@PointClass base(TargetClass) = target_splash : "target_splash"

[

	sounds(choices) : "Sounds" =

	[

		1 : "Sparks"

		2 : "Blue Water"

		3 : "Brown Water"

		4 : "Slime"

		5 : "Lava"

		6 : "Blood"

	]

	count(integer) : "Count"

	dmg(integer) : "Damage" : 0

]



@PointClass base(TargetClass) = target_spawner : "target_spawner"

[

	direction(string) : "Direction" : "0 0 0"

	speed(integer) : "Speed" : 50

]



@PointClass base(TargetClass) = target_blaster : "target_blaster"

[

	dmg(integer) : "Damage" : 15

	speed(integer) : "Speed" : 1000

	spawnflags(Flags) = 

	[

		1 : "NOTRAIL" : 0

		2 : "NOEFFECTS" : 0

	]

]



@PointClass base(TargetClass) = target_crosslevel_trigger : "target_crosslevel_trigger"

[

	message(string) : "Message"

	delay(integer) : "Delay before trigger" : 2

	spawnflags(Flags) = 

	[

		1 : "TRIGGER1" : 0

		2 : "TRIGGER2" : 0

		4 : "TRIGGER3" : 0

		8 : "TRIGGER4" : 0

		16 : "TRIGGER5" : 0

		32 : "TRIGGER6" : 0

		64 : "TRIGGER7" : 0

		128 : "TRIGGER8" : 0

	]

]



@PointClass base(TargetClass) = target_crosslevel_target : "target_crosslevel_target"

[

	delay(integer) : "Delay before trigger" : 1

	spawnflags(Flags) = 

	[

		1 : "TRIGGER1" : 0

		2 : "TRIGGER2" : 0

		4 : "TRIGGER3" : 0

		8 : "TRIGGER4" : 0

		16 : "TRIGGER5" : 0

		32 : "TRIGGER6" : 0

		64 : "TRIGGER7" : 0

		128 : "TRIGGER8" : 0

	]

]



@PointClass base(TargetClass) = target_laser : "target_laser"

[

	direction(string) : "Direction" : "0 0 0"

	spawnflags(Flags) = 

	[

		1 : "START_ON" : 0

		2 : "RED" : 0

		4 : "GREEN" : 0

		8 : "BLUE" : 0

		16 : "YELLOW" : 0

		32 : "ORANGE" : 0

		64 : "FAT" : 0

	]

]



@PointClass base(TargetClass) = target_lightramp : "target_lightramp"

[

	message(string) : "Message (two letters)"

	speed(integer) : "Speed"

	spawnflags(Flags) = 

	[

		1 : "TOGGLE" : 0

	]

]



@PointClass base(TargetClass) = target_earthquake : "target_earthquake"

[

	count(integer) : "Duration" : 5

	speed(integer) : "Severity" : 200

]



@PointClass base(TargetClass) = target_character : "target_character"

[

	count(integer) : "Duration" : 5

]



@PointClass base(TargetClass) = target_string : "target_string"

[

]



//

// "FUNC_"

//



@baseclass base(Appearflags, Targetname, Target) color(96 96 96) = Func

[

	delay(integer) : "Delay before trigger" : 2

	wait(string) : "Delay before reset" : "0.2"

]



@SolidClass base(Func) = func_areaportal : "func_areaportal" 

[

]



@SolidClass base(Func) = func_wall : "func_wall" 

[

	spawnflags(Flags) = 

	[

		1 : "TRIGGER_SPAWN" : 0

		2 : "TOGGLE" : 0

		4 : "START_ON" : 0

		8 : "ANIMATED" : 0

		16 : "ANIMATED_FAST" : 0

	]

]



@SolidClass base(Func) = func_object : "func_object" 

[

	spawnflags(Flags) = 

	[

		1 : "TRIGGER_SPAWN" : 0

		2 : "ANIMATED" : 0

		4 : "ANIMATED_FAST" : 0

	]

]



@SolidClass base(Func) = func_explosive : "func_explosive" 

[

	health(integer) : "Health" : 100

	mass(integer) : "Mass" : 75

	dmg(integer) : "Damage"

	spawnflags(Flags) = 

	[

		1 : "TRIGGER_SPAWN" : 0

		2 : "ANIMATED" : 0

		4 : "ANIMATED_FAST" : 0

	]

]



@PointClass base(Appearflags, Targetname, Target) size(-8 -8 -8, 8 8 8) 

	color(0 0 255) = func_clock : "func_clock"

[

	count(integer) : "Count"

	pathtarget(integer) : "Pathtarget"

	style(choices) : "Style" : 0 =

	[

		0 : "XX"

		1 : "XX:XX"

		2 : "XX:XX:XX"

	]

	spawnflags(Flags) = 

	[

		1 : "TIMER_UP" : 0

		2 : "TIMER_DOWN" : 0

		4 : "START_OFF" : 0

		8 : "MULTI_USE" : 0

	]

]



@SolidClass base(Func) = func_plat : "func_plat" 

[

	speed(integer) : "Speed" : 200

	accel(integer) : "Acceleration" : 500

	lip(integer) : "Lip" : 8

	height(integer) : "Height"

	sounds(choices) : "Sounds" =

	[

		1 : "Base fast"

		2 : "Chain slow"

	]

	spawnflags(Flags) = 

	[

		1 : "PLAT_LOW_TRIGGER" : 0

	]

]



@SolidClass base(Func) = func_rotating : "func_rotating" 

[

	speed(integer) : "Speed" : 100

	dmg(integer) : "Damage" : 2

	spawnflags(Flags) = 

	[

		1 : "START_ON" : 0

		2 : "REVERSE" : 0

		4 : "X_AXIS" : 0

		8 : "Y_AXIS" : 0

		16 : "TOUCH_PAIN" : 0

		32 : "STOP" : 0

		64 : "ANIMATED" : 0

		128 : "ANIMATED_FAST" : 0

	]

]



@SolidClass base(Func) = func_button : "func_button" 

[

	speed(integer) : "Speed" : 40

	dmg(integer) : "Damage" : 2

	wait(string) : "Delay before reset" : "0.2"

	lip(integer) : "Lip" : 8

	health(integer) : "Health"

	sounds(choices) : "Sounds" =

	[

		1 : "Silent"

		2 : "Steam Metal"

		3 : "Wooden Clunk"

		4 : "Metallic Click"

		5 : "In-Out"

	]

]



@SolidClass base(Func) = func_door : "func_door" 

[

	message(string) : "Message"

	health(integer) : "Health"

	speed(integer) : "Speed" : 100

	dmg(integer) : "Damage" : 2

	wait(string) : "Delay before reset" : "0.2"

	lip(integer) : "Lip" : 8

	sounds(choices) : "Sounds" =

	[

		1 : "Silent"

		2 : "Light"

		3 : "Medium"

		4 : "Heavy"

	]

	spawnflags(Flags) = 

	[

		1 : "START_OPEN" : 0

		2 : "X" : 0

		4 : "CRUSHER" : 0

		8 : "NO_MONSTER" : 0

		16 : "ANIMATED" : 0

		32 : "TOGGLE" : 0

		64 : "ANIMATED_FAST" : 0

	]

]



@SolidClass base(Func) = func_door_rotating : "func_door_rotating" 

[

	distance(string) : "Distance (degrees)"

	message(string) : "Message"

	health(integer) : "Health"

	speed(integer) : "Speed" : 100

	dmg(integer) : "Damage" : 2

	wait(string) : "Delay before reset" : "0.2"

	lip(integer) : "Lip" : 8

	sounds(choices) : "Sounds" =

	[

		1 : "Silent"

		2 : "Light"

		3 : "Medium"

		4 : "Heavy"

	]

	spawnflags(Flags) = 

	[

		1 : "START_OPEN" : 0

		2 : "REVERSE" : 0

		4 : "CRUSHER" : 0

		8 : "NO_MONSTER" : 0

		16 : "ANIMATED" : 0

		32 : "TOGGLE" : 0

		64 : "X_AXIS" : 0

		128 : "Y_AXIS" : 0

	]

]



@SolidClass base(Func) = func_water : "func_water" 

[

	message(string) : "Message"

	speed(integer) : "Speed" : 100

	wait(string) : "Delay before reset" : "-1"

	lip(integer) : "Lip" : 0

	sounds(choices) : "Sounds" =

	[

		0 : "No Sound"

		1 : "Water"

		2 : "Lava"

	]

	spawnflags(Flags) = 

	[

		1 : "START_OPEN" : 0

	]

]



@SolidClass base(Func) = func_train : "func_train" 

[

	speed(integer) : "Speed" : 100

	noise(string) : "Noise"

	dmg(integer) : "Damage" : 2

	spawnflags(Flags) = 

	[

		1 : "START_ON" : 0

		2 : "TOGGLE" : 0

		4 : "BLOCK_STOPS" : 0

	]

]



@PointClass base(Appearflags, Targetname, Target) size(-8 -8 -8, 8 8 8) 

	color(0 0 255) = func_timer : "func_timer"

[

	wait(integer) : "Wait Between" : 1

	random(string) : "Random"

	pausetime(integer) : "Pause Time"

	delay(integer) : "Delay before trigger" : 2

	spawnflags(Flags) = 

	[

		1 : "START_ON" : 0

	]

]



@SolidClass base(Func) = func_conveyor  : "func_conveyor " 

[

	speed(integer) : "Speed" : 100

	spawnflags(Flags) = 

	[

		1 : "START_ON" : 0

		2 : "TOGGLE" : 0

	]

]



@SolidClass base(Func) = func_door_secret : "func_door_secret" 

[

	health(integer) : "Health"

	dmg(integer) : "Damage" : 2

	wait(string) : "Delay before reset" : "0.2"

	lip(integer) : "Lip" : 8

	spawnflags(Flags) = 

	[

		1 : "ALWAYS_SHOOT" : 0

		2 : "1ST_LEFT" : 0

		4 : "1ST_DOWN" : 0

	]

]



@SolidClass base(Func) = func_killbox : "func_killbox" 

[

]



//

// Misc Stuff

//



@PointClass base(Appearflags, Targetname, Target) size(-8 -8 -8, 8 8 8) 

	color(255 128 0) = path_corner : "path_corner"

[

	pathtarget(integer) : "Pathtarget"

	spawnflags(Flags) = 

	[

		1 : "TELEPORT" : 0

	]

]



@PointClass base(Appearflags, Targetname, Target) size(-8 -8 -8, 8 8 8) 

	color(255 128 0) = point_combat : "point_combat"

[

	pathtarget(integer) : "Pathtarget"

	spawnflags(Flags) = 

	[

		1 : "HOLD" : 0

	]

]



//

// "LIGHT_"

//



@PointClass base(Appearflags, Targetname, Target) size(-8 -8 -8, 8 8 8) 

	color(0 255 0) = light : "light"

[

	light(integer) : "Light" : 300

	style(integer) : "Style" : 0

	_cone(integer) : "Cone" : 10

	_color(string) : "Color (RGB)" : "255 255 255"

	spawnflags(Flags) = 

	[

		1 : "START_OFF" : 0

	]

]



@PointClass base(Appearflags, Targetname, Target) size(-2 -2 -12, 2 2 12) 

	color(0 255 0) = light_mine1 : "light_mine1"

[

	light(integer) : "Light" : 300

]



@PointClass base(Appearflags, Targetname, Target) size(-2 -2 -12, 2 2 12) 

	color(0 255 0) = light_mine2 : "light_mine2"

[

	light(integer) : "Light" : 300

]



//

// "ITEM_"

//



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 0) = item_armor_body : "item_armor_body"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 0) = item_armor_combat : "item_armor_combat"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 0) = item_armor_jacket : "item_armor_jacket"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 0) = item_armor_shard : "item_armor_shard"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 0) = item_power_screen : "item_power_screen"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 0) = item_power_shield : "item_power_shield"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = item_health : "item_health"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = item_health_small : "item_health_small"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = item_health_large : "item_health_large"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = item_health_mega : "item_health_mega"

[

]



//

// "WEAPON_"

//



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = weapon_shotgun : "weapon_shotgun"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = weapon_supershotgun : "weapon_supershotgun"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = weapon_machinegun : "weapon_machinegun"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = weapon_chaingun : "weapon_chaingun"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = weapon_grenadelauncher : "weapon_grenadelauncher"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = weapon_rocketlauncher : "weapon_rocketlauncher"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = weapon_hyperblaster : "weapon_hyperblaster"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = weapon_railgun : "weapon_railgun"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = weapon_bfg : "weapon_bfg"

[

]



//

// "AMMO_"

//



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = ammo_shells : "ammo_shells"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = ammo_bullets : "ammo_bullets"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = ammo_cells : "ammo_cells"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = ammo_grenades : "ammo_grenades"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = ammo_rockets : "ammo_rockets"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = ammo_slugs : "ammo_slugs"

[

]



//

// "ITEM_"

//



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = item_quad : "item_quad"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = item_invulnerability : "item_invulnerability"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = item_silencer : "item_silencer"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = item_breather : "item_breather"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = item_enviro : "item_enviro"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = item_ancient_head : "item_ancient_head"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = item_adrenaline : "item_adrenaline"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = item_bandolier : "item_bandolier"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(192 192 255) = item_pack : "item_pack"

[

]



//

// "KEY_"

//



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(0 128 192) = key_data_cd : "key_data_cd"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(0 128 192) = key_power_cube : "key_power_cube"

[

	spawnflags(Flags) = 

	[

		1 : "TRIGGER_SPAWN" : 0

		2 : "NO_TOUCH" : 0

	]

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(0 128 192) = key_pyramid : "key_pyramid"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(0 128 192) = key_data_spinner : "key_data_spinner"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(0 128 192) = key_pass : "key_pass"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(0 128 192) = key_blue_key : "key_blue_key"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(0 128 192) = key_red_key : "key_red_key"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(0 128 192) = key_commander_head : "key_commander_head"

[

]



@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) 

	color(0 128 192) = key_airstrike_target : "key_airstrike_target"

[

]



