unit QMPak;

interface

uses Objects, Dos, Crt;

var
 QuakeDir: String;

function CompareText(const T1,T2: String) : Integer;
procedure LowerCase(var S);
procedure ControleQuakeDir;
procedure ControleToolDir;
procedure OuvrirEntreeQuake(const Nom: String; var F: PStream);
function FichierSortie(Chemin: String) : String;

implementation

uses QMObj, QMUI;

const
 SignaturePACK = $4B434150;
 TailleNomFich = 56;

type
 TEntreePak = record
               NomFich : array[0..TailleNomFich-1] of Byte;
               Position, Taille : Longint;
              end;
 TIntroPak = record
              Signature : Longint;
              Position, NbEntrees : Longint;
             end;

function ScanPak(const NomFich, Nom: String; var Fr: PStream) : Boolean;
var
 F: PBufStream;
 Intro: TIntroPak;
 I: Integer;
 Entree: TEntreePak;
begin
 ScanPak:=False;
 New(F, Init(NomFich, stOpenRead, 1024));
 F^.Read(Intro, SizeOf(Intro));
 if (F^.Status<>stOk) or (Intro.Signature<>SignaturePACK) then
  begin
   Dispose(F, Done);
   Exit;
  end;
 Intro.NbEntrees:=Intro.NbEntrees div SizeOf(TEntreePak);
 F^.Seek(Intro.Position);
 for I:=1 to Intro.NbEntrees do
  begin
   F^.Read(Entree, SizeOf(Entree));
   if CompareText(CharToPas(Entree.NomFich), Nom) = 0 then
    begin
     F^.Seek(Entree.Position);
    {ScanPak:=Entree.Taille;}
   (*CacheEntrees.Add(Nom+'='+NomFich+'*'+IntToStr(Entree.Position)
      {+'?'+IntToStr(Entree.Taille)});*)
     Fr:=F;
     ScanPak:=True;
     Exit;
    end;
  end;
 Dispose(F, Done);
end;

procedure OuvrirEntreeQuake(const Nom: String; var F: PStream);
var
 S: SearchRec;
 NomDos: String;
 I: Integer;
begin
 FindFirst(QuakeDir+'\ID1\*.PAK', AnyFile, S);
 WHILE DosError=0 DO
  BEGIN
   if {Result:=}ScanPak(QuakeDir+'\ID1\'+S.Name, Nom, F)
   {if Result>=0} then Exit;
   FindNext(S);
  END;
 NomDos:=QuakeDir+'\ID1\'+Nom;
 while Pos('/', NomDos)<>0 do
  NomDos[Pos('/', NomDos)]:='\';
 F:=New(PBufStream, Init(NomDos, stOpenRead, 1024));
 if F^.Status=stOk then
  begin
(*{Result:=F.Size;}
   CacheEntrees.Add(Nom+'='+NomDos+'*0' {+'?'+IntToStr(Result)});*)
  end
 else
  begin
   Dispose(F, Done);
   Erreur('Quake file not found : '+Nom);
  end;
end;

function FichierSortie;
var
 P, I: Integer;
 Result: String;
begin
 Result:=QuakeDir+'\QMapExec\'+Chemin;
 P:=Length(QuakeDir)+1;
 repeat
  Inc(P);
  if Result[P]='/' then
   Result[P]:='\';
  if Result[P]='\' then
   begin
    {$I-}
    MkDir(Copy(Result, 1, P-1));
    {$I+}
    I:=IOResult;
   end;
 until P=Length(Result);
 FichierSortie:=Result;
end;

FUNCTION CompareText(const T1,T2: String) : INTEGER;

VAR
 I : INTEGER;

BEGIN
 CompareText:=1;
 IF Length(T1)<>Length(T2) THEN Exit;
 FOR I:=1 TO Length(T1) DO
  IF UPCASE(T1[I])<>UPCASE(T2[I]) THEN
   Exit;
 CompareText:=0;
END;

PROCEDURE ControleDir(const SetCmd, Prompt, Test: STRING);

VAR
 Fich, Dest : TEXT;
 Ligne   : STRING;
 S       : SearchRec;
 Modifie : BOOLEAN;
 I       : INTEGER;

BEGIN
 ASSIGN(Fich, 'QM.BAT');
 {$I-}
 RESET(Fich);
 {$I+}
 IF IOResult<>0 THEN
  Erreur('File not found : QM.BAT');
 QuakeDir:='';
 WHILE NOT EOF(Fich) DO
  BEGIN
   READLN(Fich, Ligne);
   IF Copy(Ligne, 1, Length(SetCmd)) = SetCmd THEN
    BEGIN
     QuakeDir:=Copy(Ligne, Length(SetCmd)+1, 255);
     Break;
    END;
  END;
 CLOSE(Fich);
 IF QuakeDir='' THEN
  Erreur('Invalid file : QM.BAT. Please reinstall the program.');
 Modifie:=False;
 REPEAT
  IF QuakeDir[Length(QuakeDir)]='\' THEN
   Dec(Byte(QuakeDir[0]));
  FindFirst(QuakeDir+Test, AnyFile, S);
  IF DosError=0 THEN
   Break;
  IF Modifie THEN
   qmWrite('Wrong input. File not found : '+QuakeDir+Test, Red+16*Blue)
  ELSE
   BEGIN
    qmWrite('', 16*Blue);
    qmWrite(Prompt, White+16*Blue);
    Modifie:=True;
   END;
  qmWrite('Enter directory : ', Yellow+16*Blue);
  if not UserInput(QuakeDir) then
   FinProgramme(' /stop');
 UNTIL False;
 IF Modifie THEN
  BEGIN
   ASSIGN(Dest, 'QM.BAK');
   {$I-}
   ERASE(Dest);
   {$I+}
   I:=IOResult;
   ASSIGN(Fich, 'QM.BAT');
   RENAME(Fich, 'QM.BAK');
   RESET(Fich);
   ASSIGN(Dest, 'QM.BAT');
   REWRITE(Dest);
   WHILE NOT EOF(Fich) DO
    BEGIN
     READLN(Fich, Ligne);
     IF Modifie AND (Copy(Ligne, 1, Length(SetCmd)) = SetCmd) THEN
      BEGIN
       Ligne:=SetCmd+QuakeDir;
       Modifie:=False;
      END;
     WRITELN(Dest, Ligne);
    END;
   CLOSE(Dest);
   CLOSE(Fich);
   ERASE(Fich);
  END;
END;

PROCEDURE ControleQuakeDir;

BEGIN
 ControleDir('set QUAKE=', 'Where is Quake ?', '\QUAKE.EXE');
END;

PROCEDURE ControleToolDir;

BEGIN
 ControleDir('set TOOLDIR=', 'Where are the QBSP, VIS and LIGHT utilities ?', '\QBSP.EXE');
END;

procedure LowerCase(var S);
assembler;
asm
 xor cx, cx
 les di, [S]
 mov cl, [es:di]
 inc cx
@Boucle:
 dec cx
 jz @Fin
 inc di
 mov al, [es:di]
 cmp al, 'A'
 jb @Boucle
 cmp al, 'Z'
 ja @Boucle
 add al, 32
 mov [es:di], al
 jmp @Boucle
@Fin:
end;


BEGIN
 QuakeDir:='';
END.