unit qmath;
{$N+}

interface

type
 Reel = Double;
 TVect = record
          X, Y, Z: Reel;
         end;

procedure Cross(const V1, V2: TVect; var Result: TVect);
function Dot(const V1, V2: TVect) : Reel;
procedure Normalise(var V: TVect);
function AngleXY(const X, Y: Reel) : Reel;
function LireVecteur(S: String; var V: TVect) : Boolean;
function ftos(const F: Reel) : String;

const
 Origine: TVect = (X:0; Y:0; Z:0);
 rien = 1E-5;

type
 TPoint = record
           X,Y: Integer;
          end;

type
 TModeDeplacement = (mdDeplacement, mdRotZ, mdSymXY, mdSymXZ, mdSymYZ);
 PTransformation = ^TTransformation;
 TTransformation = record
                    Suivant: PTransformation;
                    Clic: TVect;
                    Facteur, Facteur2: Reel;
                    ModeDeplacement: TModeDeplacement;
                   end;

procedure AppliqueVecteur(var Pt: TVect; Transf: PTransformation);

implementation

var
 Facteur: Reel;

procedure Cross(const V1, V2: TVect; var Result: TVect);
begin
 Result.X := v1.Y*v2.Z - v1.Z*v2.Y;
 Result.Y := v1.Z*v2.X - v1.X*v2.Z;
 Result.Z := v1.X*v2.Y - v1.Y*v2.X;
end;

function Dot(const V1, V2: TVect) : Reel;
begin
 Dot:=V1.X*V2.X + V1.Y*V2.Y + V1.Z*V2.Z;
end;

procedure Normalise(var V: TVect);
var
 F: Reel;
begin
 F:=1/Sqrt(Sqr(V.X)+Sqr(V.Y)+Sqr(V.Z));
 V.X:=V.X*F;
 V.Y:=V.Y*F;
 V.Z:=V.Z*F;
end;

function AngleXY;
begin
 if Abs(X)<rien then
  if Y>0 then
   AngleXY:=pi/2
  else
   AngleXY:=-pi/2
 else
  if X>0 then
   AngleXY:=ArcTan(Y/X)
  else
   AngleXY:=ArcTan(Y/X)+pi;
end;

function LireVecteur;
var
 I, Code: Integer;
begin
 LireVecteur:=False;
 repeat
  I:=Pos(' ', S);
  if I=0 then Exit;
  if I>1 then Break;
  Delete(S, 1, 1);
 until False;
 Val(Copy(S, 1, I-1), V.X, Code);
 if Code<>0 then Exit;
 S:=Copy(S, I+1, 255);
 repeat
  I:=Pos(' ', S);
  if I=0 then Exit;
  if I>1 then Break;
  Delete(S, 1, 1);
 until False;
 Val(Copy(S, 1, I-1), V.Y, Code);
 if Code<>0 then Exit;
 S:=Copy(S, I+1, 255);
 repeat
  I:=Pos(' ', S);
  if I=0 then
   begin
    I:=Length(S)+1;
    Break;
   end;
  if I>1 then Break;
  Delete(S, 1, 1);
 until False;
 Val(Copy(S, 1, I-1), V.Z, Code);
 if Code<>0 then Exit;
 LireVecteur:=True;
end;

procedure AppliqueVecteur(var Pt: TVect; Transf: PTransformation);
var
 Ancien: Reel;
begin
 case Transf^.ModeDeplacement of
  mdRotZ: begin
           Ancien:=Pt.X;
           Pt.X:=Ancien*Transf^.Facteur  - Pt.Y*Transf^.Facteur2;
           Pt.Y:=Ancien*Transf^.Facteur2 + Pt.Y*Transf^.Facteur;
          end;
  mdSymXY: Pt.Z:=-Pt.Z;
  mdSymXZ: Pt.Y:=-Pt.Y;
  mdSymYZ: Pt.X:=-Pt.X;
 end;
end;

function ftos(const F: Reel) : String;
var
 R: Integer;
 Result: String;
begin
 R:=Round(F);
 if Abs(F-R) <= rien then
  Str(R, Result)
 else
  Str(F:1:7, Result);
 ftos:=Result;
end;


end.