#include "stdafx.h"
#include <direct.h>
#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>

#include "qedefs.h"


char	token[MAXTOKEN];
boolean	unget;
char	*script_p;
int		scriptline;

void	StartTokenParsing (char *data)
{
	scriptline = 1;
	script_p = data;
	unget = FALSE;
}

boolean GetToken (boolean crossline)
{
	char    *token_p;

	if (unget)                         // is a token allready waiting?
		return TRUE;

//
// skip space
//
skipspace:
	while (*script_p <= 32)
	{
		if (!*script_p)
		{
			if (!crossline)
				Error ("Line %i is incomplete",scriptline);
			return FALSE;
		}
		if (*script_p++ == '\n')
		{
			if (!crossline)
				Error ("Line %i is incomplete",scriptline);
			scriptline++;
		}
	}

	if (script_p[0] == '/' && script_p[1] == '/')	// comment field
	{
		if (!crossline)
			Error ("Line %i is incomplete\n",scriptline);
		while (*script_p++ != '\n')
			if (!*script_p)
			{
				if (!crossline)
					Error ("Line %i is incomplete",scriptline);
				return FALSE;
			}
		goto skipspace;
	}

//
// copy token
//
	token_p = token;

	if (*script_p == '"')
	{
		script_p++;
		while ( *script_p != '"' )
		{
			if (!*script_p)
				Error ("EOF inside quoted token");
			*token_p++ = *script_p++;
			if (token_p == &token[MAXTOKEN])
				Error ("Token too large on line %i",scriptline);
		}
		script_p++;
	}
	else while ( *script_p > 32 )
	{
		*token_p++ = *script_p++;
		if (token_p == &token[MAXTOKEN])
			Error ("Token too large on line %i",scriptline);
	}

	*token_p = 0;
	
	return TRUE;
}

void UngetToken ()
{
	unget = TRUE;
}


/*
=================
Error

For abnormal program terminations
=================
*/
BOOL	in_error;
void Error (char *error, ...)
{
	va_list		argptr;
	static char		string[1024];
	
	if (in_error)
	{
	  AfxAbort();
	}	
	in_error = YES;
	
	va_start (argptr,error);
	vsprintf (string,error,argptr);
	va_end (argptr);

	strcat (string, "map saved to "FN_CRASHSAVE);
	map_i->writeMapFile(FN_CRASHSAVE,NO);
	MessageBox(NULL,string,"Error",MB_OK|MB_ICONSTOP);
		
	AfxAbort();
}



void CleanupName (char *in, char *out)
{
	int		i;
	
	for (i=0 ; i< 16 ; i++ )
	{
		if (!in[i])
			break;
			
		out[i] = toupper(in[i]);
	}
	
	for ( ; i< 16 ; i++ )
		out[i] = 0;
}

/*
============
FileTime

returns -1 if not present
============
*/
int	FileTime (char *path)
{
	struct	stat	buf;
	
	if (stat (path,&buf) == -1)
		return -1;
	
	return buf.st_mtime;
}

/*
============
CreatePath
============
*/
void	CreatePath (char *path)
{
	char	*ofs;
	
	for (ofs = path+1 ; *ofs ; ofs++)
	{
		if (*ofs == '/')
		{	// create the directory
			*ofs = 0;
			mkdir (path);
			*ofs = '/';
		}
	}
}

int I_FileOpenRead (char *path, int *handle)
{
	int	h;
	struct stat	fileinfo;
    
	
	h = open (path, _O_RDONLY, 0666);
	*handle = h;
	if (h == -1)
		return -1;
	
	if (fstat (h,&fileinfo) == -1)
		Error ("Error fstating %s", path);

	return fileinfo.st_size;
}

int I_FileOpenWrite (char *path)
{
	int     handle;

	umask (0);
	
	handle = open(path,_O_RDWR | _O_CREAT | _O_TRUNC);

	if (handle == -1)
		Error ("Error opening %s: %s", path,strerror(errno));

	return handle;
}

/*
============
Sys_UpdateFile

Copies a more recent net file to the local drive
============
*/
void Sys_UpdateFile (char *path, char *netpath)
{
	int		ltime, ntime;
	int		in, out, size;
	char	*buf;
	
	ltime = FileTime (path);
	ntime = FileTime (netpath);
	
	if (ntime <= ltime)
		return;		// up to date
		
// copy the file
	printf ("UpdateFile: copying %s to %s...\n", netpath, path);
	
	size = I_FileOpenRead (netpath, &in);
	buf = (char *)malloc (size);
	if (read (in, buf, size) != size)
		Error ("UpdateFile: couldn't read all of %s", netpath);
	close (in);

	CreatePath (path);	
	out = I_FileOpenWrite (path);
	write (out, buf, size);
	close (out);
	
}


COLORREF ColorFromFloat3(float *colors)
{
  return RGB(int(colors[0] * 255),
             int(colors[1] * 255),
             int(colors[2] * 255));
}

#include "wincon.h"

void qprintf(char *fmt,...)
{
  static char buffer[1024];
  va_list va;
  va_start(va,fmt);
  vsprintf(buffer,fmt,va);
  va_end(va);
  console_i->InsertText(buffer);
}