// TextureStatic.cpp : implementation file
//

#include "stdafx.h"
#include "QuakeEdit.h"
#include "TextureStatic.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTextureStatic

CTextureStatic::CTextureStatic()
{
  m_pTexture = NULL;
  m_pPalette = NULL;
}

CTextureStatic::~CTextureStatic()
{
}


BEGIN_MESSAGE_MAP(CTextureStatic, CStatic)
	//{{AFX_MSG_MAP(CTextureStatic)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTextureStatic message handlers

void CTextureStatic::OnPaint() 
{
	if(m_pTexture && m_pPalette)
  {
    CPaintDC dc(this);
    
    GetParent()->SendMessage(WM_CTLCOLORSTATIC,WPARAM(dc.m_hDC),LPARAM(m_hWnd));
    CRect myRect;
    GetClientRect(&myRect);
    dc.Rectangle(&myRect);
    
    CPalette* pOldPal = dc.SelectPalette(m_pPalette,
                                           FALSE);
    dc.RealizePalette();
    // Draw the DIB.
    m_pTexture->Draw(&dc, 1, 1, myRect.Width() - 1, myRect.Height() - 1);
    // Restore the DC.
    dc.SelectPalette(pOldPal, FALSE);
}
  else CStatic::OnPaint();
	
}

void CTextureStatic::SetTexture(CDIB *b,CDIBPal *p)
{
  m_pTexture = b;
  m_pPalette = p;
  Invalidate();
}
