#ifndef SETBRUSH_H
#define SETBRUSH_H

#include "entity.h"

#define   MAX_FACES   16



typedef struct
{
  int   numpoints;
  vec5_t  points[8];      // variable sized
} winding_t;

#define MAX_POINTS_ON_WINDING 64

typedef struct
{
  vec3_t    normal;
  float   dist;
} plane_t;

typedef struct
{
// implicit rep
  vec3_t      planepts[3];
  texturedef_t  texture;

// cached rep
  plane_t     plane;
  qtexture_t    *qtexture;
  float     light;    // 0 - 1.0
  winding_t   *w;
} face_t;

#define ON_EPSILON    0.1
#define FP_EPSILON    0.01
#define VECTOR_EPSILON  0.0001

#define SIDE_FRONT    0
#define SIDE_BACK   1
#define SIDE_ON     2


winding_t *ClipWinding (winding_t *in, plane_t *split);
winding_t *CopyWinding (winding_t *w);
winding_t *NewWinding (int points);

extern  vec3_t  region_min, region_max;
extern  int   numcontrolpoints;
extern  float *controlpoints[MAX_FACES*3];
extern  vec3_t  sb_translate;
extern  Entity  * carve_in, *carve_out;
extern  vec3_t  sb_mins, sb_maxs;
extern  vec3_t  sel_x, sel_y, sel_z;
extern  vec3_t  sel_org;
extern  Entity  *sb_newowner;
extern  vec3_t  select_min, select_max;
extern  float sb_floor_dir, sb_floor_dist;

#define BRUSH_ZDRAW_SELF  1
#define BRUSH_XYDRAW_SELF 2
#define BRUSH_DESELECT    3
#define BRUSH_TRANSFORM   4
#define BRUSH_ADDTOBBOX   5
#define BRUSH_FLUSHTEXTURES 6
#define BRUSH_TAKECURRENTTEXTURE 7
#define BRUSH_TRANSLATE    8
#define BRUSH_CARVEBYCLIPPER 9
#define BRUSH_MOVETOENTITY 10
#define BRUSH_REMOVE 11
#define BRUSH_CAMERADRAWSELF 12
#define BRUSH_FEET_TO_FLOOR 13
#define BRUSH_NEWREGION     14
#define BRUSH_FLIPNORMALS 15
#define BRUSH_SELECTCOMPLETE 16
#define BRUSH_SELECTPARTIAL 17
#define BRUSH_CAMERA_RENDERSELF  18
#define BRUSH_XYRENDERSELF 19

class SetBrush : public CObject
{
protected:
  BOOL    regioned;   // not active
  BOOL    selected;

  BOOL    invalid;    // not a proper polyhedron

  Entity      *parent;     // the entity this brush is in
  vec3_t    bmins, bmaxs;
  vec3_t    entitycolor;
  int     numfaces;
  face_t    faces[MAX_FACES];
public:
	SetBrush * copy();
	void perform(int nAction);
  SetBrush();  
  ~SetBrush();
  void initOwner(Entity *,float *mins,float *maxs,texturedef_t *tex);
  void initFromTokens(Entity *);
  void setMins(float *mins,float *maxs);

  Entity *getParent();
  void setParent(Entity *);

  void setEntityColor(vec3_t color);

  void calcWindings();

  void writeToFILE(FILE *f,BOOL reg);

  BOOL getSelected();
  BOOL getRegioned();
  void setSelected(BOOL s);
  void setRegioned(BOOL s);

  void getMins(vec3_t&,vec3_t&); // ref

  BOOL containsPoint(vec3_t& pt); // ref

  void freeWindings();
  BOOL removeIfInvalid();
  void clipByFace(face_t *fa,SetBrush **f,SetBrush **b);

  void newRegion();

  texturedef_t *texturedef();
  texturedef_t *texturedefForFace(int f);
  void setTexturedef(texturedef_t *tex);
  void setTexturedef(texturedef_t *tex,int f);

  void XYDrawSelf();
  void ZDrawSelf();
  void CameraDrawSelf();
  void XYRenderSelf();
  void CameraRenderSelf();
  void drawConnections();
  BOOL fakeBrush(int call);

  void hitByRay(vec3_t p1, vec3_t p2, float *time,int *face);
  void clipRay(vec3_t p1, vec3_t p2, vec3_t frontpoint,
		int *f_face, vec3_t backpoint, int *b_face);

//
// single brush actions
//
  void getZdragface(vec3_t dragpoint);  // ref
  void getXYdragface(vec3_t dragpoint);  // ref
  void getXYShearPoints(vec3_t dragpoint);  // ref

  SetBrush *addFace(face_t *f);

//
// multiple brush actions
//
  void carveByClipper();


  void translate();


  void select();
  void deselect();
  void remove();
  void flushTextures();


  void addToBBox();

  void transform();

  void flipNormals();

  void carve();
  void setCarveVars();


  void moveToEntity();

  void takeCurrentTexture();

  BOOL checkModifiable();
  void  selectPartial();
  void selectComplete();
  void regionPartial();
  void regionComplete();


  void feetToFloor();

  int getNumBrushFaces();
  face_t *getBrushFace(int which);
};

#endif

