// QXYView.h : header file
//
#ifndef QXYVIEW_H
#define QXYVIEW_H

#include "mathlib.h"
#include "SetBrush.h"
#include "QuakeView.h"

class XYView;

extern	XYView *xyview_i;

#define	MINSCALE	0.125
#define	MAXSCALE	2.0

extern	vec3_t		xy_viewnormal;		// v_forward for xy view
extern	float		xy_viewdist;		// clip behind this plane

extern	CRect	xy_draw_rect;

void linestart (float r, float g, float b);
void lineflush (void);
void linecolor (float r, float g, float b);

void XYmoveto (vec3_t pt);
void XYlineto (vec3_t pt);
void XYpolyline(vec5_ts *p,int c);

typedef enum {dr_wire, dr_flat, dr_texture} drawmode_t;

class CGLXY : public CGL
{
public:  
  CGLXY();
  virtual ~CGLXY();

protected:
 	
  // Override
	virtual BOOL OnResize(int cx, int cy) ;
	virtual BOOL OnInit() ;
	virtual BOOL OnRender() ;	
};

extern CGLXY *glxy_i;




/////////////////////////////////////////////////////////////////////////////
// XYView view

class XYView : public CQuakeView
{
public:
	XYView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(XYView)
protected:  
    void (*m_Callback)(float,float);

// Attributes
public:

// Operations
public:
  virtual BOOL FlipY();
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(XYView)
	public:
	virtual void OnInitialUpdate();
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~XYView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(XYView)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
  afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnDestroy();
	afx_msg void OnPaletteChanged(CWnd* pFocusWnd);
	afx_msg BOOL OnQueryNewPalette();
	afx_msg BOOL OnNcCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

	CRect		realbounds, newrect, combinedrect;
	CPoint		midpoint;
	int			gridsize;
	float		scale;

// for textured view
	int			xywidth, xyheight;
	float		*xyzbuffer;
	unsigned	*xypicbuffer;

	drawmode_t	drawmode;
  void dragFrom(CPoint *startevent , BOOL usegrid,
	 void (*callback)(float dx, float dy));
  BOOL planeDragFrom(CPoint *pt);
  BOOL shearDragFrom(CPoint *pt);
  void directionDragFrom(CPoint *pt);
// UI links
//	id			mode_radio_i;	
public:
	float currentScale();

//	void  setModeRadio(: m);

//	- drawMode: sender;
	void  setDrawMode(drawmode_t mode);
  drawmode_t getDrawMode();
	void newRealBounds(CRect *nb);
  void newBrushDragFrom(CPoint&);
  float snapToGrid(float f);
/*	void  newSuperBounds();
	void  newRealBounds(CRect *nb);

	void addToScrollRange(float x,float y);*/
	void setOrigin(CPoint *pt,float scale);
	void centerOn(vec3_t org);

//	- drawMode: sender;

//	void  superviewChanged();

	int getGridsize();
  void setGridSize(int);
  void drawGrid(CRect&);
  void drawWire();
  void drawSolid();
  void selectionDragFrom(CPoint *point)	;
protected:
	CGLXY* m_pGL;
  void SetMatrices();
};
#endif
/////////////////////////////////////////////////////////////////////////////
