// QThings.cpp : implementation file
//

#include "stdafx.h"
#include "QuakeEdit.h"
#include "QThings.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CThings

CThings *things_i = NULL;

CThings::CThings()
{
  lastSelected = 0;
  things_i = this;
}

CThings::~CThings()
{
  if (entity_classes_i)
	  delete entity_classes_i;
}


BEGIN_MESSAGE_MAP(CThings, CInspector)
	//{{AFX_MSG_MAP(CThings)
	ON_BN_CLICKED(IDC_CREATEENT, OnCreateEnt)
	ON_BN_CLICKED(IDC_RELOADCLASSES, OnReloadClasses)
	ON_LBN_SELCHANGE(IDC_KEYPAIR, OnSelchangeKeypair)
	ON_BN_CLICKED(IDC_DELETE, OnDelete)
	ON_BN_CLICKED(IDC_ADD, OnAdd)
	ON_LBN_SELCHANGE(IDC_CLASSES, OnSelchangeClasses)
	ON_BN_CLICKED(IDC_ANGLE_0, OnAngle0)
	ON_BN_CLICKED(IDC_ANGLE_135, OnAngle135)
	ON_BN_CLICKED(IDC_ANGLE_180, OnAngle180)
	ON_BN_CLICKED(IDC_ANGLE_225, OnAngle225)
	ON_BN_CLICKED(IDC_ANGLE_270, OnAngle270)
	ON_BN_CLICKED(IDC_ANGLE_315, OnAngle315)
	ON_BN_CLICKED(IDC_ANGLE_45, OnAngle45)
	ON_BN_CLICKED(IDC_ANGLE_90, OnAngle90)
	ON_BN_CLICKED(IDC_ANGLE_DN, OnAngleDn)
	ON_BN_CLICKED(IDC_ANGLE_UP, OnAngleUp)
  ON_LBN_DBLCLK(IDC_CLASSES, OnCreateEnt)
	ON_BN_CLICKED(IDC_SW_1_1, OnChangeFlags)
	ON_BN_CLICKED(IDC_SW_1_2, OnChangeFlags)
	ON_BN_CLICKED(IDC_SW_1_3, OnChangeFlags)
	ON_BN_CLICKED(IDC_SW_1_4, OnChangeFlags)
	ON_BN_CLICKED(IDC_SW_2_1, OnChangeFlags)
	ON_BN_CLICKED(IDC_SW_2_2, OnChangeFlags)
	ON_BN_CLICKED(IDC_SW_2_3, OnChangeFlags)
	ON_BN_CLICKED(IDC_SW_2_4, OnChangeFlags)
	ON_BN_CLICKED(IDC_SW_3_1, OnChangeFlags)
  ON_BN_CLICKED(IDC_SW_3_2, OnChangeFlags)
  ON_BN_CLICKED(IDC_SW_3_3, OnChangeFlags)
	ON_BN_CLICKED(IDC_SW_3_4, OnChangeFlags)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static int flagsId[]={
	IDC_SW_1_1, 
	IDC_SW_1_2, 
	IDC_SW_1_3, 
	IDC_SW_1_4, 
	IDC_SW_2_1, 
	IDC_SW_2_2, 
	IDC_SW_2_3, 
	IDC_SW_2_4, 
	IDC_SW_3_1, 
  IDC_SW_3_2, 
  IDC_SW_3_3, 
	IDC_SW_3_4
};


/////////////////////////////////////////////////////////////////////////////
// CThings message handlers
//
void CThings::initEntities()
{	
  const char	*path = preferences_i->getClassPath();
  
  entity_classes_i = new EntityClassList;
	entity_classes_i->initForSourceDirectory((char *)path);

  if(entity_classes_i->GetSize())
	  loadEntityComment(entity_classes_i->GetAt(lastSelected));
  FillClassList();

  m_wndProgDir.SetWindowText(path);
}

void CThings::loadEntityComment(EntityClass *c)
{
	m_wndComment.SetWindowText(c->getComments());
}


char *CThings::spawnName()
{
	return entity_classes_i->GetAt(lastSelected)->classname();
}

void CThings::OnCreateEnt() 
{
	map_i->makeEntity();
}

void CThings::OnReloadClasses() 
{
	EntityClass *ent;
	CString path;
	
	m_wndProgDir.GetWindowText(path);
	if (!path.GetLength() || !path[0])
	{
    path = preferences_i->getClassPath();
    m_wndProgDir.SetWindowText(path);
	}
  else preferences_i->setClassPath(path);
	
	//	Free all entity info in memory...
  if (entity_classes_i)
	  delete entity_classes_i;
	
	//	Now, RELOAD!
	entity_classes_i = new EntityClassList;
  entity_classes_i->initForSourceDirectory((char *)(const char *)path);

	lastSelected = 0;
	if(entity_classes_i->GetSize())
  {  
    ent = entity_classes_i->GetAt(lastSelected);
    loadEntityComment(ent);
  }
  	
  FillClassList();
	newCurrentEntity();	// in case flags changed
}


void CThings::newCurrentEntity()
{
	char	*classname;
	char	*flagname;
	int		flags;
	
	Entity *ent = map_i->getCurrentEntity();
	classname = ent->valueForQKey("classname");
	if (ent != map_i->GetAt(0))
		selectClass(classname);	// don't reset for world
	
  EntityClass *classent = entity_classes_i->classForName(classname);
	flagname = ent->valueForQKey("spawnflags");
	if (!flagname || !strcmp(flagname,""))
		flags = 0;
	else
		flags = atoi(flagname);

	for(int i = 0; i < 12; i++)
	{
		CButton *pButton = (CButton *)GetDlgItem(flagsId[i]);
    if (i < 8)
		{
			flagname = classent->flagName(i);
      CString strLower = flagname;
      strLower.MakeLower();
			pButton->SetWindowText(strLower);
		}
		pButton->SetCheck((flags & (1<< i) ) > 0);
	}

  FillKeyPairList();
}

//
//	Clicked in the Keypair view - set as selected
//
void CThings::setSelectedKey(epair_t *ep)
{
	m_wndKey.SetWindowText(ep->key);
	m_wndValue.SetWindowText(ep->value);
}

void CThings::clearInputs()
{
  m_wndKey.SetWindowText("");
  m_wndValue.SetWindowText("");
}

void CThings::FillClassList()
{
	m_wndClasses.ResetContent();
  for(int i = 0; i < entity_classes_i->GetSize(); i++)
  {
    EntityClass *c = entity_classes_i->GetAt(i);
    m_wndClasses.InsertString(-1,c->classname());
  }
  m_wndClasses.SetCurSel(0);
}

void CThings::FillKeyPairList()
{
	m_wndKeyPair.ResetContent();
  epair_t	*pair = map_i->getCurrentEntity()->getepairs();
	for ( ; pair ; pair=pair->next)
	{
		CString str = pair->key;
    str += '\t';
    str += pair->value;
    m_wndKeyPair.InsertString(-1,str);
	}
  clearInputs();
}

void CThings::OnSelchangeKeypair() 
{
	epair_t	*pair = map_i->getCurrentEntity()->getepairs();
  int i = 0;
  int nSel = m_wndKeyPair.GetCurSel();
	for ( ; pair ; pair=pair->next,i++)
	{
	  if (i==nSel)
    {
      setSelectedKey(pair);
      break;
    }
	}
}

void CThings::OnDelete() 
{
	CString key;
  m_wndKey.GetWindowText(key);
  map_i->getCurrentEntity()->removeKeyPair((char *)(const char *)key);

	FillKeyPairList();
}

void CThings::OnAdd() 
{
	CString key,value;
	
	m_wndKey.GetWindowText(key);
	m_wndValue.GetWindowText(value);
	
	map_i->getCurrentEntity()->setKey((char *)(const char *)key,
                                    (char *)(const char *)value);
  
  FillKeyPairList();
}

void CThings::selectClass(const char *className)
{
	EntityClass *classent = entity_classes_i->classForName((char *)className);
	if (!classent)
		return;
	lastSelected = 0;
  for(int i = 0; i < entity_classes_i->GetSize(); i++)
    if(entity_classes_i->GetAt(i) == classent)
    {
      lastSelected = i;
      break;
  }
	
	if (lastSelected < 0)
		lastSelected = 0;
		
	loadEntityComment(classent);
	m_wndClasses.SetCurSel(lastSelected);
}

void CThings::OnSelchangeClasses() 
{
	lastSelected = m_wndClasses.GetCurSel();
  int sel = m_wndClasses.GetCurSel();
  if (sel != LB_ERR)
    loadEntityComment(entity_classes_i->GetAt(sel));
}

BOOL CThings::Create(CWnd *pParent) 
{
  if(!CInspector::Create(pParent,IDD_THINGS))
  {
		return FALSE;    // fail to create
  }
  
  int nStop = 55;
  m_wndKeyPair.SetTabStops(nStop);
  
  SetWindowText("Entities");

  return TRUE;
}

void CThings::DoDataExchange(CDataExchange* pDX) 
{
	CInspector::DoDataExchange(pDX);
  
  DDX_Control(pDX,IDC_KEY,m_wndKey);
  DDX_Control(pDX,IDC_VALUE,m_wndValue);
  DDX_Control(pDX,IDC_KEYPAIR,m_wndKeyPair);
  DDX_Control(pDX,IDC_COMMENT,m_wndComment);
  DDX_Control(pDX,IDC_CLASSES,m_wndClasses);
  DDX_Control(pDX,IDC_PROGDIR,m_wndProgDir);
}

void CThings::OnAngle0() 
{
	SetAngle("0");
}

void CThings::OnAngle135() 
{
	 SetAngle("135");
}

void CThings::OnAngle180() 
{
	 SetAngle("180");
}

void CThings::OnAngle225() 
{
	SetAngle("225");
}

void CThings::OnAngle270() 
{
	SetAngle("270");
}

void CThings::OnAngle315() 
{
	SetAngle("315");
}

void CThings::OnAngle45() 
{
	SetAngle("45");
}

void CThings::OnAngle90() 
{
	SetAngle("90");
}

void CThings::OnAngleDn() 
{
	SetAngle("-2");
}

void CThings::OnAngleUp() 
{
	SetAngle("-1");
}

void CThings::SetAngle(const char *strAngle)
{
  m_wndKey.SetWindowText("angle");
  m_wndValue.SetWindowText(strAngle);
  
  OnAdd();

  clearInputs();
}


void CThings::OnChangeFlags() 
{
	int		flags;
	char	str[20];
	
	clearInputs();
	flags = 0;

  for(int i = 0; i < 12; i++)
  {
    int f = ((CButton *)GetDlgItem(flagsId[i]))->GetCheck();
    flags |= (f<< i);
  }
	
  if (!flags)
		map_i->getCurrentEntity()->removeKeyPair("spawnflags");
	else
	{
		sprintf (str, "%i", flags);
		map_i->getCurrentEntity()->setKey("spawnflags",str);
	}

  FillKeyPairList();
}

