#ifndef MAP_H
#define MAP_H

#include "qedefs.h"

// Map is a list of Entity objects

class Map;
class Entity;
class SetBrush;

extern  Map  *map_i;

class Map : public CTypedPtrArray<CPtrArray,Entity*>
{
protected: 
  Entity   *currentEntity;
  Entity *oldselection; // temp when loading a new map
  float minz, maxz;
  BOOL  abortEnabled;
public:  
  Map();
  ~Map();
  void newMap();
  void readMapFile(char *fname);
  void writeMapFile(char *fname, BOOL reg);
  void entityConnect(vec3_t p1,vec3_t p2);
  void selectRay(vec3_t p1, vec3_t p2, BOOL ef);
  SetBrush *grabRay(vec3_t p1,vec3_t p2);
  void setTextureRay(vec3_t p1, vec3_t p2, BOOL allsides);
  SetBrush *getTextureRay(vec3_t p1, vec3_t p2);
  Entity *getCurrentEntity();
  void setCurrentEntity(Entity *);
  float currentMinZ();
  void setCurrentMinZ(float m);
  float currentMaxZ();
  void setCurrentMaxZ(float m);
  int numSelected();
  SetBrush *selectedBrush();
  void removeObject(CObject *);
  void saveSelected();
  void addSelected();
  void enableAbort(BOOL bEnable) 
  { abortEnabled = bEnable; }
  void makeSelectedPerform(int sel);
  void makeUnselectedPerform(int sel);
  void makeAllPerform(int sel);
  void makeGlobalPerform(int sel);  // in and out of region
  void subtractSelection();
  void cloneSelection();

  void makeEntity();

  void selectCompletelyInside();
  void selectPartiallyInside();

  void tallBrush();
  void shortBrush();
  void transformSelection();

  void rotate_x();
  void rotate_y();
  void rotate_z();

  void flip_x();
  void flip_y();
  void flip_z();

  
  void selectCompleteEntity();
  void selbox(UINT);

  BOOL checkAbort();
};

#endif