Option Explicit

'This is a type used to hold the x,y location of the cursor whenever I
'need to find out where it is.
Type PointApi
    X As Integer
    Y As Integer
End Type

'This is going to be used to keep track of the x,y,z, co-ords of the maps
'"nodes"
Type Coords
    X As Integer
    Y As Integer
    Z As Integer
End Type

'This is the same as Co-ords (so I don't really need to declare it again,
'but there you go, this is used to keep track of the player, deathmatch
'and co-op starts.
Type Starts
    X As Integer
    Y As Integer
    Z As Integer
End Type

'Cursor API calls, to turn it on/off, get the position and set the position.
'This is used for the sliders, to hide the mouse when it's held down
'and to show it when the button is released.  This isn't needed but it helps
'the user see what they're using, rather than looking at the mouse.
'
'In this program it's not really that important, but my other programs use
'this if the slider was going to change it's apperance (which I do sometimes
'for "dynamic feedback button/slider/icon devices" :)  so it's here from
'habit really.
Declare Function ShowCursor Lib "User" (ByVal bShow As Integer) As Integer

'Again, these are in for habit... when coding the afore mentioned "dynamic"
'icons, the icons "state" would depend on the cursor x,y co-ords.  So the
'user would click down on an icon, the mouse would "hide" and the co-ords
'would be stored, they would move it round the screen, when the button was
'released, it would be set back to the stored co-ords and would be "unhidden"
'
'This is used for the slider, the y value is allowed to change (up-down) but
'the x value (left-right) is restored, so when the mouse button is released
'it ends up over the slider.
'
'Try moving the scroll bar on the right of this window, the cursor not
'only moves up and down, but you can also move it left-right.  Now
'run this program and slide the water slider up and down, you'll notice
'that the cursor re-appears over the slider.  It's a simple trick but a
'very effect one, it should be so natural that you don't notice it.

Declare Sub GetCursorPos Lib "User" (lpPoint As PointApi)
Declare Sub SetCursorPos Lib "User" (ByVal X%, ByVal Y%)

'Used to keep track of the cursors position.
Global LCurrentX As Long
Global LCurrentY As Long
Global LOldX As Long
Global LOldY As Long
Global LStoreX As Long
Global LStoreY As Long

'These are Global Constants used to make the code more "readable", you'll
'see what I mean by looking at the rest of the code.

'Sounds
Global Const Bubbles = 1
Global Const Drip = 2
Global Const Drone = 3
Global Const Comp_hum = 4
Global Const Swamp1 = 5
Global Const Swamp2 = 6

'items
Global Const Cells = 1
Global Const BCells = 101
Global Const Rockets = 2
Global Const BRockets = 102
Global Const Shells = 3
Global Const BShells = 103
Global Const Nails = 4
Global Const BNails = 104
Global Const Health = 5
Global Const BHealth = 105
Global Const MegaHealth = 205
Global Const Suit = 10
Global Const Quad = 11
Global Const Pent = 12
Global Const Ring = 13
Global Const RedA = 20
Global Const YellowA = 21
Global Const GreenA = 22
Global Const RAD = 30

'monsters
Global Const Army = 1
Global Const Dog = 2
Global Const Ogre = 3
Global Const Knight = 4
Global Const Zombie = 5
Global Const Wizard = 6
Global Const Demon1 = 7
Global Const Shambler = 8
Global Const Enforcer = 9
Global Const fish = 10
Global Const hell_knight = 11
Global Const shalrath = 12
Global Const tarbaby = 13

'weapons
Global Const ShotGun = 50
Global Const SuperShotgun = 51
Global Const NailGun = 52
Global Const SuperNailGun = 53
Global Const GrenadeL = 54
Global Const RocketL = 55
Global Const Lightning = 56

'Lights
Global Const light = 1
Global Const WallTorch = 2
Global Const Flame_Large_Yellow = 3
Global Const Flame_Small_Yellow = 4
Global Const Flame_Small_White = 5
Global Const Fluoro = 6
Global Const Flurospark = 7
'Style
Global Const Normal = 1
Global Const Pulsates = 2
Global Const Flickers = 3


'Used to keep track of which option has been selected on the "plot" menu.
'For example view_mode = Mode_Item, would show that items was the
'currenty selected view.
'Current item view mode.
Global View_Mode As Integer
Global Const Mode_Player = 1
Global Const Mode_Deathmatch = 2
Global Const Mode_Coop = 3
Global Const Mode_item = 4
Global Const Mode_monster = 5
Global Const Mode_light = 6
Global Const Mode_sound = 7

'Keeps track of which object has been selected fopr placing
'in each view mode.
Global item_item As Integer
Global item_monster As Integer
Global item_light As Integer
Global item_sound As Integer

Sub notes_readme ()

    'Welcome to the program...
    '
    'If you want this code to teach you good programming then you're
    'looking in the wrong place :)   There's a lot of duplicated code
    'there are place I KNOW things could be cut down (in the drawing
    'the icons sections).  But this is left as an exercise for the
    'reader *grin*
    '
    'Those who are interested in the creation of the landscape should
    'pay most attention to the sub-routines;
    '
    'Sub LTBL ()
    'Sub Make_World (IFromX, IFromY, IToX, IToY As Integer)
    'Sub Set_Heights (IMinX, IMinY, IMaxX, IMaxY As Integer)
    'Sub Max_Min (IMaxX, IMaxY As Integer)
    'Scale_World (IMaxX, IMaxY, ITop, IBottom As Integer)
    '
    'These are all in the (general) section of the FQuake.Frm
    '
    'LTBL (let there be light) sets the random values of the
    'four starting corners, it then calls the Make_World passing
    'it the value of the 4 corners. When Make_World has finished
    'it calls Max_Min starts the scaling of the world.
    '
    'Make_World calls the Set_Heights and then itself 4
    'more times.  Make_world is passed the 4 co-ords of the corners
    'so when it's calling itself the 4 times it's passing the values
    'of the 4 points it was passed divided into 4 quaters (so it's a
    'recursive function) it keeps calling itself until it reaches the
    'smallest unit (the point at which it can't divide the distance
    'between the passed values anymore).
    'if it was working in 2 dimensions it would work like this.
    'Pass it (0,16)
    'it then calls itself with (0,7) & (8,16)
    '
    '(0,16) => (0,7) & (8,16)
    '   (0,7)  => (0,3) & (4,7)
    '       (0,3)   => (0,1) & (1,2)
    '           (0,1)
    '           (1,2)
    '       (4,7)   => (4,5) & (6,7)
    '           (4,5)
    '           (6,7)
    '   (8,16) => (8,11) & (12,16)
    '       (8,11)  => (8,9) & (10,11)
    '           (8,9)
    '           (10,11)
    '       (12,16) => (12,14) & (15,16)
    '           (12,14)
    '           (15,16)
    '
    'Of course the values that are passed actually have to be calculated
    'but you can see that in the Sub itself.
    '
    '
    'Set_Heights basically works out the heights of newly created points
    'from the values of the points of the lines they divide.
    '
    'Max_Min, the heights are random there is no way the maximum and minimum
    'can be guaranteed to match the values selected by the user.  This
    'sub searches through the map finding the highest and lowest points.
    'Once these points are found the values are passed to Scale_World.
    '
    'Scale_World, takes the values of the highest and lowest points, and
    'looks at the user selected values.  It then works out the factor needed
    'to multiply each hieght to make it scale-up or down to the correct
    'values (i.e. if the highest value was 128, but the user has selected
    '512 then each value is multiplied by 2, there's a little more to it
    'than that but that's in the sub itself.
    '
    'And that's what's needed to make the world.
    '
    'These subs (and others) use values stored in text boxes.  The sliders
    'for example actually change the values in text boxes that are hidden,
    'the values from the text boxes are then used to change the label next
    'to the slider.
    '
    'So if you want to place a button on the form, or add some code that
    'overrides certain things (such as maximum height), you want to change
    'the values in the following text boxes.
    'Txt_Lowest       (Lowest height)
    'Txt_Highest      (Highest height)
    'Txt_Water        (Water level)
    'Txt_Width        (The number of "tiles" across (one less than the number of nodes))
    'Txt_Height       (The number of "tiles" "up"     "    "    " etc
    'Txt_WorldWidth   (The size of the world across)
    'Txt_WorldHeight  (The size of the world up)
    'Txt_Spiky        (this value cannot be set by the user (I wasn't sure about
    '                this).  It's the amount each point can be moved up and
    '                down (sort of).  The distance that can be moved is a
    '                factor of the distance between the two points it's dividing
    '                multiplied by this "spiky" value.  If this "spiky" value
    '                was low, the landscape would be smoother (and uninteresting)
    '                this higher value (default 16) gives it a rougher edge.
    '                If this is set really high you may a) cause an error.
    '                b) get a really spiky landscape (to the point of looking
    '                random(ish))
    'Txt_HillMod      This keeps track of the value selected by clicking on
    '                the circle thing in the middle of the screen.  The Z-height
    '                of the "nodes" it multiplied by this value.  If the world
    '                was very big, but the number of nodes was low, the "slope"
    '                would be very low, this HillMod allows "boosts" the height.
    '
    'There should be enough here for space-cadets to get the hang of things.
    'The more astute will notice that I'm not very good at spelling and using
    'good variable naming conventions, or variable scope and other such "good"
    'programming stuff... well yeah, get over it :)
    '
    'These notes are written with the idea that you do actually have a clue
    'what's sort of going on, or at least capable to working out.  The notes
    'and comments throught out here are to give a helping hand.
    '
    'Quite a lot of the code is actually to do with the interface rather then
    'real "work" code, so this won't be commented so much.
    'Enjoy.
    '
    'Students may want to check some of the working in the code to improve
    'upon it for when you rip it off for that second year fractal landscape
    'genration module.  If you're going to do this... have fun removing all
    'the graphics that I put in there, and putting back all the boring text
    'boxes.
    '
    'Enjoy,
    '      Modesty
    '             xxxx

End Sub

