/*EdQuake v0.50 source code
  (c) Copyright 1996 Scott Mitting
  email:smitting@netusa1.net
  ----------------------------------
  WAD.C  -  WAD2 file routines

  __variables:
  wad_t      wad             -- pointer to wad directory
  wadentry_t wadentry  	     -- pointer to wad entry
  __functions:
  void getwadentry(int e)               -- gets an entry
  void openwad(int e)			-- opens wad from pak file
  int selectwadentry()			-- selects a wad entry
  void showwadmenu(int showE, int curE) -- low level function
  void wadexport(int e, char*filename)  -- save wad entry to disk
  ----------------------------------
  the entire source code is under renovation to make it easier
  to understand.  happy coding.
*/

#include <stdio.h>
#include <string.h>
#include "wad.h"
#include "pak.h"
#include "svgacc.h"
#include "grfx.h"
#include "disk.h"
#include "input.h"

wad_t      wad;
wadentry_t wadentry;

void openwad(int e)
{
   char buf;
   int t = -1;
   getentry(e);
   fseek(pak.p,pakentry.loc,0);
   wad.startloc = pakentry.loc;
   if (fgetc(pak.p) != 'W') t = 0;
   if (fgetc(pak.p) != 'A') t = 0;
   if (fgetc(pak.p) != 'D') t = 0;
   if (fgetc(pak.p) != '2') t = 0;
   if (!t)
   {
      wad.startloc = 0;
      return;
   }
   wad.tablelen = fgetl(pak.p);
   wad.tableloc = wad.startloc + fgetl(pak.p);
}

//currently no support for compression
void getwadentry(int e)
{
   int t;
   fseek(pak.p, wad.tableloc + (e * 32), 0);
   wadentry.loc = wad.startloc + fgetl(pak.p);
   wadentry.len = fgetl(pak.p);
   wadentry.dsize = fgetl(pak.p);
   wadentry.type = fgetc(pak.p);
   wadentry.compression = fgetc(pak.p);
   fgeti(pak.p);  //not used
   for (t = 0; t < 16; t++) wadentry.name[t] = fgetc(pak.p);
}

void showwadmenu(int showE, int curE)
{
   int t,qt;
   char buf[80];
   qt = 40;
   mousehide();
   for (t = 0; t < 19; t++)
   {
     getwadentry(t + showE);
     if (t != curE)
     {
	drwfillbox(SET, BLACK,6,qt,300,qt+14);
	sprintf(buf, "%s",       wadentry.name);
	drwstring(SET, WHITE,BLACK,buf,11,qt);
     }
     else
     {
	drwfillbox(SET,RED,6,qt,300,qt+14);
	sprintf(buf, "%s",       wadentry.name);
	drwstring(SET, YELLOW,RED,buf,11,qt);
     }
     qt+=14;
   }
   mouseshow();
}

void wadexport(int e, char*filename)
{
   FILE *out;
   long byte;
   int  t;

   getwadentry(e);
   out = fopen(filename, "wb");
   if (!out) return;
   fseek(pak.p, wadentry.loc, 0);
   for (byte = 1; byte <= wadentry.len; byte++)
       fputc(fgetc(pak.p),out);
   fclose(out);
}

int selectwadentry(int def)
{
   int k;
   int curE = 0, showE = def;
   int mx, my, mbuts;
   button_t up, down, xbutton;
   mousehide();
   xbutton = inputbox(0,20,320,312,"Select WAD Entry");
   up = scrollbutton(302,280,"");
   down = scrollbutton(302,294,"");
   mouseshow();
   if (showE + 18 > wad.tablelen) {showE = wad.tablelen - 18; curE=18;}
   while (k != 27)
   {
     showwadmenu(showE, curE);
     scrollbar(302,40,278,showE+curE,wad.tablelen);
	    while (!kbhit() && !mbuts)
	    {
	       mousestatus(&mx,&my,&mbuts);
	       if (mbuts & 1)//scroll
	       {
		  if (hitbutton(mx,my,up)) showE-=1;
		  if (hitbutton(mx,my,down)) showE+=1;
		  if (hitbutton(mx,my,xbutton)) return -1;
		  //select
		  if (mx < 300 && my < 300 && my > 40)
		     curE =  ((my - 40) / 14)+1;
	       }
	       if (mbuts & 2)//scroll fast
	       {
		  if (hitbutton(mx,my,up)) showE-=3;
		  if (hitbutton(mx,my,down)) showE+=3;
		  if (mx < 300 && my < 300 && my > 40) return showE+curE;
	       }

	    }
	    if (!mbuts) k = getkey();
	    mbuts = 0;

     if (k == a_DOWN) curE++;
     if (k == a_UP)   curE--;
     if (k == a_PGDN) showE+=15;
     if (k == a_PGUP) showE-=15;
     if (k == a_HOME) curE=1;
     if (k == a_END)  curE=19;
     if (k == a_ENTER) return showE+curE;
     if (k == a_ESC)   return -1;
     if (curE > 18) {showE++;curE=18;}
     if (curE < 0)  {showE--;curE=0;}
     if (showE < 0) {showE = 0; curE = 0;}
     if (showE + 18 > wad.tablelen) {showE = wad.tablelen - 18; curE=18;}
   }
   return -1;
}

int findwad(char *filename)
{
   int t;
   if (wad.tablelen == 0) return -1;
   for (t = 0; t < wad.tablelen; t++)
   {
      getwadentry(t);
      if (strcmpi(filename, wadentry.name) == 0) t += 1000;
   }
   if (t < 1000) return -1;
   t-=1001;
   return t;
}