/*EdQuake v0.50 source code
  (c) Copyright 1996 Scott Mitting
  email:smitting@netusa1.net
  ----------------------------------
  VIEWER.C  -  Texture and console viewing routines

  __variables:

  __functions:
  void viewwad(int e)            -- WAD2 graphic viewer /w scaling
  void gfxwad()			 -- Select wad file
  void showlmp(int x, int y, int e)
				 -- shows lmp file

  ----------------------------------
  the entire source code is under renovation to make it easier
  to understand.  happy coding.
*/

#include <alloc.h>
#include <stdio.h>
#include "viewer.h"
#include "svgacc.h"
#include "wad.h"
#include "pak.h"
#include "input.h"
#include "grfx.h"
#include "ripper.h"

void viewwad(int e)
{
    int cntx, cnty;
    int cx, cy, k = 0;
    int i;
    int size = 100;
    pict gfxblk;
    if (e < 0) return;
    mousehide();
    getwadentry(e);
    fseek(pak.p, wadentry.loc, 0);
    gfxblk.xsize = fgetl(pak.p);
    gfxblk.ysize = fgetl(pak.p);
    fillscreen(0);
    i = (gfxblk.xsize+1)*(gfxblk.ysize+1)+4;
    if (!(gfxblk.data = malloc(i))) return;
    for (cy = 0; cy < gfxblk.ysize; cy++)
      for (cx = 0; cx < gfxblk.xsize; cx++)
	gfxblk.data[(cy * gfxblk.xsize) + cx] = fgetc(pak.p);

    fillscreen(0);
    drwstring(SET,7,0,"arrows - move   a/z - zoom in/out   s - save",10,0);

    cntx = 320;
    cnty = 240;

   while (k != 27)
   {
     scalepict(cntx, cnty, size, gfxblk);
     k = getkey();
     drwfillbox(SET,0,cntx,cnty,800, 600);
     if (k == a_DOWN)  cnty += 40;
     if (k == a_UP)    cnty -= 40;
     if (k == a_LEFT)  cntx -= 40;
     if (k == a_RIGHT) cntx += 40;
     if (k == 'a' || k == 'A')  size +=25;
     if (k == 'z' || k == 'Z')  size -=25;
     if (k == 's' || k == 'S')
     {
	k = 27;
	savewadentry(e);
     }
     if (cntx > 800)   cntx = 800;
     if (cntx < 1)     cntx = 1;
     if (cnty > 600)   cnty = 600;
     if (cnty < 50)     cnty = 50;
    }
    fillscreen(0);
    free(gfxblk.data);
    mouseshow();
}

void gfxwad()
{
      int t, t2;
      t = findfile("gfx.wad");
      if (t > 0)
      {
	 mousehide();
	 openwad(t);
	 drwfillbox(SET,BLACK,0,0,800,640);
	 t2 = 0;
	 mouseshow();
	 while (t2 > -1)
	 {
	   t2 = selectwadentry(t2);
	   if (t2 > -1) viewlmp(t2);
	 }
      }
}

void viewlmp(int e)
{
    int xsize, ysize;
    int cx, cy, k;
    if (e < 0) return;
    mousehide();
    drwfillbox(SET,BLACK,0,0,800,640);
    getentry(e);
    fseek(pak.p, pakentry.loc, 0);
    if ((xsize = fgetl(pak.p)) < 1) return;
    if ((ysize = fgetl(pak.p)) < 1) return;
    fillscreen(0);
    for (cy = 0; cy < ysize; cy++)
     for (cx = 0; cx < xsize; cx++)
      drwfillbox(SET,fgetc(pak.p),(cx*2),(cy*3),(cx*2)+1,(cy*3)+2);
    drwstring(SET,15,0,"esc - leave",640,0);
    drwstring(SET,15,0,"  s - save",640,15);

   while (k != 27)
   {
     k = getkey();
     if (k == 's' || k == 'S') saveentry(e);
   }
   mouseshow();
}

void lmp()
{
	 int t2;
	 mousehide();
	 t2 = 0;
	 mouseshow();
	 while (t2 > -1)
	 {
	   if (kbhit()) getch(); //clear keyboard
	   t2 = selectentrykeyword(0, "lmp");
	   getentry(t2);
	   if (t2 > -1) viewlmp(t2);
	 }
}

void showlmp(int x, int y, int e)
{
    int xsize, ysize;
    int cx, cy, k;
    if (e < 0) return;
    mousehide();
    getentry(e);
    fseek(pak.p, pakentry.loc, 0);
    if ((xsize = fgetl(pak.p)) < 1) return;
    if ((ysize = fgetl(pak.p)) < 1) return;
    for (cy = 0; cy < ysize; cy++)
     for (cx = 0; cx < xsize; cx++)
       drwpoint(SET,k,cx+x,cy+y);
    mouseshow();
}
