/*EdQuake v0.50 source code
  (c) Copyright 1996 Scott Mitting
  email:smitting@netusa1.net
  ----------------------------------
  GRFX.C  -  Functions to assist the SVGACC library
  note: this file is in it's early stages, many new functions
	will be appearing

  __variables:
  int RED   		    -- these are colors for the menu
  int DKGRAY		       commands so that you can use
  int LTGRAY		       different palettes and still
  int WHITE		       use high-level routines. There
  int BLUE		       may be an automatic adjuster
  int BLACK		       in the future
  int YELLOW
  __functions:
  void fixpal(PaletteData tpal)  -- adjusts 24-bit palette to
				    16-bit for VGA pallette routines
  void impress(int x0, int y0, int x1, int y1)
				 -- makes an impression is greys
  void loadpcx(int x, int y, char *filename)
				 -- loads a PCX file to screen at (x,y)
  void showwadfile(int x, int y, int e)
				 -- shows a console graphic from a wad
  void scalepict(int x, int y, int xsize, int ysize, pict image)
				 -- draws a scaled picture
  void statusbar(int x0, int y0, int x1, int y1, long t1, long t2)
				 -- draws a bar for percent of completion
  ----------------------------------
  the entire source code is under renovation to make it easier
  to understand.  happy coding.
*/

#include "svgacc.h"
#include "pak.h"
#include "wad.h"
#include "grfx.h"

int RED;
int DKGRAY;
int LTGRAY;
int WHITE;
int BLUE;
int BLACK;
int YELLOW;

void fixpal(PaletteData tpal)
{
	int i, fixit;
	fixit = 0;
	for(i=0;i<255;i++)
	    if((tpal[i].r>63) || (tpal[i].g>63) || (tpal[i].b>63))
		fixit = 1;
	if (fixit)
	    for(i=0;i<255;i++) {
		tpal[i].r>>=2;
		tpal[i].g>>=2;
		tpal[i].b>>=2;
	    }
}

void loadpcx(int x, int y, char *filename)
{
   PaletteData pcxpal;
   int null;
   if (pcxgetinfo(filename,&null,&null,&null,pcxpal))
   {
	fixpal(pcxpal);
	palset(pcxpal,0,255);
	pcxput(SET,x,y,filename);
   }
}

void showwadfile(int x, int y, int e)
{
   int xsize, ysize;
   int cx, cy;
   if (e < 0) return;
   getwadentry(e);
   fseek(pak.p, wadentry.loc, 0);
   xsize = fgetl(pak.p);
   ysize = fgetl(pak.p);
   for (cy = 0; cy < ysize; cy++)
     for (cx = 0; cx < xsize; cx++)
       drwpoint(SET,fgetc(pak.p),x+cx,y+cy);
}

//takes less memory than SVGACC's
void scalepict(int x, int y, int scale, pict image)
{
   int cx, cy;
   float curx, cury;
   float incx, incy;
   float xsize = image.xsize * ((float)scale / 100);
   float ysize = image.ysize * ((float)scale / 100);
   curx = cury = 0;
   incx = (float)image.xsize / xsize;
   incy = (float)image.ysize / ysize;
   for (cy = 0; cy < ysize; cy++)
   {
      for (cx = 0; cx < xsize; cx++)
      {
	 drwpoint(SET,image.data[(image.xsize*(int)cury)+(int)curx],cx+x,cy+y);
	 curx+=incx;
      }
      cury+=incy;
      curx=0;
   }
}

void impress(int x0, int y0, int x1, int y1)
{
   int cx, cy;
   drwline(SET, DKGRAY, x0, y0, x1, y0);
   drwline(SET, DKGRAY, x0-1, y0-1, x1+1, y0-1);
   drwline(SET, DKGRAY, x0, y0, x0, y1);
   drwline(SET, DKGRAY, x0-1, y0-1, x0-1, y1+1);
   drwline(SET, WHITE, x1, y1, x1, y0);
   drwline(SET, WHITE, x1+1, y1+1, x1+1, y0-1);
   drwline(SET, WHITE, x1, y1, x0, y1);
   drwline(SET, WHITE, x1+1, y1+1, x0-1, y1+1);
}

void statusbar(int x0, int y0, int x1, int y1, long t1, long t2)
{
   int curx;
   if (t2 != 0) curx = (x1-x0)*((float)t1/t2);
     else curx = x1;
   drwfillbox(SET, BLACK, x0+curx+1, y0, x1, y1);
   drwfillbox(SET, RED, x0, y0, x0+curx, y1);
}