/*EdQuake v0.50 source code
  (c) Copyright 1996 Scott Mitting
  email:smitting@netusa1.net
  ----------------------------------
  EDQUAKE.C  -  Main control/init functions

  __variables:
  MouseCursor mymousecursor -- mouse pointer used in EdQuake
  extern int startvideomode -- video mode upon init

  __functions:
  extern void initcpu()     -- inits the SVGACC library used by
			       EdQuake (buy it, it's worth it)
  int main()		    -- main code/loop
  void selectpakfile()      -- asks user input for the .pak file
  void setnormcolors()      -- sets up colors for menu boxes in
			       the default SVGA palette
  ----------------------------------
*/

#include <stdio.h>
#include <malloc.h>
#include <dos.h>
#include <stdlib.h>
#include <string.h>
#include "pak.h"
#include "wad.h"
#include "input.h"
#include "ripper.h"
#include "svgacc.h"
#include "grfx.h"
#include "mapedit.h"
#include "viewer.h"
#include "intpak.h"
#include "disk.h"

MouseCursor mymousecursor = {
    {2},{2},
    {255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
     255,  0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
     255,  0,  0,255,255,255,255,255,255,255,255,255,255,255,255,255,
     255,  0, 15,  0,255,255,255,255,255,255,255,255,255,255,255,255,
     255,  0, 15, 15,  0,255,255,255,255,255,255,255,255,255,255,255,
     255,  0, 15, 15, 15,  0,255,255,255,255,255,255,255,255,255,255,
     255,  0, 15, 15, 15, 15,  0,255,255,255,255,255,255,255,255,255,
     255,  0, 15, 15, 15, 15, 15,  0,255,255,255,255,255,255,255,255,
     255,  0, 15, 15, 15, 15, 15, 15,  0,255,255,255,255,255,255,255,
     255,  0, 15, 15, 15, 15, 15, 15, 15,  0,255,255,255,255,255,255,
     255,  0, 15, 15, 15, 15, 15, 15, 15, 15,  0,255,255,255,255,255,
     255,  0, 15, 15, 15, 15, 15, 15, 15, 15, 15,  0,255,255,255,255,
     255,  0, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,  0,255,255,255,
     255,  0, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,  0,255,255,
     255,  0, 15, 15, 15,  0, 15, 15, 15,  0,  0,  0,  0,  0,  0,255,
     255,  0, 15, 15,  0,  0, 15, 15, 15,  0,255,255,255,255,255,255,
     255,  0, 15,  0,255,255,  0, 15, 15, 15,  0,255,255,255,255,255,
     255,  0,  0,255,255,255,  0, 15, 15, 15,  0,255,255,255,255,255,
     255,  0,255,255,255,255,255,  0, 15, 15, 15,  0,255,255,255,255,
     255,255,255,255,255,255,255,  0, 15, 15, 15,  0,255,255,255,255,
     255,255,255,255,255,255,255,255,  0, 15, 15, 15,  0,255,255,255,
     255,255,255,255,255,255,255,255,  0, 15, 15, 15,  0,255,255,255,
     255,255,255,255,255,255,255,255,255,  0,  0,  0,255,255,255,255,
     255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}
};

extern int startvideomode;
extern void initcpu();

void setnormcolors()
{
    RED    = 4;
    DKGRAY = 8;
    LTGRAY = 7;
    WHITE  = 15;
    BLUE   = 1;
    BLACK  = 0;
    YELLOW = 14;
}

void selectpakfile()
{
   button_t xbutton, ok, cancel;
   char *t;
   xbutton = inputbox(0,0,332,264,"Configurate");
   loadpcx(6,20,"edquake.pcx");
   drwstring(SET, 0,7,".PAK file:",10,225);
   drwfillbox(SET,0,10,240,245,254);
   ok = button(256,223,320,237,"   ok");
   cancel = button(256,243,320,257," cancel");
   mouseshow();
   pakname = wgetstr("c:\\quake\\id1\\pak0.pak",13,240, ok, cancel, xbutton);
   mousehide();
   openpak();
}

int main()
{
   int t;
   initcpu();
   res800();
   mouseenter();
   mousecursorset(&mymousecursor);
   setnormcolors();
   drwfillbox(SET,37,0,0,640,480);
   loadpcx(74,155,"edqlogo.pcx");//492x167
//   loadconfig();  //while you're waiting :)
   delay(2000);
   res800();
   drwfillbox(SET,0,0,0,800,600);
   selectpakfile();
   if (pak.p)
   {
      t = findfile("maps/e1m1.bsp");
      if (t < 1) t = selectentrykeyword(0, "bsp");
      if (t > 0) mapedit(t);
   }
   mouseexit();
   videomodeset(startvideomode);
   saveconfig();
   return 0;
}
