#define u_short  unsigned short int
#define u_char  unsigned char
#define u_long  unsigned long

typedef struct                 // A Directory entry
{ long  offset;                // Offset to entry, in bytes, from start of file
  long  size;                  // Size of entry in file, in bytes
  } dentry_t;

typedef struct                 // The BSP file header
{ long  startloc;
  long  version;               // Model version, must be 0x17 (23).
				 //NOTE:shareware is 0x1c
  dentry_t entities;           // List of Entities.
  dentry_t planes;             // Map Planes.
			       // numplanes = size/sizeof(plane_t)
  dentry_t miptex;             // Wall Textures.
  dentry_t vertices;           // Map Vertices.
			       // numvertices = size/sizeof(vertex_t)
  dentry_t visilist;           // Leaves Visibility lists.
  dentry_t nodes;              // BSP Nodes.
			       // numnodes = size/sizeof(node_t)
  dentry_t surfaces;           // Map Surfaces.
			       // numsurfaces = size/sizeof(surface_t)
  dentry_t lightmaps;          // Wall Light Maps.
  dentry_t boundnodes;         // BSP bound nodes, for Hulls.
			       // numbounds = size/sizeof(hullbound_t)
  dentry_t leaves;             // BSP Leaves.
			       // numlaves = size/sizeof(leaf_t)
  dentry_t lstsurf;            // List of Surfaces.
  dentry_t edges;              // Original surface Edges.
			       // numedges = Size/sizeof(edge_t)
  dentry_t lstedges;           // List of surfaces Edges.
  dentry_t hulls;              // List of Hulls.
			       // numhulls = Size/sizeof(hull_t)
} dheader_t;

typedef float scalar_t;        // Scalar value,

typedef struct                 // Vector or Position
{ scalar_t x;                  // horizontal
  scalar_t y;                  // horizontal
  scalar_t z;                  // vertical
} vec3_t;

typedef struct                 // Bounding Box
{ vec3_t   min;                // minimum values of X,Y,Z
  vec3_t   max;                // maximum values of X,Y,Z
} boundbox_t;

typedef struct
{ boundbox_t bound;            // The bounding box of the Hull
  long zero[3];                // Always 0, purpose unknown
  long node;                   // index of first BSP node
  long boundnode;              // index of first Bound BSP node
  long numleafs;               // number of BSP leaves
  long firstsurface;           // id of Surfaces
  long numsurfaces;            // number of Surfaces
} dhull_t;

typedef struct
{ float X;                    // X,Y,Z coordinates of the vertex
  float Y;                    // usually some integer value
  float Z;                    // but coded in floating point
} vertex_t;

typedef struct
{ u_short startvertex;         // index of the start vertex
			       //  must be in [0,numvertices[
  u_short endvertex;           // index of the start vertex
				//  must be in [0,numvertices[
} edge_t;

typedef struct
{ u_short planenum;            // The plane in which the surface lies
			       //           must be in [0,numplanes[
  u_short side;                // 0 if in front of the plane, 1 if behind the plane
  u_char texnum;               // id of Mip Texture
								  //           must be in [0,numtex[
  u_char sofs;                 // horizontal offset (in texture space)
  u_char tofs;                 // vertical offset (in texture space)
  u_char flips;                // if bit 0==1 flip vertically (in texture space)
		       // if bit 1==1 flip horizontally (in texture space)
			      // if bit 2==1 exchange vertical and horizontal coordinates
  long firstedge;              // first edge in the List of edges
	       //           must be in [0,numedges[
  long numedge;                // number of edges in the List of edges
  u_char typelight;            // type of lighting, for the surface
  u_char baselight;            // from 0xFF (dark) to 0 (bright)
  u_short unknown1;            // 0xFFFF, probably useless (padding)
  long lightmap;               // Pointer inside the general light map, or -1
// this define the start of the surface light map
} surface_t;

typedef struct                 // Mip texture list header
{
  long numtex;                 // Number of textures in Mip Texture list
  long offset[256];         // Offset to each of the individual texture
} mipheader_t;                 //  from the beginning of mipheader_t


typedef struct                 // Mip Texture
{ char name[16];               // Name of the texture.
u_long width;                // width of picture, must be a multiple of 8
u_long height;               // height of picture, must be a multiple of 8
u_long offset1;              // offset to u_char Pix[width   * height]
u_long offset2;              // offset to u_char Pix[width/2 * height/2]
u_long offset4;              // offset to u_char Pix[width/4 * height/4]
u_long offset8;              // offset to u_char Pix[width/8 * height/8]
long  pakoffset;             //internal use
} miptex_t;

extern dheader_t bsp;
extern miptex_t  texture[256];
extern long numtex;

#include <stdio.h>

void reportbsp();
void loadbsp(int e);
int gettexture();
void showtexture(int e);
dentry_t fgetd(FILE *p);