#include "bsp.h"
#include "pak.h"
#include "disk.h"
#include "svgacc.h"

dheader_t bsp;
miptex_t  texture[256];
long numtex;

dentry_t fgetd(FILE *p)
{
   dentry_t t;
   t.offset = fgetl(p);
   t.size = fgetl(p);
   return t;
}

/*void reportbsp() //good for debugging (this routine needs debugged)  :)
{
   printf("BSP file data");
   printf("bsp version: %i\n", bsp.version);
   printf("entities  (%u) bytes @ %u\n", bsp.entities.size, bsp.entities.offset);
   printf("planes    (%u) bytes @ %u\n", bsp.planes.size, bsp.planes.offset);
   printf("miptex    (%u) bytes @ %u\n", bsp.miptex.size, bsp.miptex.offset);
   printf("vertices  (%u) bytes @ %u\n", bsp.vertices.size, bsp.vertices.offset);
   printf("visilist  (%u) bytes @ %u\n", bsp.visilist.size, bsp.visilist.offset);
   printf("nodes     (%u) bytes @ %u\n", bsp.nodes.size, bsp.nodes.offset);
   printf("surfaces  (%u) bytes @ %u\n", bsp.surfaces.size, bsp.surfaces.offset);
   printf("lightmaps (%u) bytes @ %u\n", bsp.lightmaps.size, bsp.lightmaps.offset);
   printf("boundnodes(%u) bytes @ %u\n", bsp.boundnodes.size, bsp.boundnodes.offset);
   printf("leaves    (%u) bytes @ %u\n", bsp.leaves.size, bsp.leaves.offset);
   printf("lstedges  (%u) bytes @ %u\n", bsp.lstedges.size, bsp.lstedges.offset);
   printf("hulls     (%u) bytes @ %u\n", bsp.hulls.size, bsp.hulls.offset);
} */

void loadbsp(int e)
{
  getentry(e);
  fseek(pak.p,pakentry.loc,0);
  bsp.startloc = pakentry.loc;
  bsp.version = fgetl(pak.p);            // Model version, must be 0x17 (23).
					 //NOTE:shareware is 0x1c
  bsp.entities = fgetd(pak.p);           // List of Entities.
  bsp.planes = fgetd(pak.p);             // Map Planes.
					 // numplanes = size/sizeof(plane_t)
  bsp.miptex = fgetd(pak.p);             // Wall Textures.

  bsp.vertices = fgetd(pak.p);           // Map Vertices.
			       // numvertices = size/sizeof(vertex_t)
  bsp.visilist = fgetd(pak.p);           // Leaves Visibility lists.
  bsp.nodes = fgetd(pak.p);              // BSP Nodes.
					       // numnodes = size/sizeof(node_t)
  bsp.surfaces = fgetd(pak.p);           // Map Surfaces.
			       // numsurfaces = size/sizeof(surface_t)
  bsp.lightmaps = fgetd(pak.p);          // Wall Light Maps.
  bsp.boundnodes = fgetd(pak.p);         // BSP bound nodes, for Hulls.
			       // numbounds = size/sizeof(hullbound_t)
  bsp.leaves = fgetd(pak.p);             // BSP Leaves.
			       // numlaves = size/sizeof(leaf_t)
  bsp.lstsurf = fgetd(pak.p);            // List of Surfaces.
  bsp.edges = fgetd(pak.p);              // Original surface Edges.
			       // numedges = Size/sizeof(edge_t)
  bsp.lstedges = fgetd(pak.p);           // List of surfaces Edges.
  bsp.hulls = fgetd(pak.p);              // List of Hulls.
			       // numhulls = Size/sizeof(hull_t)
}

int gettexture()
{
   long offset;
   int t, x;
   int cx, cy;
   fseek(pak.p, bsp.miptex.offset + bsp.startloc, 0);
   numtex = fgetl(pak.p);
   for (x = 0; x < numtex; x++)
   {
   fseek(pak.p, bsp.miptex.offset + bsp.startloc + ((x+1) * 4), 0);
   offset = fgetl(pak.p);
   fseek(pak.p, bsp.miptex.offset + bsp.startloc + offset, 0);
   for (t = 0; t < 16; t++) texture[x].name[t] = fgetc(pak.p);
   texture[x].width = fgetl(pak.p);
   texture[x].height = fgetl(pak.p);
   texture[x].offset1 = fgetl(pak.p);
   texture[x].offset2 = fgetl(pak.p);
   texture[x].offset4 = fgetl(pak.p);
   texture[x].offset8 = fgetl(pak.p);
   fseek(pak.p, texture[x].offset1 - 40, 1);
   texture[x].pakoffset = ftell(pak.p);
   }
   return numtex;
}

void showtexture(int e)
{
  int x, y, maxx, maxy, t, skipx;
  fseek(pak.p, texture[e].pakoffset, 0);
  if ((maxx = texture[e].width)  > 128) maxx = 128;
  if ((maxy = texture[e].height) > 128) maxy = 128;
  skipx = maxx - 128;
  for (y = 0; y < maxy; y++)
  {
    for (x = 0; x < texture[e].width; x++)
      drwpoint(SET,fgetc(pak.p),672+x,y+120);
    for (t = 0; t < skipx; t++) fgetc(pak.p);
  }
}

