
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <conio.h>
#include "curs.h"
/* MORITZ BUNKUS begin */
#include <os2.h>
/* MORITZ BUNKUS end   */

/*
 *  General-purpose cursor control routines for QBSP, VIS, and LIGHT.
 *  These are used so that cursor control can be done compatibly
 *  with other architectures (namely UNIX).  This version implements
 *  cursor control with CONIO.H (available with Turbo C and with DJGPP).
 */

int backtable[8] = { 0, 4, 2, 6, 1, 5, 3, 7 };
int foretable[8] = { 0, 12, 10, 14, 9, 13, 11, 15 };

struct vidbuf {
	int x, y, width, height;
	void *memory;
};       

int ScrnWidth, ScrnHeight;

#define gotoxy(a, b) v_gotoxy((a)-1, (b)-1)

void InitText(void)
{

	v_init();
	v_hidecursor();
	v_clear();
	v_gotoxy(0, 0);
/*
	textmode(3);			/ Reset to normal text mode /
	_setcursortype(_NOCURSOR); / Hide the cursor /
	clrscr();			/ Clear the screen /
	gotoxy(1, 1);			/ Home the cursor / */

	ScrnWidth = 80;
	ScrnHeight = 24;		/* If it were 25, it would scroll, damn it. */
}

void MoveCurs(int x, int y)
{
	gotoxy(x+1, y+1);	/* X and Y are zero-based */
}

void GetCurs(int *x, int *y)
{
	v_getxy(x, y);
/*	*x = wherex() - 1;	/ X and Y are zero-based /
	*y = wherey() - 1; */
}

void SetForeColor(int color)
{
	if (color > 7 || color < 0) color = 7;
	v_attrib((v_getattr() & 0xF0) | foretable[color]);
/*	textcolor(foretable[color]);*/
}

void SetBackColor(int color)
{
	if (color > 7 || color < 0) color = 7;
/*	backgroundcolor(backtable[color]);*/
	v_attrib((v_getattr() & 0x0F) | (backtable[color] << 4));
}

void CPrintf(char *format, ...)
{
	register char c;
	register char *ptr, *src;
        int x, y;
        char text[1024];
	char text2[1024];
        va_list v;

	va_start(v, format);
	vsprintf(text, format, v);

	GetCurs(&x, &y);

	for (ptr = text2, src = text; *src != '\0'; src++) {
		c = *src;

		if (c == '$') {
			switch (*++src) {
			case '$':
				*ptr++ = '$';
                                break;
                        case 'a':
				*ptr = '\0';
				v_puts(ptr = text2);
                                RingBell();
                                break;
                        case 'n':
				*ptr = '\0';
				v_puts(ptr = text2);
                                MoveCurs(x, ++y);
                                break;
			case 'f':
				*ptr = '\0';
				v_puts(ptr = text2);
				SetForeColor(toupper(*++src)-'0');
				break;
			case 'b':
				*ptr = '\0';
				v_puts(ptr = text2);
				SetBackColor(toupper(*++src)-'0');
				break;
			case 'c':
				*ptr = '\0';
				v_puts(ptr = text2);
				SetForeColor(toupper(*++src)-'0');
				SetBackColor(toupper(*++src)-'0');
				break;
                        }
                }
		else if (c >= 32 && c <= 126)
			*ptr++ = c;
	}
	*ptr = '\0';
	v_puts(ptr = text2);
}

void RingBell(void)
{
	v_putc('\a');
}

void FillBox(int x, int y, int width, int height, char c)
{
	register int i;
	char boxdata[256];

	for (i = 0; i < width; i++)
		boxdata[i] = c;
	boxdata[i] = '\0';

	for (i = 0; i < height; i++) {
		gotoxy(x+1, i+1+y);
		v_puts(boxdata);
        }
}

void DrawBox(int x, int y, int width, int height)
{
	register int i;

        gotoxy(x+1, y+1);
	v_puts("");
	for (i = 0; i < width - 2; i++)
		v_puts("");
	v_puts("");

	for (i = 1; i < height-1; i++) {
		gotoxy(x+1, i+1+y);
		v_puts("");
		gotoxy(x+width, i+1+y);
		v_puts("");
        }

	gotoxy(x+1, y+height);
	v_puts("");
	for (i = 0; i < width - 2; i++)
		v_puts("");
	v_puts("");
}

void DrawFilledBox(int x, int y, int width, int height)
{
	register int i;
        char boxdata[256];

	for (i = 0; i < width; i++)
		boxdata[i] = ' ';
	boxdata[0] = '';
	boxdata[i-1] = '';
        boxdata[i] = '\0';

        gotoxy(x+1, y+1);
	v_puts("");
	for (i = 0; i < width - 2; i++)
		v_puts("");
	v_puts("");

	for (i = 1; i < height-1; i++) {
		gotoxy(x+1, i+1+y);
		v_puts(boxdata);
        }

	gotoxy(x+1, y+height);
	v_puts("");
	for (i = 0; i < width - 2; i++)
		v_puts("");
	v_puts("");
}

void DrawHLine(int x, int y, int length)
{
	register int i;

	gotoxy(x+1, y+1);
	for (i = 0; i < length; i++)
		v_puts("");
}

void DrawVLine(int x, int y, int length)
{
	register int i;

	for (i = 0; i < length; i++) {
		gotoxy(x+1, i+1+y);
		v_puts("");
	}
}

void CopyText(int x1, int y1, int width, int height, int x2, int y2)
{
	char *mem = malloc(width*height*2), *ptr;
	int i;

  ptr=mem;
	for (i=1; i<=height; i++, ptr+=(width*2))
		v_getline(ptr, x1-1, y1-2+i, width);
	ptr=mem;
	for (i=1; i<=height; i++, ptr+=(width*2))
		v_putline(ptr, x2-1, y2-2+i, width);
/*	gettext(x1-1, y1-1, x1+width, y1+height, mem);
	puttext(x2-1, y2-1, x2+width, y2+height, mem);*/
}

int IsKey(void)
{
/*	return(kbhit());*/
  return feof(stdin);
}

int WaitKey(void)
{
	return(getch());
}

int GetKey(void)
{
	int c=getc(stdin);
	if (c != EOF)
	  return c;
	else
	  return 0;
/*	if (kbhit()) return(getch());
	else return(0);*/
}

void HideCurs(void)
{
	v_hidecursor();
}

void ShowCurs(void)
{
	v_ctype(0, 2);
}

