#include "scripts.h"

word parse_script ( byte *input, script *list ) {
dword line;
word line_count;
word index;
byte inwhite;
dword pos;
byte ch;

 line = 1;
 line_count = 0;
 index = 0;
 pos = 0;
 inwhite = 0;
 list->item_num = 0;
 list->item_ptr = 0;

while ( input[pos] ) {
 ch = input[pos];
 //printf("checking character %c\n",ch);
 

 if (  ch == '/' ) {
   byte next;

   next = input[pos+1];
   if ( next != '/' ) {
     break; // nothing to worry about
   }
   do {
     pos++;
     ch = input[pos];
   } while ( ch != 13 ); // to the end of the line

   if ( !line_count  ) {
       pos++; // advance past cr, no string to end... let LF handler get it
       ch = input[pos];
   }

   // now let the CR/LF handler deal with it
 } // end if

 if ( ( ch == ' ' ) ||
      ( ch == '\t') ) {
  // printf("character is whitespace\n");
   if ( !inwhite && line_count ) {       //must end object

     if ( line_count == 1 )
        list->item_ptr[list->item_num-1].filename[index] = 0; // terminate
     else
        list->item_ptr[list->item_num-1].wadname[index] = 0;
     index++; // shouldn't matter
   
   } // end if
   inwhite = 1;
   pos++;
   continue; // skip other junk
 } // end if
 

 if ( ch == 13 ) {
  // printf("char is CR\n");
   if ( line_count == 1 ) {
      printf("line %lu of script is incomplete!\n",line);
      exit(1);
   }
  
   list->item_ptr[list->item_num-1].wadname[index] = 0;
   index++; // shouldn't matter

   line_count = 0; // reset
   pos++;
   continue;
 } // end if

 if ( ch == 10 ) {
  // printf("char is LF\n");
   line++;
   pos++;
   continue;
 } // end if

  // no whitespace
 if ( !line_count ) { // no items on this new line
   //printf("new line\n");
   // allocate new list item
   list->item_num++;
   list->item_ptr = ( script_item * )
     realloc ( list->item_ptr, sizeof(script_item)*list->item_num );
   if ( !list->item_ptr ) {
      printf("failed to allocate memory for script item\n");
      exit(1);
   }
   inwhite = 1; // trigger line item add below
 } // end if

 if ( inwhite ) { //just came from whitespace or on new line ( set above )
   //printf("new word on line\n");
   line_count++; // line item here
   if ( line_count > 2 ) {
      printf("too many items on line %lu of script\n",line);
      exit(1);
   }
   index = 0; // index into this new line item
 } // end if


 if ( line_count == 1 )      // filename
    list->item_ptr[list->item_num-1].filename[index] = ch;
 else
    list->item_ptr[list->item_num-1].wadname[index] = ch;
 index++;
 pos++;
 inwhite = 0;
} // end while
return 0; }



word load_script ( byte *filename, byte **input ) {
FILE *fp;
dword fsize;

fp = fopen ( filename, "rb");
if ( !fp ) {
   printf("unable to open scriptfile \"%s\"\n",filename);
   exit(1);
}
fseek(fp,0,SEEK_END);
fsize = ftell(fp);
fseek(fp,0,SEEK_SET);
printf("script file is %lu bytes long\n",fsize);

*input = ( byte * ) malloc ( fsize+1 ); // allocate one extra for null
fread(*input,1,fsize,fp);
(*input)[fsize] = 0; // last null (eof in mem)
return 0; }










