#include "pcx2wad.h"

word is_palette ( byte *wadname ) {
dword count;
byte pstring[] = "palette";
 count = 0;
 while ( pstring[count] ) {
  if ( (wadname[count] & 0xDF) != (pstring[count] & 0xDF) ) 
     return 0;
 count++;
 } // end while
return 1; }



dword write_palette ( FILE *wad, byte *filename ) {
FILE *fp;
dword location;
byte pal[768];
location = ftell(wad);

fp = fopen ( filename, "rb" );
if ( !fp ) {
   printf("unable to open palette %s\n",filename);
   exit(1);
}
fread(pal,1,768,fp);
fclose(fp);
if ( fwrite(pal,1,768,wad) != 768 ) {
   printf("error writing palette\n");
   exit(1);
}
return location; }





 #define PCX 1
 #define BMP 2
 #define LBM 3
 #define PAL 4

word det_file_type ( byte *filename ) {
dword id;
  // checks to see if image is ver 5 pcx or BMP file
FILE *fp;
fp = fopen ( filename, "rb" );
if ( !fp ) {
   printf("could not open file \"%s\"\n",filename);
   exit(1);
}
fread(&id,4,1,fp);
fclose(fp);

if ( id == ((dword)('M'<<24)+('R'<<16)+('O'<<8)+('F')) )
   return LBM;
if ( *((word *)&id) == ((word)(('M'<<8)+('B'))) )  // first two bytes only
   return BMP;
if ( *((word *)&id) == ((word)((5<<8)+(10))) )    // first two only
   return PCX;   
return 0; } // else unrecognizeable



int main (word argc, byte **argv) {
word type;
FILE *wad;
word counter;
byte *filelist;
script list;          // contains filenames/wadnames
mip_texture buffer;   //allocated by pcxread
dword location;
dword size;
wad_entry *dir;

if ( argc < 3 ) {
    printf("usage: pcx2wad <scriptfile> <targetwad> \n");
    return 1;
}
wad = fopen ( argv[2],"wb");
if ( !wad ) {                                   
   printf("could not open wadfile \"%s\"\n",argv[2]);
   return 1;
}

load_script ( argv[1], &filelist );
parse_script ( filelist, &list );
printf("%u files to be added to wad\n",list.item_num );

// allocate wad directory
dir = ( wad_entry * ) malloc ( list.item_num*sizeof(wad_entry) );
if ( !dir ) {
   printf("unable to allocate directory mem\n");
   exit(1);
}

write_wad_header ( &wad, list.item_num );

for ( counter=0; counter<list.item_num; counter++ ) {

 if ( is_palette ( list.item_ptr[counter].wadname ) ) {
    printf("found palette!\n");
    location = write_palette ( wad, list.item_ptr[counter].filename );
    printf("pal location: %lu\n",location);
    size = 768;

   dir[counter].offset = location;
   dir[counter].wadsize = size;
   dir[counter].memsize = size;
   dir[counter].type = 0x40;       // palette
   dir[counter].compressed = 0x00; // nope
   memcpy(dir[counter].name,list.item_ptr[counter].wadname,16);

   continue;
 } // end if
 

 type = det_file_type ( list.item_ptr[counter].filename );
 if ( !type ) {
  printf("unrecognized file format in %s\n",list.item_ptr[counter].filename);
  exit(1);
 }
 if ( type == PCX )
     read_pcx ( list.item_ptr[counter].filename, &buffer.img[0] );
 if ( type == BMP )
     read_bmp ( list.item_ptr[counter].filename, &buffer.img[0] );
 if ( type == LBM )
     read_lbm ( list.item_ptr[counter].filename, &buffer.img[0] );
 if ( type == PAL ) {
     //add_pal ( list.item_ptr[counter].filename );
     // add dir info here
     continue;
 }

 make_mip ( &buffer );
 location = write_mip_map ( &wad, &buffer, list.item_ptr[counter].wadname );
 size = ( buffer.img[0].width * buffer.img[0].height ) +
        ( buffer.img[1].width * buffer.img[1].height ) +
        ( buffer.img[2].width * buffer.img[2].height ) +
        ( buffer.img[3].width * buffer.img[3].height ) + 40; //header

 dir[counter].offset = location;
 dir[counter].wadsize = size;
 dir[counter].memsize = size;
 dir[counter].type = 0x44;       // mip entry
 dir[counter].compressed = 0x00; // nope
 memcpy(dir[counter].name,list.item_ptr[counter].wadname,16);
   
 //disp_raw ( &buffer.img[0] );
 //disp_raw ( &buffer.img[1] );
 //disp_raw ( &buffer.img[2] );
 //disp_raw ( &buffer.img[3] );
   free(buffer.img[0].data);
   free(buffer.img[1].data);
   free(buffer.img[2].data);
   free(buffer.img[3].data);
   free(buffer.img[0].palette);
} // end counter

 printf("wad directory: \n");
for ( counter=0; counter<list.item_num; counter++ ) {
 printf("name: %s\n",dir[counter].name );
 printf("     offset: %lu\n",dir[counter].offset );
 printf("     wadsize: %lu\n",dir[counter].wadsize );
 printf("     memsize: %lu\n",dir[counter].memsize );
 printf("     type: %02X\n",dir[counter].type );
 printf("     compressed: %02X\n",dir[counter].compressed );
} // end counter

location = ftell(wad); // location of directory (to save at beginning of file)
printf("location in hex: %lX\n",location);
fwrite(dir,sizeof(wad_entry),list.item_num,wad);
fseek(wad,8,SEEK_SET);
fwrite(&location,4,1,wad); // write directory offset

printf("\n\npcx2wad v.999(beta beta), daniel gilliland\n");

free(dir);
fclose(wad);
return 0; }



