;points are float x, float y, float z, dword filler

;
;In:
;       ebx: number of spline pts in v
;       ecx: number of control pts in v
;       esi: ptr to control pts
;       edi: ptr to spline pts
;       u_spline_pts: number of spline pts in u
;       u_control_pts: number of control pts in u

align 32
proc    bspline_patch n

        cmp     ecx, 4
        jb      @@done

        mov     ebp, ecx
        sub     ebp, 3

        mov     eax, [u_control_pts]
        shl     eax, 4
        mov     [u_control_ofs], eax

        xor     edx, edx
        mov     eax, ebx
        div     ebp

        dec     eax
        inc     edx
        mov     [bspline_ptspersecv], eax
        mov     [bspline_leftoverptsv], edx
        
@@bspline_sec:
        mov     ebx, [bspline_ptspersecv]
        mov     [bspline_temp], ebx
        cmp     ebp, 1
        jne     @@not_last

        add     ebx, [bspline_leftoverptsv]
        dec     [bspline_temp]

@@not_last:
        fld1
        fild    [bspline_temp]
        fdiv
        fstp    [bspline_vadd]

        fldz
        fstp    [bspline_v]

@@bspline_pts:
        fld     [bspline_v]
        fstp    [bspline_u]
        call    bspline_blend
        fld     [bspline_b0]
        fstp    [bspline_b0v]
        fld     [bspline_b1]
        fstp    [bspline_b1v]
        fld     [bspline_b2]
        fstp    [bspline_b2v]
        fld     [bspline_b3]
        fstp    [bspline_b3v]

        push    ebx ebp esi
        mov     ebx, [u_spline_pts]
        mov     ecx, [u_control_pts]
        call    bspline_patch_curve
        pop     esi ebp ebx

        fld     [bspline_v]
        fadd    [bspline_vadd]
        fstp    [bspline_v]

        dec     ebx
        jnz     @@bspline_pts

        add     esi, [u_control_ofs]

        dec     ebp
        jnz     @@bspline_sec

@@done:
        ret

endp

align 8
bspline_v               dq ?
bspline_vadd            dq ?
bspline_ptspersecv      dd ?
bspline_leftoverptsv    dd ?

u_spline_pts            dd ?
u_control_pts           dd ?
u_control_ofs           dd ?

;
;In:
;       ebx: number of spline pts
;       ecx: number of control pts
;       esi: control pts
;       edi: spline pts

align 32
proc    bspline_patch_curve n

        cmp     ecx, 4
        jb      @@done

        mov     ebp, ecx
        sub     ebp, 3

        xor     edx, edx
        mov     eax, ebx
        div     ebp

        dec     eax
        inc     edx

        mov     [bspline_ptspersec], eax
        mov     [bspline_leftoverpts], edx
        
@@bspline_sec:
        mov     ebx, [bspline_ptspersec]
        mov     [bspline_temp], ebx
        cmp     ebp, 1
        jne     @@not_last

        add     ebx, [bspline_leftoverpts]
        dec     [bspline_temp]

@@not_last:
        fld1
        fild    [bspline_temp]
        ;fsub    st, st(1)
        fdiv
        fstp    [bspline_uadd]

        fldz
        fstp    [bspline_u]

@@bspline_pts:
        call    bspline_patch_pt
        fld     [bspline_u]
        fadd    [bspline_uadd]
        fstp    [bspline_u]

        add     edi, 16
        dec     ebx
        jnz     @@bspline_pts

        add     esi, 16
        dec     ebp
        jnz     @@bspline_sec

@@done:
        ret

endp

;

align 32
proc    bspline_patch_pt n

        call    bspline_blend

;                                      

        xor     eax, eax

        fld     [d esi + eax]
        fmul    [bspline_b0]
        fmul    [bspline_b0v]
        fld     [d esi + eax + 16]
        fmul    [bspline_b1]
        fmul    [bspline_b0v]
        fadd
        fld     [d esi + eax + 32]
        fmul    [bspline_b2]
        fmul    [bspline_b0v]
        fld     [d esi + eax + 48]
        fmul    [bspline_b3]
        fmul    [bspline_b0v]
        fadd
        fadd
        fstp    [d edi]

        fld     [d esi + 4 + eax]
        fmul    [bspline_b0]
        fmul    [bspline_b0v]
        fld     [d esi + eax + 4 + 16]
        fmul    [bspline_b1]
        fmul    [bspline_b0v]
        fadd
        fld     [d esi + eax + 4 + 32]
        fmul    [bspline_b2]
        fmul    [bspline_b0v]
        fld     [d esi + eax + 4 + 48]
        fmul    [bspline_b3]
        fmul    [bspline_b0v]
        fadd
        fadd
        fstp    [d edi + 4]

        fld     [d esi + 8 + eax]
        fmul    [bspline_b0]
        fmul    [bspline_b0v]
        fld     [d esi + eax + 8 + 16]
        fmul    [bspline_b1]
        fmul    [bspline_b0v]
        fadd
        fld     [d esi + eax + 8 + 32]
        fmul    [bspline_b2]
        fmul    [bspline_b0v]
        fld     [d esi + eax + 8 + 48]
        fmul    [bspline_b3]
        fmul    [bspline_b0v]
        fadd
        fadd
        fstp    [d edi + 8]

;                                       

        mov     eax, [u_control_ofs]

        fld     [d esi + eax]
        fmul    [bspline_b0]
        fmul    [bspline_b1v]
        fld     [d esi + eax + 16]
        fmul    [bspline_b1]
        fmul    [bspline_b1v]
        fadd
        fld     [d esi + eax + 32]
        fmul    [bspline_b2]
        fmul    [bspline_b1v]
        fld     [d esi + eax + 48]
        fmul    [bspline_b3]
        fmul    [bspline_b1v]
        fadd
        fadd
        fadd    [d edi]
        fstp    [d edi]

        fld     [d esi + 4 + eax]
        fmul    [bspline_b0]
        fmul    [bspline_b1v]
        fld     [d esi + eax + 4 + 16]
        fmul    [bspline_b1]
        fmul    [bspline_b1v]
        fadd
        fld     [d esi + eax + 4 + 32]
        fmul    [bspline_b2]
        fmul    [bspline_b1v]
        fld     [d esi + eax + 4 + 48]
        fmul    [bspline_b3]
        fmul    [bspline_b1v]
        fadd
        fadd
        fadd    [d edi + 4]
        fstp    [d edi + 4]

        fld     [d esi + 8 + eax]
        fmul    [bspline_b0]
        fmul    [bspline_b1v]
        fld     [d esi + eax + 8 + 16]
        fmul    [bspline_b1]
        fmul    [bspline_b1v]
        fadd
        fld     [d esi + eax + 8 + 32]
        fmul    [bspline_b2]
        fmul    [bspline_b1v]
        fld     [d esi + eax + 8 + 48]
        fmul    [bspline_b3]
        fmul    [bspline_b1v]
        fadd
        fadd
        fadd    [d edi + 8]
        fstp    [d edi + 8]

;                                       

        mov     eax, [u_control_ofs]
        add     eax, [u_control_ofs]    

        fld     [d esi + eax]
        fmul    [bspline_b0]
        fmul    [bspline_b2v]
        fld     [d esi + eax + 16]
        fmul    [bspline_b1]
        fmul    [bspline_b2v]
        fadd
        fld     [d esi + eax + 32]
        fmul    [bspline_b2]
        fmul    [bspline_b2v]
        fld     [d esi + eax + 48]
        fmul    [bspline_b3]
        fmul    [bspline_b2v]
        fadd
        fadd
        fadd    [d edi]
        fstp    [d edi]

        fld     [d esi + 4 + eax]
        fmul    [bspline_b0]
        fmul    [bspline_b2v]
        fld     [d esi + eax + 4 + 16]
        fmul    [bspline_b1]
        fmul    [bspline_b2v]
        fadd
        fld     [d esi + eax + 4 + 32]
        fmul    [bspline_b2]
        fmul    [bspline_b2v]
        fld     [d esi + eax + 4 + 48]
        fmul    [bspline_b3]
        fmul    [bspline_b2v]
        fadd
        fadd
        fadd    [d edi + 4]
        fstp    [d edi + 4]

        fld     [d esi + 8 + eax]
        fmul    [bspline_b0]
        fmul    [bspline_b2v]
        fld     [d esi + eax + 8 + 16]
        fmul    [bspline_b1]
        fmul    [bspline_b2v]
        fadd
        fld     [d esi + eax + 8 + 32]
        fmul    [bspline_b2]
        fmul    [bspline_b2v]
        fld     [d esi + eax + 8 + 48]
        fmul    [bspline_b3]
        fmul    [bspline_b2v]
        fadd
        fadd
        fadd    [d edi + 8]
        fstp    [d edi + 8]

;                                       

        mov     eax, [u_control_ofs]
        add     eax, [u_control_ofs]    
        add     eax, [u_control_ofs]    

        fld     [d esi + eax]
        fmul    [bspline_b0]
        fmul    [bspline_b3v]
        fld     [d esi + eax + 16]
        fmul    [bspline_b1]
        fmul    [bspline_b3v]
        fadd
        fld     [d esi + eax + 32]
        fmul    [bspline_b2]
        fmul    [bspline_b3v]
        fld     [d esi + eax + 48]
        fmul    [bspline_b3]
        fmul    [bspline_b3v]
        fadd
        fadd
        fadd    [d edi]
        fstp    [d edi]

        fld     [d esi + 4 + eax]
        fmul    [bspline_b0]
        fmul    [bspline_b3v]
        fld     [d esi + eax + 4 + 16]
        fmul    [bspline_b1]
        fmul    [bspline_b3v]
        fadd
        fld     [d esi + eax + 4 + 32]
        fmul    [bspline_b2]
        fmul    [bspline_b3v]
        fld     [d esi + eax + 4 + 48]
        fmul    [bspline_b3]
        fmul    [bspline_b3v]
        fadd
        fadd
        fadd    [d edi + 4]
        fstp    [d edi + 4]

        fld     [d esi + 8 + eax]
        fmul    [bspline_b0]
        fmul    [bspline_b3v]
        fld     [d esi + eax + 8 + 16]
        fmul    [bspline_b1]
        fmul    [bspline_b3v]
        fadd
        fld     [d esi + eax + 8 + 32]
        fmul    [bspline_b2]
        fmul    [bspline_b3v]
        fld     [d esi + eax + 8 + 48]
        fmul    [bspline_b3]
        fmul    [bspline_b3v]
        fadd
        fadd
        fadd    [d edi + 8]
        fstp    [d edi + 8]

;                                      

        ret

endp

;
;In:
;       ebx: number of spline pts
;       ecx: number of control pts
;       esi: control pts
;       edi: spline pts

align 32
proc    bspline_curve n

        cmp     ecx, 4
        jb      @@done

        mov     ebp, ecx
        sub     ebp, 3

        xor     edx, edx
        mov     eax, ebx
        div     ebp

        mov     [bspline_ptspersec], eax
        mov     [bspline_leftoverpts], edx
        
@@bspline_sec:
        mov     ebx, [bspline_ptspersec]
        cmp     ebp, 1
        jne     @@not_last

        add     ebx, [bspline_leftoverpts]

@@not_last:
        mov     [bspline_temp], ebx
        fld1
        fild    [bspline_temp]
        fsub    st, st(1)
        fdiv
        fstp    [bspline_uadd]

        fldz
        fstp    [bspline_u]

@@bspline_pts:
        call    bspline_curve_pt
        fld     [bspline_u]
        fadd    [bspline_uadd]
        fstp    [bspline_u]

        add     edi, 16
        dec     ebx
        jnz     @@bspline_pts

        add     esi, 16
        dec     ebp
        jnz     @@bspline_sec

@@done:
        ret

endp

align 8
bspline_uadd            dq ?

bspline_temp            dd ?
bspline_ptspersec       dd ?
bspline_leftoverpts     dd ?

;

align 32
proc    bspline_curve_pt n

        call    bspline_blend

        fld     [d esi]
        fmul    [bspline_b0]
        fld     [d esi + 16]
        fmul    [bspline_b1]
        fadd
        fld     [d esi + 32]
        fmul    [bspline_b2]
        fld     [d esi + 48]
        fmul    [bspline_b3]
        fadd
        fadd
        fstp    [d edi]

        fld     [d esi + 4]
        fmul    [bspline_b0]
        fld     [d esi + 16 + 4]
        fmul    [bspline_b1]
        fadd
        fld     [d esi + 32 + 4]
        fmul    [bspline_b2]
        fld     [d esi + 48 + 4]
        fmul    [bspline_b3]
        fadd
        fadd
        fstp    [d edi + 4]

        fld     [d esi + 8]
        fmul    [bspline_b0]
        fld     [d esi + 16 + 8]
        fmul    [bspline_b1]
        fadd
        fld     [d esi + 32 + 8]
        fmul    [bspline_b2]
        fld     [d esi + 48 + 8]
        fmul    [bspline_b3]
        fadd
        fadd
        fstp    [d edi + 8]

        ret

endp

;
;In:            
;       esi: control pts
;       edi: spline pt

align 32
proc    bspline_blend n

        fld     [bspline_u]
        fmul    [bspline_u]
        fst     [bspline_u2]
        fmul    [bspline_u]
        fstp    [bspline_u3]

        fld1
        fsub    [bspline_u]
        fld     st
        fld     st
        fmul
        fmul
        fmul    [bspline_1_over_6]
        fstp    [bspline_b0]

        fld     [bspline_u3]
        fmul    [bspline_3]
        fld     [bspline_u2]
        fmul    [bspline_m6]
        fadd
        fadd    [bspline_4]
        fmul    [bspline_1_over_6]
        fstp    [bspline_b1]

        fld     [bspline_u3]
        fmul    [bspline_m3]
        fld     [bspline_u2]
        fmul    [bspline_3]
        fadd
        fld     [bspline_u]
        fmul    [bspline_3]
        fadd
        fadd    [bspline_1]
        fmul    [bspline_1_over_6]
        fstp    [bspline_b2]

        fld     [bspline_u3]
        fmul    [bspline_1_over_6]
        fstp    [bspline_b3]

        ret

endp

align 8
bspline_u               dq ?
bspline_u2              dq ?
bspline_u3              dq ?

bspline_b0              dq ?
bspline_b1              dq ?
bspline_b2              dq ?
bspline_b3              dq ?

bspline_b0v             dq ?
bspline_b1v             dq ?
bspline_b2v             dq ?
bspline_b3v             dq ?

bspline_1_over_6        dq 0.166666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666
bspline_1_over_4        dq 0.25
bspline_1_over_2        dq 0.50
bspline_3_over_4        dq 0.75

bspline_1               dq 1.0
bspline_3               dq 3.0
bspline_m3              dq -3.0
bspline_4               dq 4.0
bspline_6               dq 6.0
bspline_m6              dq -6.0

;
if 0
;In:
;       ebx: number of spline pts
;       ecx: number of control pts
;       esi: control pts
;       edi: spline pts

align 32
proc    cspline n

        cmp     ecx, 4
        jb      @@done

        fld     [cspline_1]
        fsub    [cspline_t]
        fdiv    [cspline_2]
        fst     [cspline_s]
        fchs
        fstp    [cspline_ms]

        mov     ebp, ecx
        sub     ebp, 3

        xor     edx, edx
        mov     eax, ebx
        div     ebp

        mov     [cspline_ptspersec], eax
        mov     [cspline_leftoverpts], edx

@@cspline_sec:
        mov     ebx, [cspline_ptspersec]
        cmp     ebp, 1
        jne     @@not_last

        add     ebx, [cspline_leftoverpts]

@@not_last:
        mov     [cspline_temp], ebx
        fld1
        fild    [cspline_temp]
        fsub    st, st(1)
        fdiv
        fstp    [cspline_uadd]

        fldz
        fstp    [cspline_u]

@@cspline_pts:
        call    cspline_pt
        fld     [cspline_u]
        fadd    [cspline_uadd]
        fstp    [cspline_u]

        add     edi, 16
        dec     ebx
        jnz     @@cspline_pts

        add     esi, 16
        dec     ebp
        jnz     @@cspline_sec

@@done:
        ret

endp

align 8
cspline_t               dq 0.0
cspline_uadd            dq ?

cspline_temp            dd ?
cspline_ptspersec       dd ?
cspline_leftoverpts     dd ?

;
;In:
;       ecx: number of control pts
;       esi: control pts
;       edi: spline pt

align 32
proc    cspline_pt n

        fld     [cspline_u]
        fmul    [cspline_u]
        fst     [cspline_u2]
        fmul    [cspline_u]
        fstp    [cspline_u3]

        fld     [cspline_u3]
        fmul    [cspline_ms]
        fld     [cspline_u2]
        fmul    [cspline_s]
        fld     st
        fadd
        fadd
        fld     [cspline_u]
        fmul    [cspline_ms]
        fadd
        fstp    [cspline_b0]

        fld     [cspline_2]
        fsub    [cspline_s]
        fmul    [cspline_u3]
        fld     [cspline_s]
        fsub    [cspline_3]
        fmul    [cspline_u2]
        fadd    [cspline_1]
        fadd
        fstp    [cspline_b1]

        fld     [cspline_s]
        fsub    [cspline_2]
        fmul    [cspline_u3]
        fld     [cspline_3]
        fsub    [cspline_s]
        fsub    [cspline_s]
        fmul    [cspline_u2]
        fadd
        fld     [cspline_s]
        fmul    [cspline_u]
        fadd
        fstp    [cspline_b2]

        fld     [cspline_u3]
        fsub    [cspline_u2]
        fmul    [cspline_s]
        fstp    [cspline_b3]

        fld     [d esi]
        fmul    [cspline_b0]
        fld     [d esi + 16]
        fmul    [cspline_b1]
        fadd
        fld     [d esi + 32]
        fmul    [cspline_b2]
        fld     [d esi + 48]
        fmul    [cspline_b3]
        fadd
        fadd
        fstp    [d edi]

        fld     [d esi + 4]
        fmul    [cspline_b0]
        fld     [d esi + 16 + 4]
        fmul    [cspline_b1]
        fadd
        fld     [d esi + 32 + 4]
        fmul    [cspline_b2]
        fld     [d esi + 48 + 4]
        fmul    [cspline_b3]
        fadd
        fadd
        fstp    [d edi + 4]

        fld     [d esi + 8]
        fmul    [cspline_b0]
        fld     [d esi + 16 + 8]
        fmul    [cspline_b1]
        fadd
        fld     [d esi + 32 + 8]
        fmul    [cspline_b2]
        fld     [d esi + 48 + 8]
        fmul    [cspline_b3]
        fadd
        fadd
        fstp    [d edi + 8]

        ret

endp

align 8
cspline_s               dq 1.5          ;s = (1 - t)/2, t = tension
cspline_ms              dq -1.5
cspline_u               dq ?
cspline_u2              dq ?
cspline_u3              dq ?

cspline_b0              dq ?
cspline_b1              dq ?
cspline_b2              dq ?
cspline_b3              dq ?

cspline_1               dq 1.0
cspline_2               dq 2.0
cspline_3               dq 3.0
endif
;
;In:
;       ecx: number of pts
;       esi: pts

align 32
proc    draw_curve n

        push    ebx ecx esi edi

        mov     ebp, ecx
        dec     ebp
        jz      @@done

        mov     edx, esi

@@draw_1:
        push    eax edx ebp
        fld     [d edx]
        fistp   [@@temp]
        mov     ebx, [@@temp]
        fld     [d edx + 4]
        fistp   [@@temp]
        mov     ecx, [@@temp]
        fld     [d edx + 16]
        fistp   [@@temp]
        mov     esi, [@@temp]
        fld     [d edx + 16 + 4]
        fistp   [@@temp]
        mov     edi, [@@temp]

        call    draw_line

        pop     ebp edx eax
        add     edx, 16
        dec     ebp
        jnz     @@draw_1

@@done:
        pop     edi esi ecx ebx
        ret

@@temp  dd ?

endp

;
;In:
;       ecx: number of u pts
;       edx: number of v pts
;       esi: pts

align 32
proc    draw_patch n

        pushad

        imul    ecx, edx
        mov     edx, esi

@@draw_dot:
        push    eax ecx edx ebp
        fld     [d edx]
        fistp   [@@temp]
        mov     ebx, [@@temp]
        fld     [d edx + 4]
        fistp   [@@temp]
        mov     ecx, [@@temp]
        call    draw_pixel ;dot
        pop     ebp edx ecx eax
        add     edx, 16
        dec     ecx
        jnz     @@draw_dot

        popad
        ret        

@@temp  dd ?

endp

;
;In:
;       ebx: number of spline pts in v
;       ecx: number of control pts in v
;       esi: control pts
;       edi: spline pts
;       u_spline_pts: number of spline pts in u
;       u_control_pts: number of control pts in u

align 32
proc    cspline_patch n

        cmp     ecx, 4
        jb      @@done

        fld     [cspline_1]
        fsub    [cspline_t]
        fdiv    [cspline_2]
        fst     [cspline_s]
        fchs
        fstp    [cspline_ms]

        mov     ebp, ecx
        sub     ebp, 3

        mov     eax, [u_control_pts]
        shl     eax, 4
        mov     [u_control_ofs], eax

        xor     edx, edx
        mov     eax, ebx
        div     ebp

        dec     eax
        inc     edx
        mov     [cspline_ptspersecv], eax
        mov     [cspline_leftoverptsv], edx
        
@@cspline_sec:
        mov     ebx, [cspline_ptspersecv]
        mov     [cspline_temp], ebx
        cmp     ebp, 1
        jne     @@not_last

        add     ebx, [cspline_leftoverptsv]
        dec     [cspline_temp]

@@not_last:
        fld1
        fild    [cspline_temp]
        fdiv
        fstp    [cspline_vadd]

        fldz
        fstp    [cspline_v]

@@cspline_pts:
        fld     [cspline_v]
        fstp    [cspline_u]
        call    cspline_blend
        fld     [cspline_b0]
        fstp    [cspline_b0v]
        fld     [cspline_b1]
        fstp    [cspline_b1v]
        fld     [cspline_b2]
        fstp    [cspline_b2v]
        fld     [cspline_b3]
        fstp    [cspline_b3v]

        push    ebx ebp esi
        mov     ebx, [u_spline_pts]
        mov     ecx, [u_control_pts]
        call    cspline_patch_curve
        pop     esi ebp ebx

        fld     [cspline_v]
        fadd    [cspline_vadd]
        fstp    [cspline_v]

        dec     ebx
        jnz     @@cspline_pts

        add     esi, [u_control_ofs]

        dec     ebp
        jnz     @@cspline_sec

@@done:
        ret

endp

align 8
cspline_v               dq ?
cspline_vadd            dq ?
cspline_ptspersecv      dd ?
cspline_leftoverptsv    dd ?

;
;In:
;       ebx: number of spline pts
;       ecx: number of control pts
;       esi: control pts
;       edi: spline pts

align 32
proc    cspline_patch_curve n

        cmp     ecx, 4
        jb      @@done

        mov     ebp, ecx
        sub     ebp, 3

        xor     edx, edx
        mov     eax, ebx
        div     ebp

        dec     eax
        inc     edx

        mov     [cspline_ptspersec], eax
        mov     [cspline_leftoverpts], edx
        
@@cspline_sec:
        mov     ebx, [cspline_ptspersec]
        mov     [cspline_temp], ebx
        cmp     ebp, 1
        jne     @@not_last

        add     ebx, [cspline_leftoverpts]
        dec     [cspline_temp]

@@not_last:
        fld1
        fild    [cspline_temp]
        ;fsub    st, st(1)
        fdiv
        fstp    [cspline_uadd]

        fldz
        fstp    [cspline_u]

@@cspline_pts:
        call    cspline_patch_pt
        fld     [cspline_u]
        fadd    [cspline_uadd]
        fstp    [cspline_u]

        add     edi, 16
        dec     ebx
        jnz     @@cspline_pts

        add     esi, 16
        dec     ebp
        jnz     @@cspline_sec

@@done:
        ret

endp

;

align 32
proc    cspline_patch_pt n

        call    cspline_blend

;                                      

        xor     eax, eax

        fld     [d esi + eax]
        fmul    [cspline_b0]
        fmul    [cspline_b0v]
        fld     [d esi + eax + 16]
        fmul    [cspline_b1]
        fmul    [cspline_b0v]
        fadd
        fld     [d esi + eax + 32]
        fmul    [cspline_b2]
        fmul    [cspline_b0v]
        fld     [d esi + eax + 48]
        fmul    [cspline_b3]
        fmul    [cspline_b0v]
        fadd
        fadd
        fstp    [d edi]

        fld     [d esi + 4 + eax]
        fmul    [cspline_b0]
        fmul    [cspline_b0v]
        fld     [d esi + eax + 4 + 16]
        fmul    [cspline_b1]
        fmul    [cspline_b0v]
        fadd
        fld     [d esi + eax + 4 + 32]
        fmul    [cspline_b2]
        fmul    [cspline_b0v]
        fld     [d esi + eax + 4 + 48]
        fmul    [cspline_b3]
        fmul    [cspline_b0v]
        fadd
        fadd
        fstp    [d edi + 4]

        fld     [d esi + 8 + eax]
        fmul    [cspline_b0]
        fmul    [cspline_b0v]
        fld     [d esi + eax + 8 + 16]
        fmul    [cspline_b1]
        fmul    [cspline_b0v]
        fadd
        fld     [d esi + eax + 8 + 32]
        fmul    [cspline_b2]
        fmul    [cspline_b0v]
        fld     [d esi + eax + 8 + 48]
        fmul    [cspline_b3]
        fmul    [cspline_b0v]
        fadd
        fadd
        fstp    [d edi + 8]

;                                       

        mov     eax, [u_control_ofs]

        fld     [d esi + eax]
        fmul    [cspline_b0]
        fmul    [cspline_b1v]
        fld     [d esi + eax + 16]
        fmul    [cspline_b1]
        fmul    [cspline_b1v]
        fadd
        fld     [d esi + eax + 32]
        fmul    [cspline_b2]
        fmul    [cspline_b1v]
        fld     [d esi + eax + 48]
        fmul    [cspline_b3]
        fmul    [cspline_b1v]
        fadd
        fadd
        fadd    [d edi]
        fstp    [d edi]

        fld     [d esi + 4 + eax]
        fmul    [cspline_b0]
        fmul    [cspline_b1v]
        fld     [d esi + eax + 4 + 16]
        fmul    [cspline_b1]
        fmul    [cspline_b1v]
        fadd
        fld     [d esi + eax + 4 + 32]
        fmul    [cspline_b2]
        fmul    [cspline_b1v]
        fld     [d esi + eax + 4 + 48]
        fmul    [cspline_b3]
        fmul    [cspline_b1v]
        fadd
        fadd
        fadd    [d edi + 4]
        fstp    [d edi + 4]

        fld     [d esi + 8 + eax]
        fmul    [cspline_b0]
        fmul    [cspline_b1v]
        fld     [d esi + eax + 8 + 16]
        fmul    [cspline_b1]
        fmul    [cspline_b1v]
        fadd
        fld     [d esi + eax + 8 + 32]
        fmul    [cspline_b2]
        fmul    [cspline_b1v]
        fld     [d esi + eax + 8 + 48]
        fmul    [cspline_b3]
        fmul    [cspline_b1v]
        fadd
        fadd
        fadd    [d edi + 8]
        fstp    [d edi + 8]

;                                       

        mov     eax, [u_control_ofs]
        add     eax, [u_control_ofs]    

        fld     [d esi + eax]
        fmul    [cspline_b0]
        fmul    [cspline_b2v]
        fld     [d esi + eax + 16]
        fmul    [cspline_b1]
        fmul    [cspline_b2v]
        fadd
        fld     [d esi + eax + 32]
        fmul    [cspline_b2]
        fmul    [cspline_b2v]
        fld     [d esi + eax + 48]
        fmul    [cspline_b3]
        fmul    [cspline_b2v]
        fadd
        fadd
        fadd    [d edi]
        fstp    [d edi]

        fld     [d esi + 4 + eax]
        fmul    [cspline_b0]
        fmul    [cspline_b2v]
        fld     [d esi + eax + 4 + 16]
        fmul    [cspline_b1]
        fmul    [cspline_b2v]
        fadd
        fld     [d esi + eax + 4 + 32]
        fmul    [cspline_b2]
        fmul    [cspline_b2v]
        fld     [d esi + eax + 4 + 48]
        fmul    [cspline_b3]
        fmul    [cspline_b2v]
        fadd
        fadd
        fadd    [d edi + 4]
        fstp    [d edi + 4]

        fld     [d esi + 8 + eax]
        fmul    [cspline_b0]
        fmul    [cspline_b2v]
        fld     [d esi + eax + 8 + 16]
        fmul    [cspline_b1]
        fmul    [cspline_b2v]
        fadd
        fld     [d esi + eax + 8 + 32]
        fmul    [cspline_b2]
        fmul    [cspline_b2v]
        fld     [d esi + eax + 8 + 48]
        fmul    [cspline_b3]
        fmul    [cspline_b2v]
        fadd
        fadd
        fadd    [d edi + 8]
        fstp    [d edi + 8]

;                                       

        mov     eax, [u_control_ofs]
        add     eax, [u_control_ofs]    
        add     eax, [u_control_ofs]    

        fld     [d esi + eax]
        fmul    [cspline_b0]
        fmul    [cspline_b3v]
        fld     [d esi + eax + 16]
        fmul    [cspline_b1]
        fmul    [cspline_b3v]
        fadd
        fld     [d esi + eax + 32]
        fmul    [cspline_b2]
        fmul    [cspline_b3v]
        fld     [d esi + eax + 48]
        fmul    [cspline_b3]
        fmul    [cspline_b3v]
        fadd
        fadd
        fadd    [d edi]
        fstp    [d edi]

        fld     [d esi + 4 + eax]
        fmul    [cspline_b0]
        fmul    [cspline_b3v]
        fld     [d esi + eax + 4 + 16]
        fmul    [cspline_b1]
        fmul    [cspline_b3v]
        fadd
        fld     [d esi + eax + 4 + 32]
        fmul    [cspline_b2]
        fmul    [cspline_b3v]
        fld     [d esi + eax + 4 + 48]
        fmul    [cspline_b3]
        fmul    [cspline_b3v]
        fadd
        fadd
        fadd    [d edi + 4]
        fstp    [d edi + 4]

        fld     [d esi + 8 + eax]
        fmul    [cspline_b0]
        fmul    [cspline_b3v]
        fld     [d esi + eax + 8 + 16]
        fmul    [cspline_b1]
        fmul    [cspline_b3v]
        fadd
        fld     [d esi + eax + 8 + 32]
        fmul    [cspline_b2]
        fmul    [cspline_b3v]
        fld     [d esi + eax + 8 + 48]
        fmul    [cspline_b3]
        fmul    [cspline_b3v]
        fadd
        fadd
        fadd    [d edi + 8]
        fstp    [d edi + 8]

;                                      

        ret

endp

;
;In:
;       ebx: number of spline pts
;       ecx: number of control pts
;       esi: control pts
;       edi: spline pts

align 32
proc    cspline_curve n

        cmp     ecx, 4
        jb      @@done

        fld     [cspline_1]
        fsub    [cspline_t]
        fdiv    [cspline_2]
        fst     [cspline_s]
        fchs
        fstp    [cspline_ms]

        mov     ebp, ecx
        sub     ebp, 3

        xor     edx, edx
        mov     eax, ebx
        div     ebp

        mov     [cspline_ptspersec], eax
        mov     [cspline_leftoverpts], edx
        
@@cspline_sec:
        mov     ebx, [cspline_ptspersec]
        cmp     ebp, 1
        jne     @@not_last

        add     ebx, [cspline_leftoverpts]

@@not_last:
        mov     [cspline_temp], ebx
        fld1
        fild    [cspline_temp]
        fsub    st, st(1)
        fdiv
        fstp    [cspline_uadd]

        fldz
        fstp    [cspline_u]

@@cspline_pts:
        call    cspline_curve_pt
        fld     [cspline_u]
        fadd    [cspline_uadd]
        fstp    [cspline_u]

        add     edi, 16
        dec     ebx
        jnz     @@cspline_pts

        add     esi, 16
        dec     ebp
        jnz     @@cspline_sec

@@done:
        ret

endp

align 8
cspline_t               dq -1.0
cspline_uadd            dq ?

cspline_temp            dd ?
cspline_ptspersec       dd ?
cspline_leftoverpts     dd ?

;

align 32
proc    cspline_curve_pt n

        call    cspline_blend

        fld     [d esi]
        fmul    [cspline_b0]
        fld     [d esi + 16]
        fmul    [cspline_b1]
        fadd
        fld     [d esi + 32]
        fmul    [cspline_b2]
        fld     [d esi + 48]
        fmul    [cspline_b3]
        fadd
        fadd
        fstp    [d edi]

        fld     [d esi + 4]
        fmul    [cspline_b0]
        fld     [d esi + 16 + 4]
        fmul    [cspline_b1]
        fadd
        fld     [d esi + 32 + 4]
        fmul    [cspline_b2]
        fld     [d esi + 48 + 4]
        fmul    [cspline_b3]
        fadd
        fadd
        fstp    [d edi + 4]

        fld     [d esi + 8]
        fmul    [cspline_b0]
        fld     [d esi + 16 + 8]
        fmul    [cspline_b1]
        fadd
        fld     [d esi + 32 + 8]
        fmul    [cspline_b2]
        fld     [d esi + 48 + 8]
        fmul    [cspline_b3]
        fadd
        fadd
        fstp    [d edi + 8]

        ret

endp

;
;In:            
;       esi: control pts
;       edi: spline pt

align 32
proc    cspline_blend n

        fld     [cspline_u]
        fmul    [cspline_u]
        fst     [cspline_u2]
        fmul    [cspline_u]
        fstp    [cspline_u3]

        fld     [cspline_u3]
        fmul    [cspline_ms]
        fld     [cspline_u2]
        fmul    [cspline_s]
        fld     st
        fadd
        fadd
        fld     [cspline_u]
        fmul    [cspline_ms]
        fadd
        fstp    [cspline_b0]

        fld     [cspline_2]
        fsub    [cspline_s]
        fmul    [cspline_u3]
        fld     [cspline_s]
        fsub    [cspline_3]
        fmul    [cspline_u2]
        fadd    [cspline_1]
        fadd
        fstp    [cspline_b1]

        fld     [cspline_s]
        fsub    [cspline_2]
        fmul    [cspline_u3]
        fld     [cspline_3]
        fsub    [cspline_s]
        fsub    [cspline_s]
        fmul    [cspline_u2]
        fadd
        fld     [cspline_s]
        fmul    [cspline_u]
        fadd
        fstp    [cspline_b2]

        fld     [cspline_u3]
        fsub    [cspline_u2]
        fmul    [cspline_s]
        fstp    [cspline_b3]

        ret

endp

align 8
cspline_s               dq 1.5          ;s = (1 - t)/2, t = tension
cspline_ms              dq -1.5
cspline_u               dq ?
cspline_u2              dq ?
cspline_u3              dq ?

cspline_b0              dq ?
cspline_b1              dq ?
cspline_b2              dq ?
cspline_b3              dq ?

cspline_b0v             dq ?
cspline_b1v             dq ?
cspline_b2v             dq ?
cspline_b3v             dq ?

cspline_1               dq 1.0
cspline_2               dq 2.0
cspline_3               dq 3.0

;
