#include <iostream.h>
#include <fstream.h>
#include <dos.h>
#include <sys\stat.h>
#include <string.h>
#include <fcntl.h>
#include <io.h>
#include <unistd.h>

#define byte unsigned char
#define word unsigned int
#define dword long unsigned int

dword verts_in_asc(char infile[]);
dword faces_in_asc(char infile[]);
void seek_past(char what[], ifstream& infile);

int main()
{
    ifstream asc;
    int file_3d;

	char infile[256];
	char outfile[256];

	char token[1024];

    char object[16] = "object:";
	char vertices[16] = "Vertices:";
	char vertex[16] = "Vertex";
	char vertexlist1[16] = "Vertex";
	char vertexlist2[16] = "list:";
	char facelist1[16] = "Face";
	char facelist2[16] = "list:";
	char faces[16] = "Faces:";
	char face[16] = "Face";

    char inchar;

    const float fzero = 0.0;

    float x, y, z;

    const dword zero = 0;

    dword obj_verts = 0;
    dword verts_done = 0;
    dword num_verts, num_faces, index, con1, con2, con3, normal;

	cout << "Input file   : ";
	cin >> infile;
	cout << "Output file  : ";
	cin >> outfile;

	asc.open(infile);
	if(asc.fail())
	{
		cout << "Error opening input file " << infile << endl;
		return 1;
	}

	_fmode = O_BINARY;
    file_3d = creat(outfile, S_IREAD | S_IWRITE);

    num_verts = verts_in_asc(infile);
    cout << "Number of verts in .asc: "<< num_verts << endl;
    num_faces = faces_in_asc(infile);
    cout << "Number of faces in .asc: "<< num_faces << endl;

    write(file_3d, &num_verts, 4);
    write(file_3d, &num_faces, 4);

	for(;;)
	{
        seek_past(object, asc);
        seek_past(vertices, asc);
        asc >> obj_verts;

        seek_past(vertexlist1, asc);
        seek_past(vertexlist2, asc);

        for(index = 0; index < obj_verts; index++)
        {
            seek_past(vertex, asc);
            asc >> token >> token >> x >> token
                >> y >> token >> z;
            write(file_3d, &x, 4);
            write(file_3d, &y, 4);
            write(file_3d, &z, 4);
            write(file_3d, &fzero, 4);
        }
        verts_done += obj_verts;
        if(verts_done == num_verts)
            break;
	}

	asc.close();
    asc.open(infile);

    dword obj_faces = 0;
    dword faces_done = 0;

    obj_verts = verts_done = 0;

	for(;;)
	{
        seek_past(object, asc);
        seek_past(vertices, asc);
        asc >> obj_verts;
        seek_past(faces, asc);
        asc >> obj_faces;

        seek_past(facelist1, asc);
        seek_past(facelist2, asc);

        for(index = 0; index < obj_faces; index++)
        {
            seek_past(face, asc);
            asc >> token >> inchar >> inchar >> con1
                >> inchar >> inchar >> con2 >> inchar
                >> inchar >> con3;

            con1 += verts_done;
            con2 += verts_done;
            con3 += verts_done;
            con1 *= 16;
            con2 *= 16;
            con3 *= 16;
            write(file_3d, &con1, 4);
            write(file_3d, &con2, 4);
            write(file_3d, &con3, 4);

            write(file_3d, &fzero, 4);
            write(file_3d, &fzero, 4);
            write(file_3d, &fzero, 4);
            write(file_3d, &fzero, 4);
            write(file_3d, &fzero, 4);
            write(file_3d, &fzero, 4);

            normal = (index + faces_done) * 16;
            write(file_3d, &normal, 4);

            write(file_3d, &fzero, 4);
            write(file_3d, &fzero, 4);
            write(file_3d, &fzero, 4);
        }
        verts_done += obj_verts;
        faces_done += obj_faces;
        if(faces_done == num_faces)
            break;
	}

	asc.close();
    close(file_3d);
	return 0;
}

dword verts_in_asc(char infile[])
{
    ifstream asc;
	char token[1024];
	char vertices[16] = "Vertices:";
    dword obj_verts, file_verts = 0;

	asc.open(infile);
	if(asc.fail())
	{
		cout << "Error opening input file " << infile << endl;
                return 0;
	}

	for(;;)
	{
		if(!(asc >> token))
			break;
                if(!strcmp(token, vertices))
                {
                        asc >> obj_verts;
                        file_verts += obj_verts;
                }
	}

	asc.close();
    return file_verts;
}

dword faces_in_asc(char infile[])
{
    ifstream asc;
	char token[1024];
	char faces[16] = "Faces:";
    dword obj_faces, file_faces = 0;

	asc.open(infile);
	if(asc.fail())
	{
		cout << "Error opening input file " << infile << endl;
                return 0;
	}

	for(;;)
	{
		if(!(asc >> token))
			break;
                if(!strcmp(token, faces))
                {
                        asc >> obj_faces;
                        file_faces += obj_faces;
                }
	}

	asc.close();
    return file_faces;
}

void seek_past(char what[], ifstream& infile)
{
    char token[1024];

    if(!( infile >> token)) return;
    while(strcmp(token, what) != 0)
    {
        if(!(infile >> token)) return;
    }

    return;
}
