// MDLGfx.cpp 

#include "MedDLeGFX.h"		// Our added graphics routines

//#include "MedDLeTypes.h"

#include<math.h>
#include<limits.h>
// -- for rendering faster
#define G_MAX_TUPLES    200
int new_edges[G_MAX_TUPLES];        /* verticaly clipped polygon */
int new_length;
// -- end render

// for sorted faces
int *pIndexArray=NULL;
float *pZArray=NULL;
DWORD IndexArraySize=0;


static int MedDLeResX=0, MedDLeResY=0;
static int MedDLeBitCount=0;

int MedDLeCDCResX=0, MedDLeCDCResY=0; 
BYTE *MedDLeCurDib=NULL;

static WORD *MedDLeZBuffer=NULL;
static BYTE *MedDLeRAMScreen=NULL;
static BYTE *MedDLeDIBInfo=NULL;
static BYTE *MedDLeDIBInfo16=NULL;
static BYTE *MedDLeCustomDIBInfo=NULL;

static CDC *MedDLeCDC=NULL;

static BOOL gbUseZBuffer=FALSE;
static BOOL gb16Bit=FALSE;

static HDRAWDIB MedDLehDrawDib;
static DWORD MedDLePaletteWin[256];

BOOL bMedDLeDrawing=0;
BOOL bMedDLeOverlaying=0;

//CPalette pal;
#include "pal.h" //BYTE MedDLePalette[256*3];
#include "cmap.h" //BYTE MedDLeCMap[256*64];

void GrowFor(DWORD N)
{
	if(N > IndexArraySize)
	{
		IndexArraySize=N+100;
		if(pIndexArray) delete [] pIndexArray;
		pIndexArray = new int[IndexArraySize];
		if(!pIndexArray) return;
		if(pZArray) delete [] pZArray;
		pZArray = new float[IndexArraySize];
		if(!pZArray) return;
	}

}
void ShrinkFor(DWORD N)
{
	if(N+100 < IndexArraySize)
	{
		IndexArraySize=N+100;
		if(pIndexArray) delete [] pIndexArray;
		pIndexArray = new int[IndexArraySize];
		if(!pIndexArray) return;
		if(pZArray) delete [] pZArray;
		pZArray = new float[IndexArraySize];
		if(!pZArray) return;
	}
	
}

void DeleteSortArray()
{
	if(pIndexArray) delete [] pIndexArray;
	if(pZArray) delete [] pZArray;
	pIndexArray=NULL;
	pZArray=NULL;
	IndexArraySize=0;
}

//------------------------------------------------------------
// M e d D L e S w a p

void MedDLeSwap(float v[], int vi[], int i, int j)
{
	float temp;
	int itemp;

	temp = v[i];
	v[i]=v[j];
	v[j]=temp;
	itemp=vi[i];
	vi[i]=vi[j];
	vi[j]=itemp;
}

//------------------------------------------------------------
// M e d D L e S o r t

void MedDLeSort(float v[], int vi[], int left, int right)
{
	int i, last;

	if(left>=right) return;
	MedDLeSwap(v,vi,left,(left+right)/2);
	last=left;
	for(i=left+1; i<=right; i++)
		if(v[i]>v[left])
			MedDLeSwap(v,vi,++last,i);
	MedDLeSwap(v,vi,left,last);
	MedDLeSort(v,vi,left,last-1);
	MedDLeSort(v,vi,last+1,right);

}

//------------------------------------------------------------
// M e d D L e L o a d P a l

void MedDLeLoadPal( void )
{
	FILE *p;
  
	if((p=fopen("palette.lmp","rb"))!=NULL)
    {
		fread(MedDLePalette,1,256*3,p);
		fclose(p);
	}
	for(int i=0; i<256; i++)
	{
		MedDLePaletteWin[i]=MedDLePalette[i*3];
		MedDLePaletteWin[i]+=MedDLePalette[i*3+1]*0x100;
		MedDLePaletteWin[i]+=MedDLePalette[i*3+2]*0x1000;
	}

}

//------------------------------------------------------------
// M e d D L e L o a d C M a p

void MedDLeLoadCMap( void )
{
	FILE *p;
  
	if((p=fopen("colormap.lmp","rb"))!=NULL)
	{
		fread(MedDLeCMap,1,256*64,p);
		fclose(p);
	}
}

//------------------------------------------------------------
// M e d D L e I n i t D I B 

BOOL MedDLeInitDIB( void )
{
	if(MedDLeDIBInfo!=NULL) delete MedDLeDIBInfo;
	MedDLeDIBInfo = new BYTE[256*sizeof(RGBQUAD)+sizeof(BITMAPINFOHEADER)];
	if(MedDLeDIBInfo==NULL) return 0;

	BITMAPINFO *bm = (BITMAPINFO *)MedDLeDIBInfo;
	bm->bmiHeader.biWidth=256;
	bm->bmiHeader.biHeight=256;  // negative makes it a top down bmp
	bm->bmiHeader.biSize=sizeof(BITMAPINFOHEADER);
	bm->bmiHeader.biPlanes=1;      // must be 1
	bm->bmiHeader.biSizeImage=256*256;
	bm->bmiHeader.biCompression=BI_RGB;
	bm->bmiHeader.biBitCount=8; // bits per pixel
 	bm->bmiHeader.biClrUsed=256; 
 	bm->bmiHeader.biClrImportant=0; // means all colors important
	for(int i=0; i<256; i++)
	{
		bm->bmiColors[i].rgbRed=MedDLePalette[i*3];
		bm->bmiColors[i].rgbGreen=MedDLePalette[i*3+1];
		bm->bmiColors[i].rgbBlue=MedDLePalette[i*3+2];
	}
// for game like quake
	if(MedDLeCustomDIBInfo!=NULL) delete MedDLeCustomDIBInfo;
	MedDLeCustomDIBInfo = new BYTE[256*sizeof(RGBQUAD)+sizeof(BITMAPINFOHEADER)];
	if(MedDLeCustomDIBInfo==NULL) return 0;

	bm = (BITMAPINFO *)MedDLeCustomDIBInfo;
	bm->bmiHeader.biWidth=256;
	bm->bmiHeader.biHeight=256;  // negative makes it a top down bmp
	bm->bmiHeader.biSize=sizeof(BITMAPINFOHEADER);
	bm->bmiHeader.biPlanes=1;      // must be 1
	bm->bmiHeader.biSizeImage=256*256;
	bm->bmiHeader.biCompression=BI_RGB;
	bm->bmiHeader.biBitCount=8; // bits per pixel
 	bm->bmiHeader.biClrUsed=256; 
 	bm->bmiHeader.biClrImportant=0; // means all colors important
	for(i=0; i<256; i++)
	{
		bm->bmiColors[i].rgbRed=MedDLePalette[i*3];
		bm->bmiColors[i].rgbGreen=MedDLePalette[i*3+1];
		bm->bmiColors[i].rgbBlue=MedDLePalette[i*3+2];
	}

	CDC *pDC = new CDC;
	pDC->CreateDC( _T("DISPLAY"), NULL, NULL, NULL);
	if (pDC->GetDeviceCaps(BITSPIXEL) >= 15) 
	{
		MedDLeDIBInfo16 = new BYTE[sizeof(BITMAPINFOHEADER)+sizeof(RGBQUAD)];
	
		BITMAPINFO *bm = (BITMAPINFO *)MedDLeDIBInfo16;
		bm->bmiHeader.biWidth=256;
		bm->bmiHeader.biHeight=256;  
		bm->bmiHeader.biSize=sizeof(BITMAPINFOHEADER);
		bm->bmiHeader.biPlanes=1;      // must be 1
		bm->bmiHeader.biSizeImage=256*256;
		bm->bmiHeader.biCompression=BI_RGB;
		bm->bmiHeader.biBitCount=16; // bits per pixel
		bm->bmiHeader.biClrUsed=0; 
		bm->bmiHeader.biClrImportant=0; // means all colors important
	}
	else
	{
		MedDLeDIBInfo16=NULL;
	}
	delete pDC;
	
	return 1;
}

//------------------------------------------------------------
// M e d D L e I n i t G F X 

BOOL MedDLeInitGFX()
{

	bMedDLeDrawing=0;
	bMedDLeOverlaying=0;
	MedDLeResX = 100;
	MedDLeResY = 100;
	if((MedDLeRAMScreen = new BYTE[MedDLeResX*MedDLeResY]) == NULL) return 0;
	MedDLehDrawDib=DrawDibOpen();
	if(MedDLehDrawDib==NULL) return 0;

	MedDLeLoadPal();
	MedDLeLoadCMap();
	if( !MedDLeInitDIB()) return 0;

	return 1;

}

//------------------------------------------------------------
// M e d D L e S h u t D o w n G F X 

void MedDLeShutDownGFX()
{
	if(MedDLeRAMScreen!=NULL) delete [] MedDLeRAMScreen;
	MedDLeRAMScreen=NULL;

	if(MedDLeDIBInfo!=NULL) delete [] MedDLeDIBInfo;
	MedDLeDIBInfo=NULL;

	if(MedDLeCustomDIBInfo!=NULL) delete [] MedDLeCustomDIBInfo;
	MedDLeCustomDIBInfo=NULL;

	if(MedDLeDIBInfo16!=NULL) delete [] MedDLeDIBInfo16;
	MedDLeDIBInfo16=NULL;

	if(MedDLeZBuffer!=NULL) delete [] MedDLeZBuffer;
	MedDLeZBuffer=NULL;

	DrawDibClose(MedDLehDrawDib);
	bMedDLeOverlaying=bMedDLeDrawing=0;
	DeleteSortArray();
}

//------------------------------------------------------------
// M e d D L e B e g i n D r a w
BOOL MedDLeBeginDraw(CDC* pDC, CRect &rc, int bgcolor, BYTE *dib, DWORD flags)
{

	if(bMedDLeOverlaying) return 0;

	if(dib!=NULL) MedDLeCurDib=dib;
	else MedDLeCurDib=MedDLeDIBInfo;

	long bytes, obytes;
	bytes = ((BITMAPINFOHEADER*)MedDLeCurDib)->biBitCount/8;
	obytes = MedDLeBitCount/8;

	MedDLeCDCResY=rc.Height();

	long w=rc.Width();

	while(w%4) w++;

	MedDLeCDCResX=w;
	//MedDLeCDCResX = w+((w%4)&3)-1;

	if (bytes*MedDLeCDCResY*MedDLeCDCResX > obytes*MedDLeResX*MedDLeResY) 
	{

		if(MedDLeRAMScreen)	delete [] MedDLeRAMScreen;
		MedDLeResX = MedDLeCDCResX;
		MedDLeResY = MedDLeCDCResY;
		MedDLeBitCount=((BITMAPINFOHEADER*)MedDLeCurDib)->biBitCount;
		MedDLeRAMScreen = new BYTE[bytes*MedDLeResX*MedDLeResY];
		if(MedDLeRAMScreen==NULL) return 0;
	}
	MedDLeCDC = pDC;

	// to use 8 bit routines
	G_buffer=MedDLeRAMScreen;	
//	G_buffer=MedDLeRAMScreen;	
//	BG_Init3dWindow(MedDLeCDCResX, MedDLeCDCResY);

  	G_ScreenWidth = MedDLeCDCResX;
	G_ScreenHeight = MedDLeCDCResY;

	G_ClipXMin = 0;
	G_ClipYMin = 0;
	G_ClipXMax = MedDLeCDCResX-1;
	G_ClipYMax = MedDLeCDCResY-1;

	G_ScreenSize = MedDLeCDCResX*MedDLeCDCResY;
	G_LineSize = MedDLeCDCResX;
	G_clear(bgcolor);

	bMedDLeDrawing=1;
	return 1;

}

//------------------------------------------------------------
// M e d D L e E n d D r a w 

void MedDLeEndDraw()
{
	if(!bMedDLeDrawing) return;
	// blit dib!
	BITMAPINFO *bm;
	bm = (BITMAPINFO *)MedDLeCurDib;

	bm->bmiHeader.biWidth=MedDLeCDCResX;
	bm->bmiHeader.biHeight=MedDLeCDCResY;  // negative makes it a top down bmp
	bm->bmiHeader.biSizeImage=MedDLeCDCResX*MedDLeCDCResY;

	DrawDibRealize(MedDLehDrawDib, MedDLeCDC->GetSafeHdc(),TRUE);
	DrawDibDraw(MedDLehDrawDib, MedDLeCDC->GetSafeHdc(),
		0,0,  //x,y
		MedDLeCDCResX, MedDLeCDCResY, //w,h
		(BITMAPINFOHEADER *)MedDLeCurDib,//mdi,
		MedDLeRAMScreen,
		0,0, //source x,y
		MedDLeCDCResX, MedDLeCDCResY,//source w,h
		DDF_BACKGROUNDPAL
	);
	bMedDLeDrawing=0;

}

//------------------------------------------------------------
// M e d D L e D r a w L i n e 

void MedDLeDrawLine(int *x1, int *x2, int color )
{
	if(bMedDLeDrawing)	G_line(x1, x2, color);
}

//------------------------------------------------------------
// M e d D L e D r a w P o i n t

void MedDLeDrawPoint(int *x1, int color)
{
	if(bMedDLeDrawing)	G_dot(x1, color);
}

void MedDLeDrawSmallDot(int *x1, int color)
{
	if(bMedDLeDrawing)	G_smalldot(x1, color);
}

void MedDLeDrawMediumDot(int *x1, int color)
{
	if(bMedDLeDrawing)	G_meddot(x1, color);
}

void MedDLeDrawLargeDot(int *x1, int color)
{
	if(bMedDLeDrawing)	G_bigdot(x1, color);
}

//------------------------------------------------------------
// M e d D L e B e g i n O v e r l a y

BOOL MedDLeBeginOverlay(CDC* pDC)
{
	if(bMedDLeDrawing) return 0;

	MedDLeCDC = pDC;
	bMedDLeOverlaying=1;
	return 1;
}

//------------------------------------------------------------
// M e d D L e E n d O v e r l a y

void MedDLeEndOverlay()
{
	bMedDLeOverlaying=0;
}

//------------------------------------------------------------
// M e d D L e O v e r l a y L i n e

void MedDLeOverlayLine(int *x1, int *x2, COLORREF color, int width, BOOL bDash )
{
	if(bMedDLeOverlaying)
	{
		int nPenStyle;
		if(bDash) nPenStyle=PS_DASH;
		else nPenStyle = PS_SOLID;
		CPen pen(nPenStyle, width, color );
		CPen *old=MedDLeCDC->SelectObject(&pen);
		MedDLeCDC->MoveTo(x1[0], x1[1]);
		MedDLeCDC->LineTo(x2[0], x2[1]);
		MedDLeCDC->SelectObject(old);
	}
}

//------------------------------------------------------------
// M e d D L e O v e r l a y T e x t

void MedDLeOverlayText(int *x1, CString &str)
{
	if(bMedDLeOverlaying)
	{
		MedDLeCDC->TextOut(x1[0], x1[1], str);
	}
}


// end of all sensible things
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////
// Looking beyond this point may be hazardous to your health

//double BG_sin[256],BG_cos[256];                /* precalculated */

int G_start[1024];              /* polygon's */
int G_end[1024];                /* horizontal boundaries */
int G_miny,G_maxy;                          /* vertical boundaries */

#define G_P      10                         /* fixed point math prcision */
#define G_LINEAR 32                         /* linearely interpolate for */

int G_0_start[1024];  /* contains [32-G_P].[G_P] values */
int G_0_end[1024];    /* this thingie is to work faster */
int G_1_start[1024];  /* then multidimensional array */
int G_1_end[1024];    /* hope so, */
int G_2_start[1024];
int G_2_end[1024];
int G_3_start[1024];
int G_3_end[1024];

long G_ScreenSize;
long G_LineSize;
int G_ScreenWidth;
int G_ScreenHeight;
int G_ClipXMin, G_ClipYMin, G_ClipXMax, G_ClipYMax;       // clipping



int sgn (int a)
{
    if (a > 0)  return +1;
    if (a < 0)  return -1;
    return 0;
}

void BG_Clip (int x1, int y1, int x2, int y2)
{
	G_ClipXMin = x1;
	G_ClipYMin = y1;
	G_ClipXMax = x2;
	G_ClipYMax = y2;
}


#define FP_PREC 10

#define HW_set_char(dst,lng,val) memset(dst, val, lng);
#define HW_copy_int(src,dst,lng) memcpy(dst,src,lng*4)
void HW_set_int(int *dst,int lng, int val)
{ for(int cnt=0; cnt<lng; cnt++) dst[cnt]=val; }
int C_2D_clipping;                          /* type of performed clipping */
BYTE *G_buffer;                    /* the bitmap's bits */
WORD *G_buffer16;                    /* the bitmap's bits */
WORD *G_zbuffer;

int *G_rest_start[C_MAX_DIMENSIONS]={G_0_start,G_1_start,G_2_start,G_3_start};
int *G_rest_end[C_MAX_DIMENSIONS]={G_0_end,G_1_end,G_2_end,G_3_end};

int C_line_x_clipping(int **vertex1,int **vertex2,int dimension)
{
 register int i;
 register int whereto;
 register int *l,*r,*m,*t;                  /* left right and midle and tmp */
 static int g_store0[C_MAX_DIMENSIONS];     /* static stores for clipped vxes */
 static int g_store1[C_MAX_DIMENSIONS];
 static int g_store2[C_MAX_DIMENSIONS];
 static int g_store3[C_MAX_DIMENSIONS];
 static int g_store4[C_MAX_DIMENSIONS];
 static int g_store5[C_MAX_DIMENSIONS];
 int **vmn,**vmx;                           /* so that *vmn[0] < *vmx[0] */
 int swap;                                  /* were coordinates swaped? */

 C_2D_clipping=0;                           /* default no clipping yet */

 if((*vertex1)[0]<(*vertex2)[0])
 { swap=0; vmn=vertex1; vmx=vertex2; }      /* so that *vmn[0] < *vmx[0] */
 else
 { swap=1; vmn=vertex2; vmx=vertex1; }

 if(((*vmn)[0]>G_ClipXMax)||((*vmx)[0]<G_ClipXMin)) return(0);
 else
 {
  if((*vmn)[0]<=G_ClipXMin)           /* clipping */
  {
//	memcpy(l=g_store0,*vmn,dimension*4);
//	memcpy(m=g_store1,*vmx,dimension*4);
   HW_copy_int(*vmn,l=g_store0,dimension);  /* copying old vertices */
   HW_copy_int(*vmx,m=g_store1,dimension);
   r=g_store2;

   whereto=0;
   while(m[0]!=G_ClipXMin)
   {
	if(whereto==1) { t=l; l=m; m=t; }
	else           { t=r; r=m; m=t; }
	for(i=0;i<dimension;i++) m[i]=(l[i]+r[i])>>1;
	whereto=m[0]<G_ClipXMin;
   }
   *vmn=m;                                  /* that is why m[] is static */
   C_2D_clipping=swap^1;
  }

  if((*vmx)[0]>=G_ClipXMax)           /* clipping */
  {
   HW_copy_int(*vmn,l=g_store3,dimension);  /* copying old vertices */
   HW_copy_int(*vmx,m=g_store4,dimension);
   r=g_store5;

   whereto=0;
   while(m[0]!=G_ClipXMax)
	 {
	if(whereto==1) { t=l; l=m; m=t; }
	else           { t=r; r=m; m=t; }
	for(i=0;i<dimension;i++) m[i]=(l[i]+r[i])>>1;
	whereto=m[0]<G_ClipXMax;
   }
   *vmx=m;                                  /* that is why m[] is static */
   C_2D_clipping|=swap&1;
  }
 }
 return(1);                                 /* partialy or not clipped */
}


int C_line_y_clipping(int **vertex1,int **vertex2,int dimension)
{
 register int i;
 register int whereto;
 register int *l,*r,*m,*t;                  /* left right and midle and tmp */
 static int g_store0[C_MAX_DIMENSIONS];     /* static stores for clipped vxes */
 static int g_store1[C_MAX_DIMENSIONS];
 static int g_store2[C_MAX_DIMENSIONS];
 static int g_store3[C_MAX_DIMENSIONS];
 static int g_store4[C_MAX_DIMENSIONS];
 static int g_store5[C_MAX_DIMENSIONS];
 int **vmn,**vmx;                           /* so that *vmn[1] < *vmx[1] */
 int swap;                                  /* were coordinates swaped? */

 C_2D_clipping=0;                           /* default no clipping yet */

 if((*vertex1)[1]<(*vertex2)[1])
 { swap=0; vmn=vertex1; vmx=vertex2; }      /* so that *vmn[1] < *vmx[1] */
 else
 { swap=1; vmn=vertex2; vmx=vertex1; }

 if(((*vmn)[1]>G_ClipYMax)||((*vmx)[1]<G_ClipYMin)) return(0);
 else
 {
  if((*vmn)[1]<=G_ClipYMin)           /* clipping */
  {
   HW_copy_int(*vmn,l=g_store0,dimension);  /* copying old vertices */
   HW_copy_int(*vmx,m=g_store1,dimension);
   r=g_store2;

   whereto=0;
   while(m[1]!=G_ClipYMin)
   {
	if(whereto==1) { t=l; l=m; m=t; }
	else           { t=r; r=m; m=t; }
	for(i=0;i<dimension;i++) m[i]=(l[i]+r[i])>>1;
	whereto=m[1]<G_ClipYMin;
   }
   *vmn=m;                                  /* that is why m[] is static */
   C_2D_clipping=swap^1;
  }

  if((*vmx)[1]>=G_ClipYMax)           /* clipping */
  {
   HW_copy_int(*vmn,l=g_store3,dimension);  /* copying old vertices */
	 HW_copy_int(*vmx,m=g_store4,dimension);
   r=g_store5;

   whereto=0;
   while(m[1]!=G_ClipYMax)
   {
	if(whereto==1) { t=l; l=m; m=t; }
	else           { t=r; r=m; m=t; }
	for(i=0;i<dimension;i++) m[i]=(l[i]+r[i])>>1;
	whereto=m[1]<G_ClipYMax;
   }
   *vmx=m;                                  /* that is why m[] is static */
   C_2D_clipping|=swap&1;
  }
 }
 return(1);                                 /* partialy or not clipped */
}


int C_polygon_x_clipping(register int *from,register int *to,
						 int dimension,int length
						)
{
 register int i;
 int *v1,*v2,new_lng=0;
 int *first_vrtx=to;                        /* begining of the source */

 for(i=0;i<length;i++)                      /* for all edges */
 {
  v1=from; from+=dimension; v2=from;        /* taking two vertices */

  if(C_line_x_clipping(&v1,&v2,dimension))  /* clipping */
  {
   if(C_2D_clipping)                        /* depends which one was clipped */
   {
	HW_copy_int(v1,to,dimension); to+=dimension;
	HW_copy_int(v2,to,dimension); to+=dimension;
	new_lng+=2;                             /* first point clipped */
   }
   else
   {
	HW_copy_int(v2,to,dimension); to+=dimension;
	new_lng++;                              /* second point clipped */
   }
  }
 }
 HW_copy_int(first_vrtx,to,dimension);      /* looping the polygon vertices */

 return(new_lng);
}


void G_clear(int c)
{
 HW_set_char((int*)G_buffer,G_ScreenWidth*G_ScreenHeight,(unsigned)c);
}

void G_dot(int *vertex,unsigned char colour)
{
 if( (vertex[0]>=0)&&(vertex[0]<G_ScreenWidth) &&
     (vertex[1]>=0)&&(vertex[1]<G_ScreenHeight) )
 {
  G_buffer[vertex[1]*G_ScreenWidth+vertex[0]]=colour;
 }
}

void G_smalldot(int *vertex,unsigned char colour)
{
	for(int j=-1; j<=1; j++)
	{
		for(int i=-1; i<=1; i++)
		{
		if( (vertex[0]+i>=0)&&(vertex[0]+i<G_ScreenWidth) &&(vertex[1]+j>=0)&&(vertex[1]+j<G_ScreenHeight) )
			G_buffer[(vertex[1]+j)*G_ScreenWidth+vertex[0]+i]=colour;
		}
	}
}

void G_meddot(int *vertex,unsigned char colour)
{
	for(int j=-2; j<=2; j++)
	{
		for(int i=-2; i<=2; i++)
		{
		if( (vertex[0]+i>=0)&&(vertex[0]+i<G_ScreenWidth) &&(vertex[1]+j>=0)&&(vertex[1]+j<G_ScreenHeight) )
			G_buffer[(vertex[1]+j)*G_ScreenWidth+vertex[0]+i]=colour;
		}
	}
}
void G_bigdot(int *vertex,unsigned char colour)
{
	for(int j=-3; j<=3; j++)
	{
		for(int i=-3; i<=3; i++)
		{
		if( (vertex[0]+i>=0)&&(vertex[0]+i<G_ScreenWidth) &&(vertex[1]+j>=0)&&(vertex[1]+j<G_ScreenHeight) )
			G_buffer[(vertex[1]+j)*G_ScreenWidth+vertex[0]+i]=colour;
		}
	}
}

void G_plusdot(int *vertex,unsigned char colour)
{
	int i,j;
	i=0; j=0;
	if( (vertex[0]+i>=0)&&(vertex[0]+i<G_ScreenWidth) &&(vertex[1]+j>=0)&&(vertex[1]+j<G_ScreenHeight) )
		G_buffer[(vertex[1]+j)*G_ScreenWidth+vertex[0]+i]=colour;
	i=-1; j=0;
	if( (vertex[0]+i>=0)&&(vertex[0]+i<G_ScreenWidth) &&(vertex[1]+j>=0)&&(vertex[1]+j<G_ScreenHeight) )
		G_buffer[(vertex[1]+j)*G_ScreenWidth+vertex[0]+i]=colour;
	i=1; j=0;
	if( (vertex[0]+i>=0)&&(vertex[0]+i<G_ScreenWidth) &&(vertex[1]+j>=0)&&(vertex[1]+j<G_ScreenHeight) )
		G_buffer[(vertex[1]+j)*G_ScreenWidth+vertex[0]+i]=colour;
	i=0; j=1;
	if( (vertex[0]+i>=0)&&(vertex[0]+i<G_ScreenWidth) &&(vertex[1]+j>=0)&&(vertex[1]+j<G_ScreenHeight) )
		G_buffer[(vertex[1]+j)*G_ScreenWidth+vertex[0]+i]=colour;
	i=0; j=-1;
	if( (vertex[0]+i>=0)&&(vertex[0]+i<G_ScreenWidth) &&(vertex[1]+j>=0)&&(vertex[1]+j<G_ScreenHeight) )
		G_buffer[(vertex[1]+j)*G_ScreenWidth+vertex[0]+i]=colour;
}
void G_xdot(int *vertex,unsigned char colour)
{
	int i,j;
	i=0; j=0;
	if( (vertex[0]+i>=0)&&(vertex[0]+i<G_ScreenWidth) &&(vertex[1]+j>=0)&&(vertex[1]+j<G_ScreenHeight) )
		G_buffer[(vertex[1]+j)*G_ScreenWidth+vertex[0]+i]=colour;
	i=-1; j=-1;
	if( (vertex[0]+i>=0)&&(vertex[0]+i<G_ScreenWidth) &&(vertex[1]+j>=0)&&(vertex[1]+j<G_ScreenHeight) )
		G_buffer[(vertex[1]+j)*G_ScreenWidth+vertex[0]+i]=colour;
	i=1; j=1;
	if( (vertex[0]+i>=0)&&(vertex[0]+i<G_ScreenWidth) &&(vertex[1]+j>=0)&&(vertex[1]+j<G_ScreenHeight) )
		G_buffer[(vertex[1]+j)*G_ScreenWidth+vertex[0]+i]=colour;
	i=-1; j=1;
	if( (vertex[0]+i>=0)&&(vertex[0]+i<G_ScreenWidth) &&(vertex[1]+j>=0)&&(vertex[1]+j<G_ScreenHeight) )
		G_buffer[(vertex[1]+j)*G_ScreenWidth+vertex[0]+i]=colour;
	i=1; j=-1;
	if( (vertex[0]+i>=0)&&(vertex[0]+i<G_ScreenWidth) &&(vertex[1]+j>=0)&&(vertex[1]+j<G_ScreenHeight) )
		G_buffer[(vertex[1]+j)*G_ScreenWidth+vertex[0]+i]=colour;
}

void G_line(int *vertex1,int *vertex2,unsigned char colour)
{
 register int inc_ah,inc_al;
 register int i;
 register unsigned char *adr=G_buffer;
 int *v1,*v2;
 int dx,dy,long_d,short_d;
 int d,add_dh,add_dl;
 int inc_xh,inc_yh,inc_xl,inc_yl;

 v1=vertex1;
 v2=vertex2;

 if(C_line_x_clipping(&v1,&v2,2))
 {
  if(C_line_y_clipping(&v1,&v2,2))
  {
   dx=v2[0]-v1[0]; dy=v2[1]-v1[1];

   if(dx<0){dx=-dx; inc_xh=-1; inc_xl=-1;}
   else    {        inc_xh=1;  inc_xl=1; }

   if(dy<0){dy=-dy;inc_yh=-G_ScreenWidth;
				   inc_yl=-G_ScreenWidth;
		   }
   else    {       inc_yh= G_ScreenWidth;
				   inc_yl= G_ScreenWidth;
		   }
   if(dx>dy){long_d=dx;short_d=dy;inc_yl=0;}
   else     {long_d=dy;short_d=dx;inc_xl=0;}

   inc_ah=inc_xh+inc_yh;
   inc_al=inc_xl+inc_yl;
	 adr+=v1[1]*G_ScreenWidth+v1[0];

   d=2*short_d-long_d;
   add_dl=2*short_d;
   add_dh=2*short_d-2*long_d;

   for(i=0;i<=long_d;i++)
   {
	*adr=colour;
	if(d>=0){adr+=inc_ah; d+=add_dh;}
	else    {adr+=inc_al; d+=add_dl;}
   }
  }
 }
}


void GI_scan(int *edges,int dimension,int skip)
{
 int cur_v[C_MAX_DIMENSIONS];     /* initial values for Z+ dims */
 int inc_v[C_MAX_DIMENSIONS];     /* increment for Z+ dimensions */
 int tmp;
 int dx,dy,long_d,short_d;
 register int d,add_dh,add_dl;              
 register int inc_xh,inc_yh,inc_xl,inc_yl;  
 int x,y,i,j;
 int *v1,*v2;                               /* first and second vertices */

 v1=edges; edges+=skip; v2=edges;           /* length ints in each */

 if(C_line_y_clipping(&v1,&v2,dimension))   /* vertical clipping */
 {
  dx=*v2++; dy=*v2++;                       /* extracting 2-D coordinates */
  x=*v1++; y=*v1++;                         /* v2/v1 point remaining dim-2 */
  dimension-=2; 

  if(y<G_miny) G_miny=y;
  if(y>G_maxy) G_maxy=y;
  if(dy<G_miny) G_miny=dy;
  if(dy>G_maxy) G_maxy=dy;                  /* updating vertical size */

	dx-=x; dy-=y;                             /* ranges */

  if(dx<0){dx=-dx; inc_xh=-1; inc_xl=-1;}   /* making sure dx and dy >0 */
  else    {        inc_xh=1;  inc_xl=1; }   /* adjusting increments */
  if(dy<0){dy=-dy; inc_yh=-1; inc_yl=-1;}
  else    {        inc_yh=1;  inc_yl=1; }

  if(dx>dy){long_d=dx;short_d=dy;inc_yl=0;} /* long range,&making sure either */
  else     {long_d=dy;short_d=dx;inc_xl=0;} /* x or y is changed in L case */

  d=2*short_d-long_d;                       /* initial value of d */
  add_dl=2*short_d;                         /* d adjustment for H case */
  add_dh=2*short_d-2*long_d;                /* d adjustment for L case */

  for(i=0;i<dimension;i++)                  /* for all remaining dimensions */
  {
   tmp=v1[i]; tmp<<=G_P; cur_v[i]=tmp;      /* f.p. start value */
   tmp=v2[i]-v1[i]; tmp<<=G_P;              /* f.p. increment */
   if(long_d>0) inc_v[i]=tmp/long_d;        /* if needed (non 0 lines) */
  }

  for(i=0;i<=long_d;i++)                    /* for all points in longer range */
  {
   if(x<G_start[y])                         /* further then rightmost */
   {
    G_start[y]=x;                           /* the begining of scan line */
    for(j=0;j<dimension;j++)
     G_rest_start[j][y]=cur_v[j];            /* all other dimensions */
   }

   if(G_end[y]<x)                           /* further the leftmost */
   {
    G_end[y]=x;                             /* the end of scan line */
    for(j=0;j<dimension;j++)
		 G_rest_end[j][y]=cur_v[j];              /* and for other dimension */
   }

   if(d>=0){x+=inc_xh;y+=inc_yh;d+=add_dh;} /* previous point was H type */
   else    {x+=inc_xl;y+=inc_yl;d+=add_dl;} /* previous point was L type */
   for(j=0;j<dimension;j++) 
    cur_v[j]+=inc_v[j];                     /* for all other dimensions */
  }
 }
}


void GI_boarder_array_init(void)
{
 G_miny=INT_MAX;                            /* polygon starts here */
 G_maxy=INT_MIN;                            /* polygon ends here */

 HW_set_int((int *)G_start,G_ScreenHeight,INT_MAX);
 HW_set_int((int *)G_end,G_ScreenHeight,INT_MIN);/* limiting values */
}

BOOL G_hit_polygon(int *edges,int length, POINT pt)
{
//	int new_edges[G_MAX_TUPLES];               /* verticaly clipped polygon */
//	int new_length;                            /* although no edges there yet */
	//register unsigned char *l_adr,*adr;
	//register int y0, y1, x0, x1;
	register int beg,end,i;

	GI_boarder_array_init();                   /* initializing the arrays */

	new_length=C_polygon_x_clipping(edges,new_edges,2,length);

	for(i=0;i<new_length;i++) GI_scan(&new_edges[i*2],2,2);             /* Searching polygon boarders */

	if(G_miny<=G_maxy)                         /* nothing to do? */
	{
		for(; G_miny<=G_maxy; G_miny++)              /* rendering all lines */
		{
			beg=G_start[G_miny];         /* addr of the current line */
			end=G_end[G_miny]+1;                 /* ends here */
			if((pt.x<=end)&&(pt.x>=beg)&&(pt.y==G_miny)) return TRUE;
		}
	}
	return FALSE;
}


void G_ambient_polygon(int *edges,int length,unsigned char colour)
{
 //int new_edges[G_MAX_TUPLES];               /* verticaly clipped polygon */
 //int new_length;                            /* although no edges there yet */
 register unsigned char *l_adr,*adr;
 register int beg,end,i;

 GI_boarder_array_init();                   /* initializing the arrays */

 new_length=C_polygon_x_clipping(edges,new_edges,2,length);

 for(i=0;i<new_length;i++)
  GI_scan(&new_edges[i*2],2,2);             /* Searching polygon boarders */

 if(G_miny<=G_maxy)                         /* nothing to do? */
 {
 l_adr=G_buffer+G_miny*G_ScreenWidth;   /* addr of 1st byte of 1st line */

  for(; G_miny<=G_maxy; G_miny++,
      l_adr+=G_ScreenWidth)              /* rendering all lines */
  {
   adr=l_adr+(beg=G_start[G_miny]);         /* addr of the current line */
   end=G_end[G_miny]-beg+1;                 /* ends here */
//
   HW_set_char((char*)adr,end,colour);      /* rendering single line */
  }
}
}


void G_shaded_polygon(int *edges,int length)
{
 //int new_edges[G_MAX_SHADED_TUPLES];        /* verticaly clipped polygon */
 //int new_length;
 register unsigned char *l_adr,*adr;
 register int beg,end,i;
 register int cur_c,inc_c;        /* current colour and it's inc */

 GI_boarder_array_init();                   /* initializing the array */

 new_length=C_polygon_x_clipping(edges,new_edges,3,length);

 for(i=0;i<new_length;i++)
	GI_scan(&new_edges[i*3],3,3);             /* Searching polygon boarders */

 if(G_miny<=G_maxy)                         /* nothing to do? */
 {
	l_adr=G_buffer+G_miny*G_ScreenWidth;   /* addr of 1st byte of 1st line */

	for(; G_miny<=G_maxy; G_miny++,
			l_adr+=G_ScreenWidth)              /* rendering all lines */
	{
	 adr=l_adr+(beg=G_start[G_miny]);         /* addr of the current line */
	 end=G_end[G_miny];                       /* ends here */

	 cur_c=G_0_start[G_miny];                 /* colour starts with this value */
	 inc_c=G_0_end[G_miny]-cur_c;
	 if(end>beg) inc_c/=end-beg+1;            /* f.p. increment */

	 for(;beg<=end;beg++)                     /* render this lines */
	 {
		*adr++=cur_c>>G_P;                      /* rendering single point */
		cur_c+=inc_c;                           /* incrementing colour */
	 }
	}
 }
}


void G_textured_polygon(int *edges,int length, unsigned char *bitmap, unsigned bitmapw)
{
 //int new_edges[G_MAX_SHADED_TUPLES];        /* verticaly clipped polygon */
 //int new_length;
 register unsigned char *l_adr,*adr;
 register int beg,end,i;
 register int cur_u,inc_u;        /* current colour and it's inc */
 register int cur_v,inc_v;        /* current colour and it's inc */

 GI_boarder_array_init();                   /* initializing the array */

 new_length=C_polygon_x_clipping(edges,new_edges,4,length);

 for(i=0;i<new_length;i++)
	GI_scan(&new_edges[i*4],4,4);             /* Searching polygon boarders */

 if(G_miny<=G_maxy)                         /* nothing to do? */
 {
	l_adr=G_buffer+G_miny*G_ScreenWidth;   /* addr of 1st byte of 1st line */

	for(; G_miny<=G_maxy; G_miny++,
			l_adr+=G_ScreenWidth)              /* rendering all lines */
	{
	 adr=l_adr+(beg=G_start[G_miny]);         /* addr of the current line */
	 end=G_end[G_miny];                       /* ends here */

	 cur_u=G_0_start[G_miny];                 /* colour starts with this value */
	 inc_u=G_0_end[G_miny]-cur_u;
	 if(end>beg) inc_u/=end-beg+1;            /* f.p. increment */

	 cur_v=G_1_start[G_miny];                 /* colour starts with this value */
	 inc_v=G_1_end[G_miny]-cur_v;
	 if(end>beg) inc_v/=end-beg+1;            /* f.p. increment */

	 int ccolor;
	 for(;beg<=end;beg++)                     /* render this lines */
	 {
		ccolor=bitmap[(cur_u>>G_P)+(cur_v>>G_P)*bitmapw];
/*		if((ccolor>=96)&&(ccolor<112))
		{
			if(bcolor<8)
				ccolor+=bcolor*16-96;
			else {
				ccolor-=96;
				ccolor=15-ccolor;
				ccolor+=bcolor*16;
				}
		}
		else if((ccolor>=16)&&(ccolor<32))
		{
			if(tcolor<8)
				ccolor+=tcolor*16-16;
			else {
				ccolor-=16;
				ccolor=15-ccolor;
				ccolor+=tcolor*16;
				}
		}
		*/
 //		*adr++=bitmap[(cur_u>>G_P)+(cur_v>>G_P)*bitmapw];                      /* rendering single point */
		*adr++=ccolor;                      /* rendering single point */
		cur_u+=inc_u;                           /* incrementing colour */
		cur_v+=inc_v;                           /* incrementing colour */
	 }
	}
 }
}

void G_gtex_poly(int *edges,int length, unsigned char *bitmap, unsigned bitmapw)
{
 //int new_edges[G_MAX_SHADED_TUPLES];        /* verticaly clipped polygon */
// int new_length;
 register unsigned char *l_adr,*adr;
 register int beg,end,i;
 register int cur_u,inc_u;        /* current colour and it's inc */
 register int cur_v,inc_v;        /* current colour and it's inc */
 register int cur_c,inc_c;        /* current colour and it's inc */

 GI_boarder_array_init();                   /* initializing the array */

 new_length=C_polygon_x_clipping(edges,new_edges,5,length);

 for(i=0;i<new_length;i++)
	GI_scan(&new_edges[i*5],5,5);             /* Searching polygon boarders */

 if(G_miny<=G_maxy)                         /* nothing to do? */
 {
	l_adr=G_buffer+G_miny*G_ScreenWidth;   /* addr of 1st byte of 1st line */

	for(; G_miny<=G_maxy; G_miny++,
			l_adr+=G_ScreenWidth)              /* rendering all lines */
	{
	 adr=l_adr+(beg=G_start[G_miny]);         /* addr of the current line */
	 end=G_end[G_miny];                       /* ends here */

	 cur_u=G_0_start[G_miny];                 /* colour starts with this value */
	 inc_u=G_0_end[G_miny]-cur_u;
	 if(end>beg) inc_u/=end-beg+1;            /* f.p. increment */

	 cur_v=G_1_start[G_miny];                 /* colour starts with this value */
	 inc_v=G_1_end[G_miny]-cur_v;
	 if(end>beg) inc_v/=end-beg+1;            /* f.p. increment */

	 cur_c=G_2_start[G_miny];                 /* colour starts with this value */
	 inc_c=G_2_end[G_miny]-cur_c;
	 if(end>beg) inc_c/=end-beg+1;            /* f.p. increment */

	int ccolor;
	 for(;beg<=end;beg++)                     /* render this lines */
	 {

		ccolor=bitmap[(cur_u>>G_P)+(cur_v>>G_P)*bitmapw];
/*		if((ccolor>=96)&&(ccolor<112))
		 {
				if(bcolor<8)
					ccolor+=bcolor*16-96;
				else {
					ccolor-=96;
					ccolor=15-ccolor;
					ccolor+=bcolor*16;
					}
			}
			else if((ccolor>=16)&&(ccolor<32))
			{
				if(tcolor<8)
					ccolor+=tcolor*16-16;
				else {
					ccolor-=16;
					ccolor=15-ccolor;
					ccolor+=tcolor*16;
					}
			}
*/
		//		*adr++=MedDLeCMap[bitmap[(cur_u>>G_P)+(cur_v>>G_P)*bitmapw]+256*(cur_c>>G_P)];//+cur_c>>G_P;                      /* rendering single point */
		*adr++=MedDLeCMap[ccolor+256*(cur_c>>G_P)];//+cur_c>>G_P;                      /* rendering single point */
		cur_u+=inc_u;                           /* incrementing colour */
		cur_v+=inc_v;                           /* incrementing colour */
		cur_c+=inc_c;                           /* incrementing colour */
	 }
	}
 }
}

void G_hilight_polygon(int *edges,int length, unsigned char colour)
{
// BYTE depth=33;
 //int new_edges[G_MAX_TUPLES];        /* verticaly clipped polygon */
// int new_length;
 register unsigned char *l_adr,*adr;
 register int beg,end,i;
 register int cur_c;        /* current colour and it's inc */

 GI_boarder_array_init();                   /* initializing the array */

 new_length=C_polygon_x_clipping(edges,new_edges,2,length);

 for(i=0;i<new_length;i++)
	GI_scan(&new_edges[i*2],2,2);             /* Searching polygon boarders */

// colour*=16;

 if(G_miny<=G_maxy)                         /* nothing to do? */
 {
	l_adr=G_buffer+G_miny*G_ScreenWidth;   /* addr of 1st byte of 1st line */

	for(; G_miny<=G_maxy; G_miny++,
			l_adr+=G_ScreenWidth)              /* rendering all lines */
	{
	 adr=l_adr+(beg=G_start[G_miny]);         /* addr of the current line */
	 end=G_end[G_miny];                       /* ends here */


	 for(;beg<=end;beg++)                     /* render this lines */
	 {
		 cur_c=*adr;
		 cur_c=MedDLeCMap[cur_c+256*colour];
		*adr++=cur_c;                      /* rendering single point */
	 }
	}
 }
}


void G_colored_glass_polygon(int *edges,int length, unsigned char colour, BYTE depth)
{
 //int new_edges[G_MAX_TUPLES];        /* verticaly clipped polygon */
// int new_length;
 register unsigned char *l_adr,*adr;
 register int beg,end,i;
 register int cur_c,inc_c;        /* current colour and it's inc */

 GI_boarder_array_init();                   /* initializing the array */

 new_length=C_polygon_x_clipping(edges,new_edges,2,length);

 for(i=0;i<new_length;i++)
	GI_scan(&new_edges[i*2],2,2);             /* Searching polygon boarders */

 colour*=16;

 if(G_miny<=G_maxy)                         /* nothing to do? */
 {
	l_adr=G_buffer+G_miny*G_ScreenWidth;   /* addr of 1st byte of 1st line */

	for(; G_miny<=G_maxy; G_miny++,
			l_adr+=G_ScreenWidth)              /* rendering all lines */
	{
	 adr=l_adr+(beg=G_start[G_miny]);         /* addr of the current line */
	 end=G_end[G_miny];                       /* ends here */


	 for(;beg<=end;beg++)                     /* render this lines */
	 {
		 cur_c=*adr;

		 inc_c=cur_c/16;
		 cur_c=cur_c%16;
		if(inc_c>8)
			cur_c=15-cur_c;
		
		cur_c=MedDLeCMap[colour+cur_c+256*depth];
		*adr++=cur_c;                      /* rendering single point */
	 }
	}
 }
}

void Gz_gtex_poly(int *edges,int length, unsigned char *bitmap, unsigned bitmapw)
{
 register unsigned char *l_adr,*adr;
 register WORD *zl_adr,*zadr;
 register int beg,end,i;
 register int cur_u,inc_u;        /* current colour and it's inc */
 register int cur_v,inc_v;        /* current colour and it's inc */
 register int cur_c,inc_c;        /* current colour and it's inc */
 register unsigned cur_z,inc_z;        /* current colour and it's inc */

 GI_boarder_array_init();                   /* initializing the array */

 new_length=C_polygon_x_clipping(edges,new_edges,6,length);

 for(i=0;i<new_length;i++)
	GI_scan(&new_edges[i*6],6,6);             /* Searching polygon boarders */

 if(G_miny<=G_maxy)                         /* nothing to do? */
 {
	l_adr=G_buffer+G_miny*G_ScreenWidth;   /* addr of 1st byte of 1st line */
	zl_adr=G_zbuffer+G_miny*G_ScreenWidth;   /* addr of 1st byte of 1st line */

	for(; G_miny<=G_maxy; G_miny++,
			l_adr+=G_ScreenWidth,zl_adr+=G_ScreenWidth)              /* rendering all lines */
	{
	 adr=l_adr+(beg=G_start[G_miny]);         /* addr of the current line */
	 zadr=zl_adr+G_start[G_miny];   /* addr of 1st byte of 1st line */
	 end=G_end[G_miny];                       /* ends here */
	 

	 cur_u=G_0_start[G_miny];                 /* colour starts with this value */
	 inc_u=G_0_end[G_miny]-cur_u;
	 if(end>beg) inc_u/=end-beg+1;            /* f.p. increment */

	 cur_v=G_1_start[G_miny];                 /* colour starts with this value */
	 inc_v=G_1_end[G_miny]-cur_v;
	 if(end>beg) inc_v/=end-beg+1;            /* f.p. increment */

	 cur_c=G_2_start[G_miny];                 /* colour starts with this value */
	 inc_c=G_2_end[G_miny]-cur_c;
	 if(end>beg) inc_c/=end-beg+1;            /* f.p. increment */

	 cur_z=G_3_start[G_miny];                 /* colour starts with this value */
	 inc_z=G_3_end[G_miny]-cur_z;
	 if(end>beg) inc_z/=end-beg+1;            /* f.p. increment */

	 int ccolor;
	 for(;beg<=end;beg++)                     /* render this lines */
	 {
		if(cur_z<*zadr)
		{
		ccolor=bitmap[(cur_u>>G_P)+(cur_v>>G_P)*bitmapw];
/*		if((ccolor>=96)&&(ccolor<112))
		 {
				if(bcolor<8)
					ccolor+=bcolor*16-96;
				else {
					ccolor-=96;
					ccolor=15-ccolor;
					ccolor+=bcolor*16;
					}
			}
			else if((ccolor>=16)&&(ccolor<32))
			{
				if(tcolor<8)
					ccolor+=tcolor*16-16;
				else {
					ccolor-=16;
					ccolor=15-ccolor;
					ccolor+=tcolor*16;
					}
			}
			*/
		*zadr=cur_z;
//		*adr++=MedDLeCMap[bitmap[(cur_u>>G_P)+(cur_v>>G_P)*bitmapw]+256*(cur_c>>G_P)];//+cur_c>>G_P;                      /* rendering single point */
		*adr=MedDLeCMap[ccolor+256*(cur_c>>G_P)];//+cur_c>>G_P;                      /* rendering single point */
		//*adr=cur_z/10000;//+cur_c>>G_P;                      /* rendering single point */
		}
		adr++;
		zadr++;
		cur_u+=inc_u;                           /* incrementing colour */
		cur_v+=inc_v;                           /* incrementing colour */
		cur_c+=inc_c;                           /* incrementing colour */
		cur_z+=inc_z;                           /* incrementing colour */
	 }
	}
 }

}
