// BaseToolDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "BaseToolDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBaseToolDlg dialog


CBaseToolDlg::CBaseToolDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CBaseToolDlg::IDD, pParent)
{
	m_bActive=-1;
	m_pChild=0;
	//{{AFX_DATA_INIT(CBaseToolDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CBaseToolDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBaseToolDlg)
	DDX_Control(pDX, IDC_TITAREA, m_TitleArea);
	DDX_Control(pDX, IDC_MINMAX, m_btnMinMax);
	DDX_Control(pDX, IDC_HIDE, m_btnHide);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CBaseToolDlg, CDialog)
	//{{AFX_MSG_MAP(CBaseToolDlg)
	ON_BN_CLICKED(IDC_HIDE, OnHide)
	ON_BN_CLICKED(IDC_MINMAX, OnMinmax)
	ON_WM_CLOSE()
	ON_WM_PAINT()
	ON_WM_NCHITTEST()
	ON_WM_ENABLE()
	ON_WM_MOUSEACTIVATE()
	ON_WM_WINDOWPOSCHANGING()
	ON_WM_WINDOWPOSCHANGED()
	ON_WM_SHOWWINDOW()
	ON_WM_ACTIVATE()
	ON_WM_SETFOCUS()
	ON_WM_CAPTURECHANGED()
	ON_WM_ENTERIDLE()
	ON_WM_KILLFOCUS()
	ON_WM_LBUTTONDOWN()
	ON_WM_MOVING()
	ON_WM_MOVE()
	ON_WM_NCACTIVATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBaseToolDlg message handlers

void CBaseToolDlg::OnHide() 
{
	ShowWindow(SW_HIDE);
}

void CBaseToolDlg::OnMinmax() 
{
	if(m_bSmall)
	{
		SetWindowPos(NULL,0,0,m_rcBig.Width(),m_rcBig.Height(),SWP_NOMOVE|SWP_NOOWNERZORDER);
		m_btnMinMax.SetBitmap(LoadBitmap( AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_MAX)));
		m_btnMinMax.m_bMakeBMP=1;
		m_bSmall=0;
	}
	else
	{
		SetWindowPos(NULL,0,0,m_rcSmall.Width(),m_rcSmall.Height(),SWP_NOMOVE|SWP_NOOWNERZORDER);
		m_btnMinMax.SetBitmap(LoadBitmap( AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_MIN)));
		m_btnMinMax.m_bMakeBMP=1;
		m_bSmall=1;
	}
	
}

BOOL CBaseToolDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();


// button
	m_btnHide.SetBitmap(LoadBitmap( AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_CLOSE)));
	m_btnMinMax.SetBitmap(LoadBitmap( AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_MAX)));
	m_btnHide.m_clrTransparent=RGB(255,255,255);
	m_btnMinMax.m_clrTransparent=RGB(255,255,255);
	m_btnHide.m_bTransparent=1;
	m_btnMinMax.m_bTransparent=1;
//	m_btnHide.m_bBackground=1;
//	m_btnMinMax.m_bBackground=1;
//	ActivateButtons(0);


	mmouse.x=-1;
	mmouse.y=-1;
	if(m_strTitle.IsEmpty()) m_strTitle="meddle";

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CBaseToolDlg::ConstructDlg()
{
	int x,y;
	int W=0,H=0;

	CRect rc;
	CRect rcw;
	
	GetWindowRect(rcw);
	GetClientRect(rc);
	int w,h,X,Y;
	w=rcw.Width()-rc.Width();
	h=rcw.Height()-rc.Height();

	m_TitleArea.GetWindowRect(rc);
	ScreenToClient(&rc);

	y=rc.bottom+1;
	X=rc.Width();
	Y=y;

//	ShowWindow(SW_HIDE);
//	SetWindowPos(NULL,0,0,0,0,SWP_NOMOVE | SWP_NOZORDER | SWP_NOSIZE | SWP_HIDEWINDOW);
	
	if(m_pChild)
	{
		m_pChild->SetWindowPos(NULL,0,y,0,0,
			SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE);
		m_pChild->GetClientRect(rc);
		Y=y+rc.Height();
		X=rc.Width();
		
	}

	SetWindowPos(NULL,0,0,X+w,Y+h, 
		SWP_NOMOVE | SWP_NOZORDER |SWP_HIDEWINDOW);

	m_bSmall=0;
	GetWindowRect(&m_rcBig);
	CRect client;

	GetClientRect(&client);

	m_rcSmall=m_rcBig;
	m_rcSmall.bottom=m_rcSmall.top+y+h-1;

}
void CBaseToolDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CBaseToolDlg::ActivateButtons(BOOL b) 
{
	if(b)
	{
		m_btnHide.m_clrBackground=GetSysColor(COLOR_ACTIVECAPTION );
		m_btnMinMax.m_clrBackground=GetSysColor(COLOR_ACTIVECAPTION );
	}
	else
	{
		m_btnHide.m_clrBackground=GetSysColor(COLOR_INACTIVECAPTION );
		m_btnMinMax.m_clrBackground=GetSysColor(COLOR_INACTIVECAPTION );
	}

}


void CBaseToolDlg::OnOK() 
{
	// TODO: Add extra validation here
	
	CDialog::OnOK();
}

void CBaseToolDlg::OnClose() 
{
	
	CDialog::OnClose();
}

BOOL CBaseToolDlg::Create(CWnd* pParentWnd, LPCSTR title) 
{
	BOOL r=CDialog::Create(IDD, pParentWnd);
	SetWindowText(title);
	return r; 
}


void CBaseToolDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	CRect rc;
	m_TitleArea.GetWindowRect(rc);
	ScreenToClient(&rc);
	
	if(m_bActive)//GetForegroundWindow()==this)
	{
		DrawCaption(m_hWnd,dc.m_hDC,&rc,DC_ACTIVE|DC_SMALLCAP|DC_TEXT);
	}
	else
	{
		DrawCaption(m_hWnd,dc.m_hDC,&rc,DC_SMALLCAP|DC_TEXT);
	}
	// TODO: Add your message handler code here
	// Do not call CDialog::OnPaint() for painting messages
}

UINT CBaseToolDlg::OnNcHitTest(CPoint point) 
{
	CRect rc;
	m_TitleArea.GetWindowRect(rc);
	if(rc.PtInRect(point)) 
	{
		mmouse.x=-1;
		mmouse.y=-1;

		return HTCAPTION;
	}
	else return CDialog::OnNcHitTest(point);
}

void CBaseToolDlg::OnEnable(BOOL bEnable) 
{
	CDialog::OnEnable(bEnable);
	
	
}

int CBaseToolDlg::OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message) 
{

	return CDialog::OnMouseActivate(pDesktopWnd, nHitTest, message);
}

void CBaseToolDlg::OnWindowPosChanging(WINDOWPOS FAR* lpwndpos) 
{
	CDialog::OnWindowPosChanging(lpwndpos);
//	MessageBeep(MB_ICONEXCLAMATION);
	
}

void CBaseToolDlg::OnWindowPosChanged(WINDOWPOS FAR* lpwndpos) 
{
	CDialog::OnWindowPosChanged(lpwndpos);
	
}

void CBaseToolDlg::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	int f=0;
//	CRect rc;
//	m_TitleArea.GetWindowRect(&rc);
//	ScreenToClient(&rc);
//	if(!IsWindowVisible()) f=1;
//	if(m_pChild && bShow) m_pChild->ShowWindow(SW_SHOWNOACTIVATE);
	CDialog::OnShowWindow(bShow, nStatus);
//	if(m_pChild && bShow) m_pChild->ShowWindow(SW_SHOW);
//	if(IsWindowEnabled() && f && IsWindowVisible() && (m_bActive==0) && (bShow==TRUE))
//	{
//		m_bActive=1;
//		RedrawWindow( &rc, NULL, RDW_INVALIDATE | RDW_UPDATENOW ); 
//	}
	
}

void CBaseToolDlg::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized) 
{

	CDialog::OnActivate(nState, pWndOther, bMinimized);
	

}

void CBaseToolDlg::OnSetFocus(CWnd* pOldWnd) 
{

	//AfxMessageBox("K");
	InvalidateRect(NULL,0);
	PostMessage(WM_PAINT,(WPARAM)GetDC()->m_hDC,0);
	CDialog::OnSetFocus(pOldWnd);
	
}

void CBaseToolDlg::OnCaptureChanged(CWnd *pWnd) 
{
	// TODO: Add your message handler code here
	
	CDialog::OnCaptureChanged(pWnd);
}

void CBaseToolDlg::OnEnterIdle(UINT nWhy, CWnd* pWho) 
{
	CDialog::OnEnterIdle(nWhy, pWho);
	
	// TODO: Add your message handler code here
	
}

void CBaseToolDlg::OnKillFocus(CWnd* pNewWnd) 
{
	CDialog::OnKillFocus(pNewWnd);
	
}

void CBaseToolDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	
	CDialog::OnLButtonDown(nFlags, point);
}

void CBaseToolDlg::OnMoving(UINT fwSide, LPRECT pRect) 
{

	CWnd *p=GetParent();
	CRect prc;
	p->GetWindowRect(&prc);

	CPoint pt;
	GetCursorPos(&pt);
	int tol=20;
	int x;

	if(mmouse.x==-1)
	{
		mmouse.x=pt.x;
		mmouseoff.x=pt.x-pRect->left;
	}
	if(mmouse.y==-1)
	{
		mmouse.y=pt.y;
		mmouseoff.y=pt.y-pRect->top;
	}

	
	if(abs(x=(pt.x-mmouseoff.x)+(pRect->right-pRect->left) - prc.right) < tol)
	{	
		pRect->left=prc.right-(pRect->right-pRect->left);
		pRect->right=prc.right;
	}
	else  if(abs(x=(pt.x-mmouseoff.x) - prc.left) < tol)
	{
		pRect->right=prc.left+(pRect->right-pRect->left);
		pRect->left=prc.left;
	}
	else
	{
		pRect->right=pt.x-mmouseoff.x+(pRect->right-pRect->left);
		pRect->left=pt.x-mmouseoff.x;
	}

	CDialog::OnMoving(fwSide, pRect);
	
}

void CBaseToolDlg::OnMove(int x, int y) 
{
	CDialog::OnMove(x, y);

	CRect rc;
	GetWindowRect(&rc);
	
}

BOOL CBaseToolDlg::OnNcActivate(BOOL bActive) 
{
	CRect rc;
	m_TitleArea.GetWindowRect(&rc);
	ScreenToClient(&rc);

	if(IsWindowEnabled() && IsWindowVisible() &&(m_bActive!=bActive))
	{
		m_bActive=bActive;
		RedrawWindow( &rc, NULL, RDW_INVALIDATE | RDW_UPDATENOW ); 
	}
	return CDialog::OnNcActivate(bActive);
}
