/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;

public class MDLViewCanvas
extends Canvas
implements Runnable {
    boolean rotating = false;
    int degsPerFrame = 10;
    short num_vertices;
    short num_triangles;
    float radius;
    short skinw;
    short skinh;
    boolean clockwiseCull;
    boolean aBoolean;
    boolean DEBUG;
    int j;
    int i;
    int startRowIndex;
    int col;
    int row;
    int screenPositionIndex;
    float x;
    float y;
    float z;
    float xOld;
    float yOld;
    float zOld;
    int v1;
    int v2;
    int v3;
    int height = 5;
    short halfWidth;
    short halfHeight;
    int width = 5;
    short[] aValues;
    short[] bValues;
    float[] xValues;
    int[] aTriPoints;
    int[] bTriPoints;
    short startA;
    short endA;
    short polyClipTop;
    short polyTop;
    short polyBottom;
    short polyClipBottom;
    short polyOther;
    short polyClipOther;
    float polySlopeLeft;
    float polySlopeRight;
    float aStartLeft;
    float aStartRight;
    float txStartLeft;
    float tyStartLeft;
    float txStartRight;
    float tyStartRight;
    float slopeTxLeft;
    float slopeTyLeft;
    float slopeTxRight;
    float slopeTyRight;
    float tStepX;
    float tStepY;
    float ftx;
    float fty;
    short polyTopS;
    short polyOtherS;
    short polyBottomS;
    short polyTopT;
    short polyOtherT;
    short polyBottomT;
    short skinwOver2;
    short tx;
    short ty;
    short[] furthest;
    short[] sortedTriangles;
    float zoom = 2.0f;
    int depth;
    int maxDepth;
    float scaleFac = 300.0f;
    Dimension mySize = new Dimension(this.height, this.width);
    Color backgroundColour;
    Color foregroundColour;
    Image gScreenImage;
    Image memScreenImage;
    boolean haveBImage = false;
    Image bImage;
    static final byte clean = -1;
    byte[] pixelByteArray;
    int numberOfPixels;
    Graphics offGraphics;
    int renderMode;
    static final int Error = 0;
    static final int wireframe = 1;
    static final int hiddenLine = 3;
    static final int textureMapped = 2;
    static final int numRenderModes = 4;
    IndexColorModel palette;
    MDLModel myModel;
    MemoryImageSource memImage;
    boolean imageReady = false;
    boolean isAnimated = false;
    static final double radsPerDeg = 0.01745329277777778;
    static final double degsPerRad = 57.295778666661654;
    double theta;
    double phi;
    float cosTheta;
    float sinTheta;
    float cosPhi;
    float sinPhi;
    float xfac;
    private Thread renderThread;
    private boolean renderPlease = true;
    private boolean transformPlease = true;
    private long startTime;
    private boolean stopRender = false;
    int[] delayTime;
    private long renderTimerStart;
    private int sumRenderInterval;
    long ticks;
    long nextFrameTick;
    long nextRotTick;

    public MDLViewCanvas(Dimension dimension, IndexColorModel indexColorModel, MDLModel mDLModel, boolean bl) {
        this.DEBUG = bl;
        this.height = dimension.height;
        this.halfHeight = (short)(this.height / 2);
        this.width = dimension.width;
        this.halfWidth = (short)(this.width / 2);
        this.numberOfPixels = this.width * this.height;
        this.mySize = dimension;
        this.palette = indexColorModel;
        this.myModel = mDLModel;
        this.delayTime = new int[4];
        this.i = 0;
        while (this.i < 4) {
            this.delayTime[this.i] = 10;
            ++this.i;
        }
        this.aTriPoints = new int[3];
        this.bTriPoints = new int[3];
        this.backgroundColour = new Color(0, 0, 0);
        this.foregroundColour = new Color(255, 255, 255);
        this.pixelByteArray = new byte[this.numberOfPixels];
        this.memImage = new MemoryImageSource(this.width, this.height, (ColorModel)this.palette, this.pixelByteArray, 0, this.width);
        this.memImage.setAnimated(true);
    }

    public static final String getAuthorInfo() {
        return "Copyright T.J.Grey 1998";
    }

    public void initialiseGraphics() {
        this.memScreenImage = this.createImage(this.memImage);
        this.gScreenImage = this.createImage(this.width, this.height);
        this.offGraphics = this.gScreenImage.getGraphics();
    }

    public Dimension getMinimumSize() {
        return this.mySize;
    }

    public Dimension getPreferedSize() {
        return this.mySize;
    }

    public void modelReady() {
        this.num_vertices = (short)this.myModel.getNumberOfVertices();
        this.num_triangles = (short)this.myModel.getNumberOfTriangles();
        this.radius = this.myModel.getBoundingRadius();
        this.clockwiseCull = this.myModel.getClockwiseCull();
        this.skinw = (short)this.myModel.getSkinWidth();
        this.skinh = (short)this.myModel.getSkinHeight();
        this.aValues = new short[this.num_vertices];
        this.bValues = new short[this.num_vertices];
        this.xValues = new float[this.num_vertices];
        if (this.myModel.getNumberOfSkins() == 0) {
            if (this.renderMode == 2) {
                System.out.println("MDLView: No texturemapping of models allowed with no skins loaded!");
                this.renderMode = 1;
            }
            this.memImage = null;
        }
        this.depth = (int)(this.zoom * this.radius);
        this.maxDepth = 20 * (int)this.radius;
        this.scaleFac = 4 * Math.min(this.width, this.height);
        this.skinwOver2 = (short)(this.skinw / 2);
        this.furthest = new short[this.num_triangles];
        this.i = 0;
        while (this.i < this.num_triangles) {
            this.furthest[this.i] = this.myModel.getTriangleVertexIndex(this.i, 0);
            ++this.i;
        }
        this.sortedTriangles = new short[this.num_triangles];
        this.i = 0;
        while (this.i < this.num_triangles) {
            this.sortedTriangles[this.i] = (short)this.i;
            ++this.i;
        }
        this.generatePoints();
        this.updateFurthestArray();
        this.updateSortedTriangles();
        this.transformPlease = true;
        this.renderPlease = true;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        this.transformPlease = true;
        this.renderPlease = true;
        this.stopRender = false;
        this.ticks = 0L;
        this.nextFrameTick = 0L;
        this.nextRotTick = 0L;
        this.renderThread = new Thread((Runnable)this, "MDLViewRender");
        this.renderThread.setPriority(4);
        this.renderThread.start();
    }

    public void stop() {
        this.stopRender = true;
        this.imageReady = false;
        if (this.renderThread.isAlive()) {
            this.renderThread.stop();
        }
    }

    public void setBackgroundImage(Image image) {
        this.bImage = image;
        this.haveBImage = true;
    }

    public synchronized void scheduleRender() {
        this.renderPlease = true;
    }

    public synchronized void scheduleTransform() {
        this.transformPlease = true;
    }

    public void setModel(MDLModel mDLModel) {
        this.myModel = mDLModel;
        this.imageReady = false;
    }

    private void render() {
        if (this.myModel.getModelError() || !this.myModel.getModelReady()) {
            this.imageReady = false;
            return;
        }
        this.imageReady = false;
        switch (this.renderMode) {
            case 2: {
                this.i = 0;
                while (this.i < this.numberOfPixels) {
                    this.pixelByteArray[this.i] = -1;
                    ++this.i;
                }
                this.updateFurthestArray();
                this.updateSortedTriangles();
                this.i = 0;
                while (this.i < this.num_triangles) {
                    Thread.yield();
                    this.drawPolygonToScreenArray(this.sortedTriangles[this.i]);
                    ++this.i;
                }
                this.memImage.newPixels();
                if (this.haveBImage) {
                    this.offGraphics.drawImage(this.bImage, 0, 0, this.width, this.height, this);
                } else {
                    this.offGraphics.setColor(this.backgroundColour);
                    this.offGraphics.fillRect(0, 0, this.width, this.height);
                }
                this.offGraphics.drawImage(this.memScreenImage, 0, 0, this.width, this.height, this);
                break;
            }
            case 1: {
                if (this.haveBImage) {
                    this.offGraphics.drawImage(this.bImage, 0, 0, this.width, this.height, this);
                } else {
                    this.offGraphics.setColor(this.backgroundColour);
                    this.offGraphics.fillRect(0, 0, this.width, this.height);
                }
                this.offGraphics.setColor(this.foregroundColour);
                this.i = 0;
                while (this.i < this.num_triangles) {
                    this.v1 = this.myModel.getTriangleVertexIndex(this.i, 0);
                    this.v2 = this.myModel.getTriangleVertexIndex(this.i, 1);
                    this.v3 = this.myModel.getTriangleVertexIndex(this.i, 2);
                    this.offGraphics.drawLine(this.aValues[this.v1], this.bValues[this.v1], this.aValues[this.v2], this.bValues[this.v2]);
                    this.offGraphics.drawLine(this.aValues[this.v2], this.bValues[this.v2], this.aValues[this.v3], this.bValues[this.v3]);
                    this.offGraphics.drawLine(this.aValues[this.v3], this.bValues[this.v3], this.aValues[this.v1], this.bValues[this.v1]);
                    ++this.i;
                }
                break;
            }
            case 3: {
                this.updateFurthestArray();
                this.updateSortedTriangles();
                if (this.haveBImage) {
                    this.offGraphics.drawImage(this.bImage, 0, 0, this.width, this.height, this);
                } else {
                    this.offGraphics.setColor(this.backgroundColour);
                    this.offGraphics.fillRect(0, 0, this.width, this.height);
                }
                this.i = this.num_triangles - 1;
                while (this.i >= 0) {
                    Thread.yield();
                    this.v1 = this.myModel.getTriangleVertexIndex(this.sortedTriangles[this.i], 0);
                    this.v2 = this.myModel.getTriangleVertexIndex(this.sortedTriangles[this.i], 1);
                    this.v3 = this.myModel.getTriangleVertexIndex(this.sortedTriangles[this.i], 2);
                    this.aTriPoints[0] = this.aValues[this.v1];
                    this.bTriPoints[0] = this.bValues[this.v1];
                    this.aTriPoints[1] = this.aValues[this.v2];
                    this.bTriPoints[1] = this.bValues[this.v2];
                    this.aTriPoints[2] = this.aValues[this.v3];
                    this.bTriPoints[2] = this.bValues[this.v3];
                    this.offGraphics.setColor(this.foregroundColour);
                    this.offGraphics.fillPolygon(this.aTriPoints, this.bTriPoints, 3);
                    this.offGraphics.setColor(this.backgroundColour);
                    this.offGraphics.drawLine(this.aTriPoints[0], this.bTriPoints[0], this.aTriPoints[1], this.bTriPoints[1]);
                    this.offGraphics.drawLine(this.aTriPoints[1], this.bTriPoints[1], this.aTriPoints[2], this.bTriPoints[2]);
                    this.offGraphics.drawLine(this.aTriPoints[2], this.bTriPoints[2], this.aTriPoints[0], this.bTriPoints[0]);
                    --this.i;
                }
                break;
            }
            default: {
                this.offGraphics.drawString("ERROR", 5, 10);
            }
        }
        this.imageReady = true;
        this.update(this.getGraphics());
        this.renderPlease = false;
    }

    public Image getImage() {
        if (this.myModel.getModelError() || !this.myModel.getModelReady()) {
            return null;
        }
        this.generatePoints();
        this.i = 0;
        while (this.i < this.numberOfPixels) {
            this.pixelByteArray[this.i] = -1;
            ++this.i;
        }
        this.updateFurthestArray();
        this.updateSortedTriangles();
        this.i = 0;
        while (this.i < this.num_triangles) {
            this.drawPolygonToScreenArray(this.sortedTriangles[this.i]);
            ++this.i;
        }
        this.memImage = new MemoryImageSource(this.width, this.height, (ColorModel)this.palette, this.pixelByteArray, 0, this.width);
        this.memImage.setAnimated(false);
        return this.createImage(this.memImage);
    }

    public Image getSkinImage() {
        if (this.myModel.getModelError() || !this.myModel.getModelReady() || this.myModel.getNumberOfSkins() < 1) {
            return null;
        }
        int n = this.myModel.getSkinWidth();
        int n2 = this.myModel.getSkinHeight();
        byte[] byArray = new byte[n * n2];
        this.i = 0;
        while (this.i < n * n2) {
            byArray[this.i] = -1;
            ++this.i;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                int n5 = n3 * n + n4;
                byArray[n5] = this.myModel.getTexel((short)n4, (short)n3);
                ++n4;
            }
            ++n3;
        }
        return this.createImage(new MemoryImageSource(n, n2, (ColorModel)this.palette, byArray, 0, n));
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    private void generatePoints() {
        this.cosTheta = (float)Math.cos(this.theta);
        this.sinTheta = (float)Math.sin(this.theta);
        this.cosPhi = (float)Math.cos(this.phi);
        this.sinPhi = (float)Math.sin(this.phi);
        this.i = 0;
        while (this.i < this.num_vertices) {
            this.xOld = this.myModel.getVertexX(this.i);
            this.yOld = this.myModel.getVertexY(this.i);
            this.zOld = this.myModel.getVertexZ(this.i);
            this.xfac = this.xOld * this.cosTheta - this.yOld * this.sinTheta;
            this.x = this.xfac * this.cosPhi + this.zOld * this.sinPhi;
            this.y = this.yOld * this.cosTheta + this.xOld * this.sinTheta;
            this.z = this.zOld * this.cosPhi - this.xfac * this.sinPhi;
            this.x -= this.radius;
            this.x -= (float)this.depth;
            if ((double)this.x > -0.001) {
                System.out.println("MDLView: Please report the woof bug!");
                this.x = -0.001f;
            }
            this.xValues[this.i] = this.x;
            this.aValues[this.i] = (short)(this.scaleFac * this.y / -this.x + (float)this.halfWidth);
            this.bValues[this.i] = (short)(this.halfHeight - (short)(this.scaleFac * this.z / -this.x));
            ++this.i;
        }
        this.transformPlease = false;
    }

    public void update(Graphics graphics) {
        if (this.imageReady) {
            graphics.drawImage(this.gScreenImage, 0, 0, this.width, this.height, this);
        }
    }

    public void setMode(String string) throws BadModeException {
        if ((string = string.toLowerCase()).equals("wireframe") || string.equals("wire")) {
            this.renderMode = 1;
        } else if (string.equals("hiddenline")) {
            this.renderMode = 3;
        } else if (string.equals("texturemapped") || string.equals("texture") || string.equals("texturemap") || string.equals("texturemapping")) {
            this.renderMode = 2;
        } else if (string.equals("error")) {
            this.renderMode = 0;
        } else {
            this.renderMode = 0;
            throw new BadModeException(string);
        }
        this.renderPlease = true;
    }

    public void nextRenderMode() {
        this.renderMode = this.renderMode == 3 ? 1 : ++this.renderMode;
        if (this.myModel.getNumberOfSkins() == 0 && this.renderMode == 2) {
            this.nextRenderMode();
        }
        this.renderPlease = true;
    }

    public void setRenderMode(int n) throws BadModeException {
        if (n > 3) {
            throw new BadModeException(n);
        }
        this.renderMode = n;
        this.renderPlease = true;
    }

    public void stopAll() {
        this.stopRender = true;
    }

    public void startAnimated(boolean bl) {
        if (bl) {
            this.startAnimation();
            return;
        }
        this.isAnimated = false;
    }

    public void startAnimation() {
        this.isAnimated = true;
        this.nextFrameTick = this.ticks;
        this.renderPlease = true;
    }

    public void stopAnimation() {
        this.isAnimated = false;
    }

    public void setSkinGroup(int n) {
        this.myModel.setCurrentSkinIndex(n);
        this.renderPlease = true;
    }

    public void setBackgroundColour(String string) {
        try {
            this.backgroundColour = this.getColourFromHex(string);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("MDLView: Error extracting background colour, using white");
            this.backgroundColour = new Color(255, 255, 255);
            return;
        }
    }

    public void setForegroundColour(String string) {
        try {
            this.foregroundColour = this.getColourFromHex(string);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("MDLView: Error extracting foreground colour, using black");
            this.backgroundColour = new Color(0, 0, 0);
            return;
        }
    }

    private Color getColourFromHex(String string) throws NumberFormatException {
        String string2 = "0x" + string.substring(1, 3);
        String string3 = "0x" + string.substring(3, 5);
        String string4 = "0x" + string.substring(5, 7);
        int n = Integer.decode(string2);
        int n2 = Integer.decode(string3);
        int n3 = Integer.decode(string4);
        return new Color(n, n2, n3);
    }

    public void setRotating(int n) {
        if (n > 0) {
            this.rotating = true;
            this.degsPerFrame = n;
            return;
        }
        this.rotating = false;
    }

    public void setRotating(boolean bl) {
        this.rotating = bl;
    }

    public int getColourAt(int n, int n2) {
        int n3 = n2 * this.width + n;
        if (n3 < this.numberOfPixels) {
            return this.pixelByteArray[n3];
        }
        return -1;
    }

    public void nextSimpleFrame() {
        this.myModel.nextFrame();
        this.transformPlease = true;
        this.renderPlease = true;
    }

    public void nextSkin() {
        this.myModel.nextSkin();
        this.renderPlease = true;
    }

    public void lastSkin() {
        this.myModel.lastSkin();
        this.renderPlease = true;
    }

    public void lastSimpleFrame() {
        this.myModel.lastFrame();
        this.transformPlease = true;
        this.renderPlease = true;
    }

    public void setZAngle(int n) {
        this.theta = (float)((double)n * 0.01745329277777778);
        this.theta %= 6.2831854;
        this.transformPlease = true;
        this.renderPlease = true;
    }

    public void setYAngle(int n) {
        this.phi = (float)((double)n * 0.01745329277777778);
        this.phi %= 6.2831854;
        this.transformPlease = true;
        this.renderPlease = true;
    }

    public void rotateZ(int n) {
        this.theta += (double)((float)((double)n * 0.01745329277777778));
        this.theta %= 6.2831854;
        this.transformPlease = true;
        this.renderPlease = true;
    }

    public void rotateY(int n) {
        this.phi += (double)((float)((double)n * 0.01745329277777778));
        this.phi %= 6.2831854;
        this.transformPlease = true;
        this.renderPlease = true;
    }

    public void setZoom(float f) {
        if (f < 50.0f && f > 0.0f) {
            this.zoom = f;
        }
        this.transformPlease = true;
        this.renderPlease = true;
    }

    public float getZoom() {
        return this.zoom;
    }

    public int getCurrentSkinGroup() {
        return this.myModel.getCurrentSkinIndex();
    }

    private void tick() {
        if (this.rotating && this.ticks >= this.nextRotTick) {
            this.rotateZ(this.degsPerFrame);
            this.nextRotTick = this.ticks + 30L;
        }
        if (this.isAnimated && this.ticks >= this.nextFrameTick) {
            this.nextFrameTick = this.ticks + (long)this.myModel.getFrameDelayMillis();
            this.nextSimpleFrame();
        }
    }

    public void run() {
        while (!this.stopRender && this.renderThread != null) {
            System.gc();
            this.tick();
            if (this.transformPlease) {
                this.generatePoints();
            }
            if (this.renderPlease) {
                this.renderTimerStart = System.currentTimeMillis();
                this.render();
                this.sumRenderInterval = (int)(System.currentTimeMillis() - this.renderTimerStart);
                int n = this.renderMode;
                this.delayTime[n] = (int)((double)this.delayTime[n] + 0.1 * (double)(this.sumRenderInterval - this.delayTime[this.renderMode]));
                this.delayTime[this.renderMode] = Math.max(this.delayTime[this.renderMode], 50);
            }
            Thread.yield();
            try {
                this.ticks += 50L;
                this.startTime += (long)this.delayTime[this.renderMode];
                Thread.sleep(Math.max(0L, this.startTime - System.currentTimeMillis()));
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Interupted render thread");
            }
        }
    }

    public int getFrameNumber() {
        return this.myModel.getCurrentFrameIndex();
    }

    public int getTheta() {
        return (int)(this.theta * 57.295778666661654);
    }

    public int getPhi() {
        return (int)(this.phi * 57.295778666661654);
    }

    public String getFrameName() {
        return this.myModel.getFrameName();
    }

    public int getFrameTime() {
        return this.sumRenderInterval;
    }

    public void translateZ(int n) {
        if (n + this.depth < this.maxDepth && n + this.depth > 0) {
            this.zoom += (float)n / this.radius;
            this.depth = (int)(this.radius * this.zoom);
        }
        this.transformPlease = true;
        this.renderPlease = true;
    }

    private boolean drawPolygonToScreenArray(int n) {
        this.col = 0;
        this.row = 0;
        this.polyTop = 0;
        this.polyBottom = 0;
        this.polyOther = 0;
        this.v1 = this.myModel.getTriangleVertexIndex(n, 0);
        this.v2 = this.myModel.getTriangleVertexIndex(n, 1);
        this.v3 = this.myModel.getTriangleVertexIndex(n, 2);
        if (this.bValues[this.myModel.getTriangleVertexIndex(n, this.polyTop)] > this.bValues[this.v2]) {
            this.polyTop = 1;
        }
        if (this.bValues[this.myModel.getTriangleVertexIndex(n, this.polyTop)] > this.bValues[this.v3]) {
            this.polyTop = (short)2;
        }
        if (this.bValues[this.myModel.getTriangleVertexIndex(n, this.polyBottom)] < this.bValues[this.v2]) {
            this.polyBottom = 1;
        }
        if (this.bValues[this.myModel.getTriangleVertexIndex(n, this.polyBottom)] < this.bValues[this.v3]) {
            this.polyBottom = (short)2;
        }
        if (this.polyOther == this.polyTop || this.polyOther == this.polyBottom) {
            this.polyOther = 1;
            if (this.polyOther == this.polyTop || this.polyOther == this.polyBottom) {
                this.polyOther = (short)2;
            }
        }
        if (this.bValues[this.myModel.getTriangleVertexIndex(n, this.polyTop)] == this.bValues[this.myModel.getTriangleVertexIndex(n, this.polyBottom)]) {
            this.drawFlatTopToScreenArray(n);
            return true;
        }
        if (this.bValues[this.myModel.getTriangleVertexIndex(n, this.polyOther)] == this.bValues[this.myModel.getTriangleVertexIndex(n, this.polyTop)]) {
            this.drawFlatTopToScreenArray(n);
            return true;
        }
        if (this.bValues[this.myModel.getTriangleVertexIndex(n, this.polyOther)] == this.bValues[this.myModel.getTriangleVertexIndex(n, this.polyBottom)]) {
            this.drawFlatBottomedToScreenArray(n);
            return true;
        }
        this.drawAngledToScreenArray(n);
        return true;
    }

    private void drawFlatTopToScreenArray(int n) {
        if (this.aValues[this.myModel.getTriangleVertexIndex(n, this.polyOther)] < this.aValues[this.myModel.getTriangleVertexIndex(n, this.polyTop)]) {
            this.polyClipTop = this.polyTop;
            this.polyTop = this.polyOther;
            this.polyOther = this.polyClipTop;
        }
        if (this.cullable()) {
            return;
        }
        this.polyTop = this.myModel.getTriangleVertexIndex(n, this.polyTop);
        this.polyBottom = this.myModel.getTriangleVertexIndex(n, this.polyBottom);
        this.polyOther = this.myModel.getTriangleVertexIndex(n, this.polyOther);
        this.polySlopeLeft = (float)(this.aValues[this.polyBottom] - this.aValues[this.polyTop]) / (float)(this.bValues[this.polyBottom] - this.bValues[this.polyTop]);
        this.polySlopeRight = (float)(this.aValues[this.polyBottom] - this.aValues[this.polyOther]) / (float)(this.bValues[this.polyBottom] - this.bValues[this.polyOther]);
        this.polyTopT = this.myModel.getSkinVertexT(n, this.polyTop);
        this.polyOtherT = this.myModel.getSkinVertexT(n, this.polyOther);
        this.polyBottomT = this.myModel.getSkinVertexT(n, this.polyBottom);
        this.polyTopS = this.myModel.getSkinVertexS(n, this.polyTop);
        this.polyOtherS = this.myModel.getSkinVertexS(n, this.polyOther);
        this.polyBottomS = this.myModel.getSkinVertexS(n, this.polyBottom);
        this.slopeTxLeft = (float)(this.polyBottomS - this.polyTopS) / (float)(this.bValues[this.polyBottom] - this.bValues[this.polyTop]);
        this.slopeTyLeft = (float)(this.polyBottomT - this.polyTopT) / (float)(this.bValues[this.polyBottom] - this.bValues[this.polyTop]);
        this.slopeTxRight = (float)(this.polyBottomS - this.polyOtherS) / (float)(this.bValues[this.polyBottom] - this.bValues[this.polyTop]);
        this.slopeTyRight = (float)(this.polyBottomT - this.polyOtherT) / (float)(this.bValues[this.polyBottom] - this.bValues[this.polyTop]);
        this.aStartLeft = this.aValues[this.polyTop];
        this.aStartRight = this.aValues[this.polyOther];
        this.txStartLeft = this.polyTopS;
        this.tyStartLeft = this.polyTopT;
        this.txStartRight = this.polyOtherS;
        this.tyStartRight = this.polyOtherT;
        this.polyClipTop = this.bValues[this.polyTop];
        this.polyClipBottom = this.bValues[this.polyBottom];
        if (this.polyClipTop < 0) {
            if (this.polyClipBottom < 0) {
                return;
            }
            this.j = -this.polyClipTop;
            this.aStartLeft += (float)this.j * this.polySlopeLeft;
            this.aStartRight += (float)this.j * this.polySlopeRight;
            this.txStartLeft += (float)this.j * this.slopeTxLeft;
            this.tyStartLeft += (float)this.j * this.slopeTyLeft;
            this.txStartRight += (float)this.j * this.slopeTxRight;
            this.tyStartRight += (float)this.j * this.slopeTyRight;
            this.polyClipTop = 0;
        }
        if (this.polyClipBottom > this.height - 1) {
            if (this.polyClipTop > this.height - 1) {
                return;
            }
            this.polyClipBottom = (short)(this.height - 1);
        }
        this.startRowIndex = (this.polyClipTop - 1) * this.width;
        this.row = this.polyClipTop;
        while (this.row <= this.polyClipBottom) {
            this.startA = (short)this.aStartLeft;
            this.endA = (short)this.aStartRight;
            this.j = this.endA - this.startA + 1;
            this.tStepX = (this.txStartRight - this.txStartLeft) / (float)this.j;
            this.tStepY = (this.tyStartRight - this.tyStartLeft) / (float)this.j;
            this.ftx = this.txStartLeft;
            this.fty = this.tyStartLeft;
            if (this.startA < 0) {
                this.col = -this.startA;
                this.ftx += (float)this.col * this.tStepX;
                this.fty += (float)this.col * this.tStepY;
                this.startA = 0;
            }
            if (this.endA > this.width - 1) {
                this.endA = (short)(this.width - 1);
            }
            this.startRowIndex += this.width;
            this.screenPositionIndex = this.startRowIndex + this.startA;
            this.col = this.startRowIndex + this.endA;
            while (this.screenPositionIndex <= this.col) {
                if (this.pixelByteArray[this.screenPositionIndex] == -1) {
                    this.tx = (short)this.ftx;
                    this.ty = (short)this.fty;
                    this.pixelByteArray[this.screenPositionIndex] = this.myModel.getTexel(this.tx, this.ty);
                }
                ++this.screenPositionIndex;
                this.ftx += this.tStepX;
                this.fty += this.tStepY;
            }
            this.aStartLeft += this.polySlopeLeft;
            this.aStartRight += this.polySlopeRight;
            this.txStartLeft += this.slopeTxLeft;
            this.tyStartLeft += this.slopeTyLeft;
            this.txStartRight += this.slopeTxRight;
            this.tyStartRight += this.slopeTyRight;
            ++this.row;
        }
    }

    private void drawFlatBottomedToScreenArray(int n) {
        if (this.aValues[this.myModel.getTriangleVertexIndex(n, this.polyOther)] < this.aValues[this.myModel.getTriangleVertexIndex(n, this.polyBottom)]) {
            short s = this.polyBottom;
            this.polyBottom = this.polyOther;
            this.polyOther = s;
        }
        if (this.cullable()) {
            return;
        }
        this.polyTop = this.myModel.getTriangleVertexIndex(n, this.polyTop);
        this.polyBottom = this.myModel.getTriangleVertexIndex(n, this.polyBottom);
        this.polyOther = this.myModel.getTriangleVertexIndex(n, this.polyOther);
        this.polySlopeLeft = (float)(this.aValues[this.polyTop] - this.aValues[this.polyBottom]) / (float)(this.bValues[this.polyTop] - this.bValues[this.polyBottom]);
        this.polySlopeRight = (float)(this.aValues[this.polyTop] - this.aValues[this.polyOther]) / (float)(this.bValues[this.polyTop] - this.bValues[this.polyOther]);
        this.polyTopT = this.myModel.getSkinVertexT(n, this.polyTop);
        this.polyOtherT = this.myModel.getSkinVertexT(n, this.polyOther);
        this.polyBottomT = this.myModel.getSkinVertexT(n, this.polyBottom);
        this.polyTopS = this.myModel.getSkinVertexS(n, this.polyTop);
        this.polyOtherS = this.myModel.getSkinVertexS(n, this.polyOther);
        this.polyBottomS = this.myModel.getSkinVertexS(n, this.polyBottom);
        this.slopeTxLeft = (float)(this.polyTopS - this.polyBottomS) / (float)(this.bValues[this.polyTop] - this.bValues[this.polyBottom]);
        this.slopeTyLeft = (float)(this.polyTopT - this.polyBottomT) / (float)(this.bValues[this.polyTop] - this.bValues[this.polyBottom]);
        this.slopeTxRight = (float)(this.polyTopS - this.polyOtherS) / (float)(this.bValues[this.polyTop] - this.bValues[this.polyOther]);
        this.slopeTyRight = (float)(this.polyTopT - this.polyOtherT) / (float)(this.bValues[this.polyTop] - this.bValues[this.polyOther]);
        this.aStartLeft = this.aValues[this.polyBottom];
        this.aStartRight = this.aValues[this.polyOther];
        this.txStartLeft = this.polyBottomS;
        this.tyStartLeft = this.polyBottomT;
        this.txStartRight = this.polyOtherS;
        this.tyStartRight = this.polyOtherT;
        this.polyClipTop = this.bValues[this.polyTop];
        this.polyClipBottom = this.bValues[this.polyBottom];
        this.polyClipOther = this.bValues[this.polyOther];
        if (this.polyClipTop < 0) {
            if (this.polyClipBottom < 0) {
                return;
            }
            this.polyClipTop = 0;
        }
        if (this.polyClipBottom > this.height - 1) {
            if (this.polyClipTop > this.height - 1) {
                return;
            }
            this.j = this.polyClipBottom - this.height - 1;
            this.aStartLeft -= (float)this.j * this.polySlopeLeft;
            this.aStartRight -= (float)this.j * this.polySlopeRight;
            this.txStartLeft -= (float)this.j * this.slopeTxLeft;
            this.tyStartLeft -= (float)this.j * this.slopeTyLeft;
            this.txStartRight -= (float)this.j * this.slopeTxRight;
            this.tyStartRight -= (float)this.j * this.slopeTyRight;
            this.polyClipBottom = (short)(this.height - 1);
        }
        this.startRowIndex = (this.polyClipBottom + 1) * this.width;
        this.row = this.polyClipBottom;
        while (this.row >= this.polyClipTop) {
            this.startA = (short)this.aStartLeft;
            this.endA = (short)this.aStartRight;
            this.j = this.endA - this.startA + 1;
            this.tStepX = (this.txStartRight - this.txStartLeft) / (float)this.j;
            this.tStepY = (this.tyStartRight - this.tyStartLeft) / (float)this.j;
            this.ftx = this.txStartLeft;
            this.fty = this.tyStartLeft;
            if (this.startA < 0) {
                this.col = -this.startA;
                this.ftx += (float)this.col * this.tStepX;
                this.fty += (float)this.col * this.tStepY;
                this.startA = 0;
            }
            if (this.endA > this.width - 1) {
                this.endA = (short)(this.width - 1);
            }
            this.startRowIndex -= this.width;
            this.screenPositionIndex = this.startRowIndex + this.startA;
            this.col = this.startRowIndex + this.endA;
            while (this.screenPositionIndex <= this.col) {
                if (this.pixelByteArray[this.screenPositionIndex] == -1) {
                    this.tx = (short)this.ftx;
                    this.ty = (short)this.fty;
                    this.pixelByteArray[this.screenPositionIndex] = this.myModel.getTexel(this.tx, this.ty);
                }
                ++this.screenPositionIndex;
                this.ftx += this.tStepX;
                this.fty += this.tStepY;
            }
            this.aStartLeft -= this.polySlopeLeft;
            this.aStartRight -= this.polySlopeRight;
            this.txStartLeft -= this.slopeTxLeft;
            this.tyStartLeft -= this.slopeTyLeft;
            this.txStartRight -= this.slopeTxRight;
            this.tyStartRight -= this.slopeTyRight;
            --this.row;
        }
    }

    private void drawAngledToScreenArray(int n) {
        this.v1 = this.myModel.getTriangleVertexIndex(n, this.polyTop);
        this.v2 = this.myModel.getTriangleVertexIndex(n, this.polyOther);
        this.v3 = this.myModel.getTriangleVertexIndex(n, this.polyBottom);
        this.polySlopeLeft = (float)(this.aValues[this.v3] - this.aValues[this.v1]) / (float)(this.bValues[this.v3] - this.bValues[this.v1]);
        this.polySlopeRight = (float)(this.aValues[this.v2] - this.aValues[this.v1]) / (float)(this.bValues[this.v2] - this.bValues[this.v1]);
        if (this.aValues[this.v2] >= (short)((float)this.aValues[this.v1] + (float)(this.bValues[this.v2] - this.bValues[this.v1]) * this.polySlopeLeft)) {
            if (this.cullable()) {
                return;
            }
            this.polyTop = (short)this.v1;
            this.polyBottom = (short)this.v3;
            this.polyOther = (short)this.v2;
            this.polyTopT = this.myModel.getSkinVertexT(n, this.polyTop);
            this.polyOtherT = this.myModel.getSkinVertexT(n, this.polyOther);
            this.polyBottomT = this.myModel.getSkinVertexT(n, this.polyBottom);
            this.polyTopS = this.myModel.getSkinVertexS(n, this.polyTop);
            this.polyOtherS = this.myModel.getSkinVertexS(n, this.polyOther);
            this.polyBottomS = this.myModel.getSkinVertexS(n, this.polyBottom);
            this.slopeTxLeft = (float)(this.polyBottomS - this.polyTopS) / (float)(this.bValues[this.polyBottom] - this.bValues[this.polyTop]);
            this.slopeTyLeft = (float)(this.polyBottomT - this.polyTopT) / (float)(this.bValues[this.polyBottom] - this.bValues[this.polyTop]);
            this.slopeTxRight = (float)(this.polyOtherS - this.polyTopS) / (float)(this.bValues[this.polyOther] - this.bValues[this.polyTop]);
            this.slopeTyRight = (float)(this.polyOtherT - this.polyTopT) / (float)(this.bValues[this.polyOther] - this.bValues[this.polyTop]);
            this.aStartLeft = this.aValues[this.polyTop];
            this.aStartRight = this.aValues[this.polyTop];
            this.txStartLeft = this.polyTopS;
            this.tyStartLeft = this.polyTopT;
            this.txStartRight = this.polyTopS;
            this.tyStartRight = this.polyTopT;
            this.polyClipTop = this.bValues[this.polyTop];
            this.polyClipOther = this.bValues[this.polyOther];
            this.polyClipBottom = this.bValues[this.polyBottom];
            if (this.polyClipTop < 0) {
                if (this.polyClipBottom < 0) {
                    return;
                }
                this.j = this.polyClipOther < 0 ? this.polyClipOther - this.polyClipTop : (int)(-this.polyClipTop);
                this.aStartLeft += (float)this.j * this.polySlopeLeft;
                this.aStartRight += (float)this.j * this.polySlopeRight;
                this.txStartLeft += (float)this.j * this.slopeTxLeft;
                this.tyStartLeft += (float)this.j * this.slopeTyLeft;
                this.txStartRight += (float)this.j * this.slopeTxRight;
                this.tyStartRight += (float)this.j * this.slopeTyRight;
                this.polyClipTop = 0;
            }
            if (this.polyClipOther > this.height - 1) {
                this.polyClipOther = (short)this.height;
            }
            this.startRowIndex = (this.polyClipTop - 1) * this.width;
            this.row = this.polyClipTop;
            while (this.row < this.polyClipOther) {
                this.startA = (short)this.aStartLeft;
                this.endA = (short)this.aStartRight;
                this.j = this.endA - this.startA + 1;
                this.tStepX = (this.txStartRight - this.txStartLeft) / (float)this.j;
                this.tStepY = (this.tyStartRight - this.tyStartLeft) / (float)this.j;
                this.ftx = this.txStartLeft;
                this.fty = this.tyStartLeft;
                if (this.startA < 0) {
                    this.col = -this.startA;
                    this.ftx += (float)this.col * this.tStepX;
                    this.fty += (float)this.col * this.tStepY;
                    this.startA = 0;
                }
                if (this.endA > this.width - 1) {
                    this.endA = (short)(this.width - 1);
                }
                this.startRowIndex += this.width;
                this.screenPositionIndex = this.startRowIndex + this.startA;
                this.col = this.startRowIndex + this.endA;
                while (this.screenPositionIndex <= this.col) {
                    if (this.pixelByteArray[this.screenPositionIndex] == -1) {
                        this.tx = (short)this.ftx;
                        this.ty = (short)this.fty;
                        this.pixelByteArray[this.screenPositionIndex] = this.myModel.getTexel(this.tx, this.ty);
                    }
                    ++this.screenPositionIndex;
                    this.ftx += this.tStepX;
                    this.fty += this.tStepY;
                }
                this.aStartLeft += this.polySlopeLeft;
                this.aStartRight += this.polySlopeRight;
                this.txStartLeft += this.slopeTxLeft;
                this.tyStartLeft += this.slopeTyLeft;
                this.txStartRight += this.slopeTxRight;
                this.tyStartRight += this.slopeTyRight;
                ++this.row;
            }
            this.polyClipOther = this.bValues[this.polyOther];
            this.polyClipBottom = this.bValues[this.polyBottom];
            this.polySlopeRight = (float)(this.aValues[this.polyBottom] - this.aValues[this.polyOther]) / (float)(this.bValues[this.polyBottom] - this.bValues[this.polyOther]);
            this.aStartRight = this.aValues[this.polyOther];
            this.slopeTxRight = (float)(this.polyBottomS - this.polyOtherS) / (float)(this.bValues[this.polyBottom] - this.bValues[this.polyOther]);
            this.slopeTyRight = (float)(this.polyBottomT - this.polyOtherT) / (float)(this.bValues[this.polyBottom] - this.bValues[this.polyOther]);
            this.txStartRight = this.polyOtherS;
            this.tyStartRight = this.polyOtherT;
            if (this.polyClipOther < 0) {
                this.j = -this.polyClipOther;
                this.aStartLeft += (float)this.j * this.polySlopeLeft;
                this.aStartRight += (float)this.j * this.polySlopeRight;
                this.txStartLeft += (float)this.j * this.slopeTxLeft;
                this.tyStartLeft += (float)this.j * this.slopeTyLeft;
                this.txStartRight += (float)this.j * this.slopeTxRight;
                this.tyStartRight += (float)this.j * this.slopeTyRight;
                this.polyClipOther = 0;
            }
            if (this.polyClipBottom > this.height - 1) {
                this.polyClipBottom = (short)(this.height - 1);
            }
            this.startRowIndex = (this.polyClipOther - 1) * this.width;
            this.row = this.polyClipOther;
            while (this.row <= this.polyClipBottom) {
                this.startA = (short)this.aStartLeft;
                this.endA = (short)this.aStartRight;
                this.j = this.endA - this.startA + 1;
                this.tStepX = (this.txStartRight - this.txStartLeft) / (float)this.j;
                this.tStepY = (this.tyStartRight - this.tyStartLeft) / (float)this.j;
                this.ftx = this.txStartLeft;
                this.fty = this.tyStartLeft;
                if (this.startA < 0) {
                    this.col = -this.startA;
                    this.ftx += (float)this.col * this.tStepX;
                    this.fty += (float)this.col * this.tStepY;
                    this.startA = 0;
                }
                if (this.endA > this.width - 1) {
                    this.endA = (short)(this.width - 1);
                }
                this.startRowIndex += this.width;
                this.screenPositionIndex = this.startRowIndex + this.startA;
                this.col = this.startRowIndex + this.endA;
                while (this.screenPositionIndex <= this.col) {
                    if (this.pixelByteArray[this.screenPositionIndex] == -1) {
                        this.tx = (short)this.ftx;
                        this.ty = (short)this.fty;
                        this.pixelByteArray[this.screenPositionIndex] = this.myModel.getTexel(this.tx, this.ty);
                    }
                    ++this.screenPositionIndex;
                    this.ftx += this.tStepX;
                    this.fty += this.tStepY;
                }
                this.aStartLeft += this.polySlopeLeft;
                this.aStartRight += this.polySlopeRight;
                this.txStartLeft += this.slopeTxLeft;
                this.tyStartLeft += this.slopeTyLeft;
                this.txStartRight += this.slopeTxRight;
                this.tyStartRight += this.slopeTyRight;
                ++this.row;
            }
            return;
        }
        if (this.cullable2()) {
            return;
        }
        this.polyTop = this.myModel.getTriangleVertexIndex(n, this.polyTop);
        this.polyBottom = this.myModel.getTriangleVertexIndex(n, this.polyBottom);
        this.polyOther = this.myModel.getTriangleVertexIndex(n, this.polyOther);
        this.polyTopT = this.myModel.getSkinVertexT(n, this.polyTop);
        this.polyOtherT = this.myModel.getSkinVertexT(n, this.polyOther);
        this.polyBottomT = this.myModel.getSkinVertexT(n, this.polyBottom);
        this.polyTopS = this.myModel.getSkinVertexS(n, this.polyTop);
        this.polyOtherS = this.myModel.getSkinVertexS(n, this.polyOther);
        this.polyBottomS = this.myModel.getSkinVertexS(n, this.polyBottom);
        this.slopeTxLeft = (float)(this.polyOtherS - this.polyTopS) / (float)(this.bValues[this.polyOther] - this.bValues[this.polyTop]);
        this.slopeTyLeft = (float)(this.polyOtherT - this.polyTopT) / (float)(this.bValues[this.polyOther] - this.bValues[this.polyTop]);
        this.slopeTxRight = (float)(this.polyBottomS - this.polyTopS) / (float)(this.bValues[this.polyBottom] - this.bValues[this.polyTop]);
        this.slopeTyRight = (float)(this.polyBottomT - this.polyTopT) / (float)(this.bValues[this.polyBottom] - this.bValues[this.polyTop]);
        this.aStartLeft = this.aValues[this.polyTop];
        this.aStartRight = this.aValues[this.polyTop];
        this.txStartLeft = this.polyTopS;
        this.tyStartLeft = this.polyTopT;
        this.txStartRight = this.polyTopS;
        this.tyStartRight = this.polyTopT;
        this.polyClipTop = this.bValues[this.polyTop];
        this.polyClipOther = this.bValues[this.polyOther];
        this.polyClipBottom = this.bValues[this.polyBottom];
        if (this.polyClipTop < 0) {
            if (this.polyClipBottom < 0) {
                return;
            }
            this.j = this.polyClipOther < 0 ? this.polyClipOther - this.polyClipTop : (int)(-this.polyClipTop);
            this.aStartLeft += (float)this.j * this.polySlopeRight;
            this.aStartRight += (float)this.j * this.polySlopeLeft;
            this.txStartLeft += (float)this.j * this.slopeTxLeft;
            this.tyStartLeft += (float)this.j * this.slopeTyLeft;
            this.txStartRight += (float)this.j * this.slopeTxRight;
            this.tyStartRight += (float)this.j * this.slopeTyRight;
            this.polyClipTop = 0;
        }
        if (this.polyClipOther > this.height - 1) {
            this.polyClipOther = (short)this.height;
        }
        this.startRowIndex = (this.polyClipTop - 1) * this.width;
        this.row = this.polyClipTop;
        while (this.row < this.polyClipOther) {
            this.startA = (short)this.aStartLeft;
            this.endA = (short)this.aStartRight;
            this.j = this.endA - this.startA + 1;
            this.tStepX = (this.txStartRight - this.txStartLeft) / (float)this.j;
            this.tStepY = (this.tyStartRight - this.tyStartLeft) / (float)this.j;
            this.ftx = this.txStartLeft;
            this.fty = this.tyStartLeft;
            if (this.startA < 0) {
                this.col = -this.startA;
                this.ftx += (float)this.col * this.tStepX;
                this.fty += (float)this.col * this.tStepY;
                this.startA = 0;
            }
            if (this.endA > this.width - 1) {
                this.endA = (short)(this.width - 1);
            }
            this.startRowIndex += this.width;
            this.screenPositionIndex = this.startRowIndex + this.startA;
            this.col = this.startRowIndex + this.endA;
            while (this.screenPositionIndex <= this.col) {
                if (this.pixelByteArray[this.screenPositionIndex] == -1) {
                    this.tx = (short)this.ftx;
                    this.ty = (short)this.fty;
                    this.pixelByteArray[this.screenPositionIndex] = this.myModel.getTexel(this.tx, this.ty);
                }
                ++this.screenPositionIndex;
                this.ftx += this.tStepX;
                this.fty += this.tStepY;
            }
            this.aStartLeft += this.polySlopeRight;
            this.aStartRight += this.polySlopeLeft;
            this.txStartLeft += this.slopeTxLeft;
            this.tyStartLeft += this.slopeTyLeft;
            this.txStartRight += this.slopeTxRight;
            this.tyStartRight += this.slopeTyRight;
            ++this.row;
        }
        this.polyClipOther = this.bValues[this.polyOther];
        this.polyClipBottom = this.bValues[this.polyBottom];
        this.polySlopeRight = (float)(this.aValues[this.polyBottom] - this.aValues[this.polyOther]) / (float)(this.bValues[this.polyBottom] - this.bValues[this.polyOther]);
        this.aStartLeft = this.aValues[this.polyOther];
        this.slopeTxLeft = (float)(this.polyBottomS - this.polyOtherS) / (float)(this.bValues[this.polyBottom] - this.bValues[this.polyOther]);
        this.slopeTyLeft = (float)(this.polyBottomT - this.polyOtherT) / (float)(this.bValues[this.polyBottom] - this.bValues[this.polyOther]);
        this.txStartLeft = this.polyOtherS;
        this.tyStartLeft = this.polyOtherT;
        if (this.polyClipOther < 0) {
            this.j = -this.polyClipOther;
            this.aStartRight += (float)this.j * this.polySlopeLeft;
            this.aStartLeft += (float)this.j * this.polySlopeRight;
            this.txStartLeft += (float)this.j * this.slopeTxLeft;
            this.tyStartLeft += (float)this.j * this.slopeTyLeft;
            this.txStartRight += (float)this.j * this.slopeTxRight;
            this.tyStartRight += (float)this.j * this.slopeTyRight;
            this.polyClipOther = 0;
        }
        if (this.polyClipBottom > this.height - 1) {
            this.polyClipBottom = (short)(this.height - 1);
        }
        this.startRowIndex = (this.polyClipOther - 1) * this.width;
        this.row = this.polyClipOther;
        while (this.row <= this.polyClipBottom) {
            this.startA = (short)this.aStartLeft;
            this.endA = (short)this.aStartRight;
            this.j = this.endA - this.startA + 1;
            this.tStepX = (this.txStartRight - this.txStartLeft) / (float)this.j;
            this.tStepY = (this.tyStartRight - this.tyStartLeft) / (float)this.j;
            this.ftx = this.txStartLeft;
            this.fty = this.tyStartLeft;
            if (this.startA < 0) {
                this.col = -this.startA;
                this.ftx += (float)this.col * this.tStepX;
                this.fty += (float)this.col * this.tStepY;
                this.startA = 0;
            }
            if (this.endA > this.width - 1) {
                this.endA = (short)(this.width - 1);
            }
            this.startRowIndex += this.width;
            this.screenPositionIndex = this.startRowIndex + this.startA;
            this.col = this.startRowIndex + this.endA;
            while (this.screenPositionIndex <= this.col) {
                if (this.pixelByteArray[this.screenPositionIndex] == -1) {
                    this.tx = (short)this.ftx;
                    this.ty = (short)this.fty;
                    this.pixelByteArray[this.screenPositionIndex] = this.myModel.getTexel(this.tx, this.ty);
                }
                ++this.screenPositionIndex;
                this.ftx += this.tStepX;
                this.fty += this.tStepY;
            }
            this.aStartLeft += this.polySlopeRight;
            this.aStartRight += this.polySlopeLeft;
            this.txStartLeft += this.slopeTxLeft;
            this.tyStartLeft += this.slopeTyLeft;
            this.txStartRight += this.slopeTxRight;
            this.tyStartRight += this.slopeTyRight;
            ++this.row;
        }
    }

    protected void updateFurthestArray() {
        this.i = 0;
        while (this.i < this.num_triangles) {
            this.polyClipTop = this.myModel.getTriangleVertexIndex(this.i, 0);
            this.polyClipOther = this.myModel.getTriangleVertexIndex(this.i, 1);
            this.polyClipBottom = this.myModel.getTriangleVertexIndex(this.i, 2);
            if (this.xValues[this.furthest[this.i]] > this.xValues[this.polyClipTop]) {
                this.furthest[this.i] = this.polyClipTop;
            }
            if (this.xValues[this.furthest[this.i]] > this.xValues[this.polyClipOther]) {
                this.furthest[this.i] = this.polyClipOther;
            }
            if (this.xValues[this.furthest[this.i]] > this.xValues[this.polyClipBottom]) {
                this.furthest[this.i] = this.polyClipBottom;
            }
            ++this.i;
        }
    }

    private boolean cullable2() {
        if (this.clockwiseCull) {
            if (this.polyOther + 1 != this.polyTop) {
                return this.polyOther != 2 || this.polyTop != 0;
            }
            return false;
        }
        if (this.polyOther - 1 != this.polyTop) {
            return this.polyTop != 2 || this.polyOther != 0;
        }
        return false;
    }

    private boolean cullable() {
        if (this.clockwiseCull) {
            if (this.polyOther != this.polyTop + 1) {
                return this.polyTop != 2 || this.polyOther != 0;
            }
            return false;
        }
        if (this.polyOther != this.polyTop - 1) {
            return this.polyOther != 2 || this.polyTop != 0;
        }
        return false;
    }

    protected void updateSortedTriangles() {
        this.aBoolean = false;
        this.col = this.num_triangles - 1;
        this.row = -1;
        while (this.row < this.col) {
            this.aBoolean = false;
            --this.col;
            this.i = ++this.row;
            while (this.i < this.col) {
                if (this.xValues[this.furthest[this.sortedTriangles[this.i]]] < this.xValues[this.furthest[this.sortedTriangles[this.i + 1]]]) {
                    this.startA = this.sortedTriangles[this.i];
                    this.sortedTriangles[this.i] = this.sortedTriangles[this.i + 1];
                    this.sortedTriangles[this.i + 1] = this.startA;
                    this.aBoolean = true;
                }
                ++this.i;
            }
            if (!this.aBoolean) {
                return;
            }
            this.aBoolean = false;
            this.i = this.col;
            while (this.i >= this.row) {
                if (this.xValues[this.furthest[this.sortedTriangles[this.i]]] < this.xValues[this.furthest[this.sortedTriangles[this.i + 1]]]) {
                    this.startA = this.sortedTriangles[this.i];
                    this.sortedTriangles[this.i] = this.sortedTriangles[this.i + 1];
                    this.sortedTriangles[this.i + 1] = this.startA;
                    this.aBoolean = true;
                }
                --this.i;
            }
            if (this.aBoolean) continue;
            return;
        }
    }
}

