/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public abstract class MDLModel
implements Runnable {
    private Thread modelLoader;
    private boolean modelReady = false;
    static final int MDL_VER = 6;
    private URL modelURL;
    private MDLModelTracker theBoss;
    private boolean modelError = false;
    private int[] loadframes;
    private int[] loadSkins;
    private int shiftY;

    public void setModelTracker(MDLModelTracker mDLModelTracker) {
        this.theBoss = mDLModelTracker;
    }

    public String getFramesString() {
        return String.valueOf(this.getNumberOfFrames()) + "/" + this.getTotalFrames();
    }

    public String getSkinsString() {
        return String.valueOf(this.getNumberOfSkins()) + "/" + this.getTotalSkins();
    }

    public boolean getModelError() {
        return this.modelError;
    }

    public boolean getModelReady() {
        return this.modelReady;
    }

    public String getAuthorInfo() {
        return "Super class Copyright T.J.Grey 1998";
    }

    public String getAuthorName() {
        return "unknown";
    }

    public void readModel(URL uRL, int[] nArray, int[] nArray2, int n) {
        this.modelReady = false;
        this.modelURL = uRL;
        this.loadframes = nArray;
        this.loadSkins = nArray2;
        this.shiftY = n;
        this.modelLoader = new Thread((Runnable)this, "MDLModelLoader");
        this.modelLoader.setPriority(10);
        this.modelLoader.start();
    }

    public void stopCall() {
        if (this.modelLoader != null && this.modelLoader.isAlive()) {
            this.modelLoader.stop();
            this.modelReady = false;
        }
    }

    public void run() {
        this.readModelThread(this.modelURL, this.loadframes, this.loadSkins, this.shiftY);
        this.modelReady = true;
        this.theBoss.modelReady();
        this.modelLoader = null;
    }

    public int getYShift() {
        return this.shiftY;
    }

    public abstract int getCurrentSkinIndex();

    public abstract void setCurrentSkinIndex(int var1);

    public abstract int getCurrentFrameIndex();

    public abstract void setCurrentFrameIndex(int var1);

    public abstract int getNumberOfAnimationFrames(int var1, int var2);

    public abstract int getTotalFrames();

    public abstract int getTotalSkins();

    public abstract void nextFrame();

    public abstract void lastFrame();

    public abstract void nextSkin();

    public abstract void lastSkin();

    public abstract String getFrameName();

    public abstract String getModelFormat();

    public abstract float getBoundingRadius();

    public abstract int getNumberOfSkins();

    public abstract int getSkinWidth();

    public abstract int getSkinHeight();

    public abstract int getNumberOfVertices();

    public abstract int getNumberOfTriangles();

    public abstract int getNumberOfFrames();

    public abstract byte getTexel(short var1, short var2);

    public abstract short getTriangleVertexIndex(int var1, int var2);

    public abstract float getVertexX(int var1);

    public abstract float getVertexY(int var1);

    public abstract float getVertexZ(int var1);

    public abstract boolean getClockwiseCull();

    public abstract short getSkinVertexS(int var1, int var2);

    public abstract short getSkinVertexT(int var1, int var2);

    public abstract int getFrameDelayMillis();

    protected abstract void readModelThread(URL var1, int[] var2, int[] var3, int var4);

    protected void setModelError(boolean bl) {
        this.modelError = bl;
    }

    protected void showStatus(String string) {
        this.theBoss.showStatus(string);
    }

    protected void debug(String string) {
        this.theBoss.debugOut(string);
    }

    protected void yield() {
        Thread.yield();
    }

    protected int intFromFourBytes(byte[] byArray) {
        int n = 0;
        n |= (byArray[0] & 0xFF) << 24;
        n |= (byArray[1] & 0xFF) << 16;
        n |= (byArray[2] & 0xFF) << 8;
        return n |= byArray[3] & 0xFF;
    }

    protected float floatFromFourBytes(byte[] byArray) {
        float f = 0.0f;
        int n = this.intFromFourBytes(byArray);
        f = Float.intBitsToFloat(n);
        return f;
    }

    protected int readInt(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        int n = 0;
        while (n < 4) {
            byArray[3 - n] = (byte)inputStream.read();
            ++n;
        }
        return this.intFromFourBytes(byArray);
    }

    protected float readFloat(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        int n = 0;
        while (n < 4) {
            byArray[3 - n] = (byte)inputStream.read();
            ++n;
        }
        return this.floatFromFourBytes(byArray);
    }

    protected boolean checkNeg(boolean bl, float f, String string) {
        if (f < 0.0f) {
            if (bl) {
                this.modelError = true;
                System.out.println("MDLView: Error " + string + " is negative");
                System.out.println("       loading will continue but rendering will not be possible");
            } else {
                System.out.println("MDLView: Warning... " + string + " is negative");
            }
            return true;
        }
        return false;
    }

    protected boolean checkShort(int n, String string) {
        if (n > Short.MAX_VALUE) {
            this.modelError = true;
            System.out.println("MDLView: Error " + string + " greater than " + Short.MAX_VALUE);
            System.out.println("       loading may continue but rendering will not be possible");
            return true;
        }
        return false;
    }
}

