// ===========================================================================
// $Source: d:/source/master/crusher/src/render.h,v $
// $Revision: 1.22 $
// $Date: 1998/08/04 01:38:02 $
// ===========================================================================
// Copyright (C) 1998 Tom Conder <blitz@gazpacho.net>. All Rights Reserved.
//
// BY USING ANY PORTION OF THIS SOFTWARE, YOU AGREE TO THE FOLLOWING
// TERMS AND CONDITIONS:
// 
// Tom Conder, "THE AUTHOR", grants you, "THE USER", a non-exclusive,
// royalty free, license to use this software in source and binary code
// form, provided the user does not utilize the software in a manner
// which is disparaging to the author and the user acknowledges the
// author in any derivative work.
// 
// This software is provided "AS IS," without a warranty of any kind. ALL
// EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING
// ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. THE AUTHOR SHALL NOT
// BE LIABLE FOR ANY DAMAGES SUFFERED BY THE USER AS A RESULT OF USING,
// MODIFYING OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT
// WILL THE AUTHOR BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR
// DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE
// DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY,
// ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE, EVEN IF THE
// AUTHOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
// ===========================================================================
// Project:    Crusher md2 viewer
//
// File:       render.h
//
// Written:    16 Jun. 1998 - Tom Conder <blitz@gazpacho.net>
//
// Description:
//    This is the header file for the module that draws the model.
//
// Modifications:
// $Log$
// ===========================================================================
#ifndef __RENDER_H
#define __RENDER_H

void AdjustHorzOffset		(const int);
void AdjustVertOffset		(const int);
void AdjustXRot				(const int);
void AdjustYRot				(const int);
void AdjustZRot				(const int);
UINT CheckTexture			(const pcx_t *, const model_t *);
void DisplayMessage			(LPCTSTR);
void DrawFrame				(HDC, const pcx_t *, const model_t *);
void DrawTriangle			(const triangle_t *, const pcx_t *);
void End3D					(pcx_t *, model_t *);
void FreeModel				(model_t *);
UINT Init3D					(HWND, pcx_t *, model_t *);
UINT LoadModel				(HDC, LPTSTR, pcx_t *, model_t *, BOOL);
UINT LoadTexture			(HDC, LPTSTR, pcx_t *, model_t *);
UINT Resize					(HWND, int, int, const pcx_t *);
void SetXRot				(const int);
void SetYRot				(const int);
void SetZRot				(const int);

#endif // __RENDER_H
